/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class CheckBoxList
extends JList {
    DefaultListModel mode = new DefaultListModel();

    public CheckBoxList() {
        this.setModel(this.mode);
        this.setToCheckBoxStyle();
    }

    public void removeAllItems() {
        this.mode.removeAllElements();
    }

    public void addItem(String s) {
        this.mode.addElement(new CheckableItem(s));
    }

    @Override
    public Object[] getSelectedValues() {
        int n = this.mode.size();
        Object[] res = new Object[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            CheckableItem item = (CheckableItem)this.mode.elementAt(i);
            if (!item.isSelected()) continue;
            res[k++] = item.str;
        }
        if (k < n) {
            Object[] res1 = new Object[k];
            System.arraycopy(res, 0, res1, 0, k);
            return res1;
        }
        return res;
    }

    private void setToCheckBoxStyle() {
        this.setCellRenderer(new CheckListRenderer());
        this.setSelectionMode(0);
        this.setBorder(new EmptyBorder(0, 4, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckBoxList list = CheckBoxList.this;
                int index = list.locationToIndex(e.getPoint());
                if (index >= 0) {
                    CheckableItem item;
                    item.setSelected(!(item = (CheckableItem)list.getModel().getElementAt(index)).isSelected());
                    Rectangle rect = list.getCellBounds(index, index);
                    list.repaint(rect);
                }
            }
        });
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckListRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(null);
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(((CheckableItem)value).isSelected());
            this.setFont(list.getFont());
            this.setText(value.toString());
            return this;
        }
    }

    class CheckableItem {
        private String str;
        private boolean isSelected;

        public CheckableItem(String str) {
            this.str = str;
            this.isSelected = false;
        }

        public void setSelected(boolean b) {
            this.isSelected = b;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }
    }
}

