/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ValueChangedListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class ComboTextFieldEx
extends JComboBox
implements ItemListener {
    boolean ishandel = false;
    String oldText = "";
    ValueChangedListener listener = null;
    boolean enabledEvent = false;

    public ComboTextFieldEx() {
        this(true);
    }

    public ComboTextFieldEx(boolean editable) {
        this.setBorder(LineBorder.createBlackLineBorder());
        Font font = new Font(this.getFont().getName(), 0, 12);
        this.setFont(font);
        BasicComboBoxEditor comboedit = new BasicComboBoxEditor();
        this.setEditable(true);
        this.setEditor(comboedit);
        JTextField tf = (JTextField)comboedit.getEditorComponent();
        tf.setMaximumSize(new Dimension(200, 10));
        tf.setEditable(editable);
        tf.setBackground(Color.white);
        GuiUtils.addWindowsEditorHotKey(tf);
        this.addItemListener(this);
    }

    public ComboTextFieldEx(String[] items) {
        this(false);
        this.setList(items);
    }

    public void setEnabledEvent(boolean b) {
        this.enabledEvent = b;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (!this.ishandel && this.enabledEvent && event.getStateChange() == 1) {
            this.ishandel = true;
            String newText = (String)this.getSelectedItem();
            if (newText == null) {
                newText = "";
            }
            if (this.valueChanged(this, newText = newText.trim())) {
                this.oldText = newText;
            } else {
                this.setSelectedItem(this.oldText);
            }
        }
        this.ishandel = false;
    }

    public void setList(Vector vector) {
        this.ishandel = true;
        this.setModel(new DefaultComboBoxModel(vector));
        this.ishandel = false;
    }

    public void setList(String[] ss) {
        this.ishandel = true;
        this.setModel(new DefaultComboBoxModel<String>(ss));
        this.ishandel = false;
    }

    public void setValueChangedListener(ValueChangedListener listener) {
        this.listener = listener;
    }

    public boolean valueChanged(Object Source, String value) {
        if (this.listener != null) {
            return this.listener.valueChanged(Source, value);
        }
        return true;
    }

    public String getText() {
        JTextField tf = (JTextField)this.getEditor().getEditorComponent();
        return tf.getText();
    }

    public void setText(String value) {
        this.ishandel = true;
        JTextField tf = (JTextField)this.getEditor().getEditorComponent();
        if (value == null) {
            value = "";
        }
        tf.setText(value);
        this.oldText = value;
        this.setSelectedItem(value);
        this.ishandel = false;
    }
}

