/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.map.MappingException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class FileOrUrlOpenDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static MessageCatalog msgCatalog;
    public static String DLG_FREESEL;
    private static File defaultFile;
    private static String defaultUrl;
    protected boolean is_OK = false;
    protected JFileChooser chooser;
    protected JTextArea textArea;
    protected JTextField urlField;
    protected JCheckBox urlEnabled;
    protected JPanel urlPanel;
    protected JComboBox encodingField;
    private File selectedFile = null;
    private boolean enabledInputUrl;
    private boolean enabledSelectEncoding;
    private boolean enabledViewer;
    private int viewLines;
    private boolean isXml = true;

    public static File getDefaultFile() {
        return defaultFile;
    }

    public FileOrUrlOpenDialog(Frame parent) {
        super(parent, null, true);
        this.init(null, null, true, true, true, 30);
    }

    public FileOrUrlOpenDialog(Frame parent, FileFilter filter, String defaultPath) {
        super(parent, null, true);
        this.init(filter, defaultPath, true, true, true, 30);
    }

    public FileOrUrlOpenDialog(Frame parent, FileFilter filter, String defaultPath, boolean enabledInputUrl, boolean enabledSelectEncoding, boolean enabledViewer, int viewLines) {
        super(parent, null, true);
        this.init(filter, defaultPath, enabledInputUrl, enabledSelectEncoding, enabledViewer, viewLines);
    }

    public FileOrUrlOpenDialog(Dialog parent) {
        super(parent, null, true);
        this.init(null, null, true, true, true, 30);
    }

    public FileOrUrlOpenDialog(Dialog parent, FileFilter filter, String defaultPath) {
        super(parent, null, true);
        this.init(filter, defaultPath, true, true, true, 30);
    }

    public FileOrUrlOpenDialog(Dialog parent, FileFilter filter, String defaultPath, boolean enabledInputUrl, boolean enabledSelectEncoding, boolean enabledViewer, int viewLines) {
        super(parent, null, true);
        this.init(filter, defaultPath, enabledInputUrl, enabledSelectEncoding, enabledViewer, viewLines);
    }

    private void init(FileFilter filter, String defaultPath, boolean enabledInputUrl, boolean enabledSelectEncoding, boolean enabledViewer, int viewLines) {
        File f;
        JCheckBox urlEnabled;
        this.enabledInputUrl = enabledInputUrl;
        this.enabledSelectEncoding = enabledSelectEncoding;
        this.enabledViewer = enabledViewer;
        this.viewLines = viewLines;
        this.urlField = new JTextField("");
        this.urlEnabled = urlEnabled = new JCheckBox("URL:");
        this.urlPanel = new JPanel();
        this.urlPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.urlPanel.setLayout(new BorderLayout());
        this.urlPanel.add((Component)urlEnabled, "West");
        this.urlPanel.add((Component)this.urlField, "Center");
        this.urlField.setEnabled(false);
        this.chooser = new JFileChooser(){
            private JCheckBox urlE1;
            {
                this.urlE1 = urlEnabled;
            }

            @Override
            public void updateUI() {
                MetalFileChooserUI ui = new MetalFileChooserUI(this){
                    private Action approveSelectionAction;
                    {
                        this.approveSelectionAction = new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (urlE1 != null && urlE1.isSelected()) {
                                    String url = urlE1.getText();
                                    if (url != null) {
                                        url = url.trim();
                                    }
                                    if (url != null && url.length() > 0) {
                                        this.getFileChooser().approveSelection();
                                    }
                                    return;
                                }
                                String filename = this.getFileName();
                                FileSystemView fs = this.getFileChooser().getFileSystemView();
                                File dir = this.getFileChooser().getCurrentDirectory();
                                if (filename != null) {
                                    filename = filename.trim();
                                }
                                if (filename != null && !filename.equals("")) {
                                    File selectedFile = fs.createFileObject(filename);
                                    if (!selectedFile.isAbsolute()) {
                                        selectedFile = fs.createFileObject(dir, filename);
                                    }
                                    if (selectedFile.isDirectory() && this.getFileChooser().isTraversable(selectedFile) && !this.getFileChooser().isDirectorySelectionEnabled()) {
                                        this.getFileChooser().setCurrentDirectory(selectedFile);
                                    } else if (!selectedFile.isDirectory() && this.getFileChooser().isFileSelectionEnabled() || selectedFile.isDirectory() && this.getFileChooser().isDirectorySelectionEnabled()) {
                                        this.getFileChooser().setSelectedFile(selectedFile);
                                        this.getFileChooser().approveSelection();
                                    }
                                    return;
                                }
                            }
                        };
                    }

                    @Override
                    public Action getApproveSelectionAction() {
                        return this.approveSelectionAction;
                    }
                };
                this.setUI(ui);
                this.setFileView(this.getUI().getFileView(this));
                boolean useAcceptAllFileFilter = this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
                if (useAcceptAllFileFilter) {
                    this.addChoosableFileFilter(this.getAcceptAllFileFilter());
                }
            }
        };
        this.chooser.setMultiSelectionEnabled(false);
        if (filter != null) {
            this.chooser.setFileFilter(filter);
        }
        if (defaultPath != null && defaultPath.length() > 0) {
            f = new File(defaultPath);
            if (!f.exists()) {
                f = defaultFile;
            }
        } else {
            f = defaultFile;
        }
        if (f != null) {
            if (f.isFile()) {
                this.chooser.setCurrentDirectory(f.getParentFile());
                this.chooser.setSelectedFile(f);
            } else {
                this.chooser.setCurrentDirectory(f);
            }
        }
        this.selectedFile = this.chooser.getSelectedFile();
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        try {
            Font font = new Font("Monospaced", 0, 12);
            this.textArea.setFont(font);
        }
        catch (Exception font) {
            // empty catch block
        }
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        String[] rs = MIME2Java.getAllStandardEncoding();
        String[] rs1 = new String[rs.length + 1];
        rs1[0] = DLG_FREESEL;
        System.arraycopy(rs, 0, rs1, 1, rs.length);
        this.encodingField = new JComboBox<String>(rs1);
        this.encodingField.addActionListener(this);
        if (enabledSelectEncoding) {
            textPanel.add((Component)this.encodingField, "North");
        }
        textPanel.add((Component)new JScrollPane(this.textArea), "Center");
        textPanel.setBorder(BorderFactory.createCompoundBorder());
        textPanel.setPreferredSize(new Dimension(300, 80));
        if (this.enabledViewer) {
            this.chooser.setAccessory(textPanel);
        }
        this.getContentPane().setLayout(new BorderLayout());
        if (this.enabledInputUrl) {
            this.getContentPane().add((Component)this.urlPanel, "North");
        }
        this.getContentPane().add((Component)this.chooser, "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FileOrUrlOpenDialog.this.setVisible(false);
            }
        });
        this.chooser.addActionListener(this);
        urlEnabled.addActionListener(this);
        this.urlField.addActionListener(this);
        this.chooser.addPropertyChangeListener(this);
        Rectangle rect = this.getParent().getBounds();
        this.setLocation(rect.x + (rect.width - this.getWidth()) / 2, rect.y + (rect.height - this.getHeight()) / 2);
    }

    public void setXml(boolean b) {
        this.isXml = b;
    }

    public void setFileFilter(FileFilter filter) {
        if (this.chooser != null) {
            this.chooser.resetChoosableFileFilters();
            this.chooser.setFileFilter(filter);
        }
    }

    public void setDefaultFile(File file) {
        if (this.chooser != null) {
            if (file.isFile()) {
                this.chooser.setCurrentDirectory(file.getParentFile());
                this.chooser.setSelectedFile(file);
            } else {
                this.chooser.setCurrentDirectory(file);
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.preview();
            this.repaint();
        }
        super.setVisible(b);
    }

    public void setFileSelectionMode(int mode) {
        this.chooser.setFileSelectionMode(mode);
    }

    public void setApproveButtonText(String text) {
        this.chooser.setApproveButtonText(text);
    }

    public void setApproveButtonToolTipText(String text) {
        this.chooser.setApproveButtonToolTipText(text);
    }

    public String getURL() {
        if (this.is_OK) {
            File f;
            if (this.urlEnabled.isSelected()) {
                return this.urlField.getText();
            }
            defaultFile = f = this.chooser.getSelectedFile();
            if (f != null) {
                try {
                    return f.toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public File getFile() {
        if (this.is_OK && !this.urlEnabled.isSelected()) {
            return this.chooser.getSelectedFile();
        }
        return null;
    }

    public String getEncoding() {
        String encoding = (String)this.encodingField.getSelectedItem();
        if (DLG_FREESEL.equals(encoding)) {
            encoding = null;
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            this.encodingField.setSelectedIndex(0);
        } else {
            this.encodingField.setSelectedItem(encoding);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.urlEnabled) {
            this.urlField.setEnabled(this.urlEnabled.isSelected());
            this.chooser.setEnabled(!this.urlEnabled.isSelected());
        } else if (obj == this.urlField) {
            if (this.urlEnabled.isSelected()) {
                this.preview();
            }
        } else if (obj == this.encodingField) {
            this.preview();
        } else {
            this.selectedFile = this.chooser.getSelectedFile();
            String cmd = evt.getActionCommand();
            if ("ApproveSelection".equals(cmd)) {
                if (this.urlEnabled.isSelected()) {
                    if (this.urlField.getText().trim().length() == 0) {
                        return;
                    }
                    this.is_OK = true;
                    this.setVisible(false);
                } else {
                    if (this.selectedFile == null) {
                        return;
                    }
                    this.is_OK = true;
                    this.setVisible(false);
                }
            } else {
                this.is_OK = false;
                this.setVisible(false);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ((propertyName.equals("SelectedFileChangedProperty") || propertyName.equals("directoryChanged")) && !this.urlEnabled.isSelected()) {
            this.selectedFile = (File)evt.getNewValue();
            this.preview();
        }
    }

    protected void preview() {
        block30: {
            String encoding = (String)this.encodingField.getSelectedItem();
            if (DLG_FREESEL.equals(encoding)) {
                encoding = null;
            }
            if (this.urlEnabled.isSelected()) {
                String us = this.urlField.getText().trim();
                if (us.length() == 0) {
                    this.textArea.setText("");
                    return;
                }
                try {
                    XReader in;
                    URL url = new URL(us);
                    if (encoding == null) {
                        if (this.isXml) {
                            in = XReader.createReader(url, false);
                        } else {
                            try {
                                in = XReader.createReader(url.openStream(), "JISAutoDetect");
                            }
                            catch (UnsupportedEncodingException e1) {
                                in = XReader.createReader(new InputStreamReader(url.openStream()));
                            }
                        }
                    } else {
                        in = XReader.createReader(url.openStream(), encoding);
                    }
                    this.preview(in);
                    try {
                        in.close();
                        break block30;
                    }
                    catch (Exception exception) {
                    }
                }
                catch (IOException e) {
                    this.textArea.setText("");
                    String s = MappingException.getMessage("INVALID_URL", us) + "\n" + e.getMessage();
                    if (this.isVisible()) {
                        JOptionPane.showMessageDialog(this, s);
                    }
                    break block30;
                }
                catch (Exception e) {
                    this.textArea.setText("");
                    if (this.isVisible()) {
                        JOptionPane.showMessageDialog(this, e.toString());
                    }
                    break block30;
                }
            }
            if (this.selectedFile != null && this.selectedFile.isFile() && this.selectedFile.canRead()) {
                try {
                    XReader in;
                    if (encoding == null) {
                        if (this.enabledSelectEncoding) {
                            if (this.isXml) {
                                in = XReader.createReader(this.selectedFile);
                            } else {
                                try {
                                    in = XReader.createReader(new FileInputStream(this.selectedFile), "JISAutoDetect");
                                }
                                catch (UnsupportedEncodingException e1) {
                                    in = XReader.createReader(new FileReader(this.selectedFile));
                                }
                            }
                        } else {
                            in = XReader.createReader(new FileReader(this.selectedFile));
                        }
                    } else {
                        in = XReader.createReader(new FileInputStream(this.selectedFile), encoding);
                    }
                    this.preview(in);
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    this.textArea.setText("");
                    JOptionPane.showMessageDialog(this, e.getMessage());
                }
            } else {
                this.textArea.setText("");
            }
        }
    }

    protected void preview(XReader in) {
        this.textArea.setText("");
        try {
            for (int i = 0; i < this.viewLines && !in.isEOF(); ++i) {
                char c;
                StringBuffer strTmp = new StringBuffer();
                for (int j = 0; j < 500 && (c = in.getc()) != '\u0000'; ++j) {
                    if (c == '\r') {
                        if (in.isChar('\n')) {
                            in.getc();
                            break;
                        }
                    } else if (c == '\n') break;
                    strTmp.append(c);
                }
                String s = strTmp.toString();
                this.textArea.append(s);
                this.textArea.append("\n");
            }
        }
        catch (Exception e) {
            this.textArea.setText("");
        }
        try {
            this.textArea.setSelectionStart(0);
            this.textArea.setSelectionEnd(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setSize(600, 480);
        f.setVisible(true);
        FileOrUrlOpenDialog dlg = new FileOrUrlOpenDialog(f);
        dlg.setVisible(true);
    }

    static {
        String classbase;
        int k;
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if ((k = (classbase = FileOrUrlOpenDialog.class.getName()).lastIndexOf(".")) > 0) {
            classbase = classbase.substring(0, k + 1);
        }
        classbase = classbase + "MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.out.println(e1);
                System.exit(1);
            }
        }
        DLG_FREESEL = msgCatalog.getMessage("DLG_FREESEL");
        defaultFile = null;
        defaultUrl = null;
    }
}

