/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.lang.MessageCatalog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.SoftBevelBorder;

public class FindDialog
extends JDialog
implements ActionListener {
    boolean isok = false;
    JButton cancelButton;
    JButton okButton;
    ComboTextFieldEx textField;
    JRadioButton forwardButton;
    JRadioButton backwardButton;
    JCheckBox ignoreCaseBox;
    static MessageCatalog msgCatalog;

    static String getMessage(String MsgId) {
        return msgCatalog.getMessage(MsgId);
    }

    public FindDialog(Frame parent) {
        super(parent, true);
        this.setTitle(FindDialog.getMessage("CMD_FIND"));
        JPanel tp = FindDialog.createVerticalPanel(true);
        tp.add(new JLabel(FindDialog.getMessage("DLG_FIND_CHAR")));
        this.textField = new ComboTextFieldEx(true);
        tp.add(this.textField);
        this.textField.setMaximumSize(new Dimension(this.textField.getMaximumSize().width, this.textField.getPreferredSize().height));
        this.forwardButton = new JRadioButton(FindDialog.getMessage("BUTTON_FINDNEXT"), true);
        tp.add(this.forwardButton);
        this.backwardButton = new JRadioButton(FindDialog.getMessage("BUTTON_FINDPREV"));
        tp.add(this.backwardButton);
        ButtonGroup g = new ButtonGroup();
        g.add(this.forwardButton);
        g.add(this.backwardButton);
        this.ignoreCaseBox = new JCheckBox(FindDialog.getMessage("DLG_INGCASE"));
        tp.add(this.ignoreCaseBox);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tp, "Center");
        tp = new JPanel();
        tp.setLayout(new FlowLayout(1, 10, 10));
        this.okButton = new JButton(FindDialog.getMessage("BUTTON_OK"));
        this.okButton.addActionListener(this);
        tp.add(this.okButton);
        this.cancelButton = new JButton(FindDialog.getMessage("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(this);
        tp.add(this.cancelButton);
        this.getContentPane().add((Component)tp, "South");
        this.setSize(405, 305);
        Rectangle rect = parent.getBounds();
        Dimension size = this.getSize();
        this.setLocation(rect.x + (rect.width - size.width) / 2, rect.y + (rect.height - size.height) / 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FindDialog.this.setVisible(false);
            }
        });
    }

    public static JPanel createVerticalPanel(boolean threeD) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        if (threeD) {
            p.setBorder(new SoftBevelBorder(1));
        }
        return p;
    }

    public boolean isOK() {
        return this.isok;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText().trim();
    }

    public boolean isForward() {
        return this.forwardButton.isSelected();
    }

    public void setForward(boolean b) {
        this.forwardButton.setSelected(b);
        this.backwardButton.setSelected(!b);
    }

    public boolean ignoreCase() {
        return !this.ignoreCaseBox.isSelected();
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCaseBox.setSelected(!b);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.isok = false;
        }
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.isok = true;
            String text = this.textField.getText();
            if (text != null) {
                int n = this.textField.getItemCount();
                boolean has = false;
                for (int i = 0; i < n; ++i) {
                    if (!text.equals(this.textField.getItemAt(i))) continue;
                    has = true;
                    break;
                }
                if (!has) {
                    this.textField.addItem(text);
                }
            }
        }
        this.setVisible(false);
    }

    static {
        String classbase;
        int k;
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if ((k = (classbase = FindDialog.class.getName()).lastIndexOf(".")) > 0) {
            classbase = classbase.substring(0, k + 1);
        }
        classbase = classbase + "MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.out.println(e1);
                System.exit(1);
            }
        }
    }
}

