/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.ImageLoader;
import com.argo21.common.lang.MessageCatalog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class GuiUtils {
    public static final Border raisedBorder;
    public static final Border lightLoweredBorder;
    public static final Border loweredBorder;
    public static final Font defaultFont;
    public static final Font boldFont;
    public static final Font bigFont;
    public static final Font bigBoldFont;
    public static final Font reallyBigFont;
    public static final Font reallyBigBoldFont;
    public static final String lookAndFeelClassName;
    static MessageCatalog msgCatalog;

    public static String getMessage(String MsgId) {
        return msgCatalog.getMessage(MsgId);
    }

    public static String getMessage(String MsgId, String[] parameter) {
        return msgCatalog.getMessage(MsgId, parameter);
    }

    public static ImageIcon loadImageIcon(String name2) {
        return ImageLoader.load(name2 + ".gif", name2);
    }

    public static ImageIcon loadImageIcon(String filename, String desc) {
        return ImageLoader.load(filename, desc);
    }

    public static void setLookAndFeel(String lf, Component c) {
        try {
            LookAndFeel bak = UIManager.getLookAndFeel();
            UIManager.setLookAndFeel(lf);
            SwingUtilities.updateComponentTreeUI(c);
            UIManager.setLookAndFeel(bak);
        }
        catch (UnsupportedLookAndFeelException exc) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                SwingUtilities.updateComponentTreeUI(c);
            }
            catch (Exception exc2) {
                System.err.println("Could not load LookAndFeel: " + exc2);
            }
        }
        catch (Exception exc1) {
            System.err.println("Could not load LookAndFeel: " + exc1);
        }
    }

    public static JMenu createMenu(String menuName, String[][] items, Hashtable actions) {
        JMenu menu = new JMenu(menuName);
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = null;
            try {
                act = (Action)actions.get(itemname);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (act == null) continue;
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    String s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
        }
        return menu;
    }

    public static JToolBar createToolbar(String[] names, Hashtable actions) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton(icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(new Insets(1, 1, 1, 1));
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
        }
        return toolbar;
    }

    public static JPanel createHorizontalPanel(boolean threeD) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        if (threeD) {
            p.setBorder(loweredBorder);
        }
        return p;
    }

    public static JPanel createVerticalPanel(boolean threeD) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        if (threeD) {
            p.setBorder(loweredBorder);
        }
        return p;
    }

    public static JTextArea createTextView(boolean lineWrap) {
        JTextArea text = new JTextArea();
        text.setLineWrap(lineWrap);
        text.setEditable(false);
        return text;
    }

    public static Frame getFrame(Component c) {
        Component parent;
        for (parent = c; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    public static void addWindowsEditorHotKey(JTextComponent textComponent) {
        Action[] actions = textComponent.getActions();
        Action act = GuiUtils.findAction("copy-to-clipboard", actions);
        KeyStroke key = KeyStroke.getKeyStroke(155, 2);
        textComponent.registerKeyboardAction(act, key, 0);
        act.setEnabled(true);
        act = GuiUtils.findAction("paste-from-clipboard", actions);
        key = KeyStroke.getKeyStroke(155, 1);
        textComponent.registerKeyboardAction(act, key, 0);
        act.setEnabled(true);
        act = GuiUtils.findAction("delete-next", actions);
        key = KeyStroke.getKeyStroke(127, 0);
        textComponent.registerKeyboardAction(act, key, 0);
        act.setEnabled(true);
    }

    public static void addPopmenu(JTextComponent textComponent) {
        GuiUtils.addPopmenu(textComponent, true, true);
    }

    public static void addPopmenu(JTextComponent textComponent, boolean surpportUndo, boolean surpportHotKey) {
        KeyStroke key;
        JPopupMenu menu = new JPopupMenu();
        Action[] actions = textComponent.getActions();
        Action[] actions1 = new Action[10];
        JMenuItem item = menu.add(new JMenuItem(GuiUtils.getMessage("CMD_CUT"), GuiUtils.loadImageIcon("cut.gif", "CUT")));
        actions1[0] = GuiUtils.findAction("cut-to-clipboard", actions);
        item.addActionListener(actions1[0]);
        item.setName("cut-to-clipboard");
        if (surpportHotKey) {
            key = KeyStroke.getKeyStroke(88, 2);
            item.setAccelerator(key);
            textComponent.registerKeyboardAction(actions1[0], key, 0);
        }
        item = menu.add(new JMenuItem(GuiUtils.getMessage("CMD_COPY"), GuiUtils.loadImageIcon("copy.gif", "COPY")));
        actions1[1] = GuiUtils.findAction("copy-to-clipboard", actions);
        item.addActionListener(actions1[1]);
        item.setName("copy-to-clipboard");
        if (surpportHotKey) {
            key = KeyStroke.getKeyStroke(155, 2);
            item.setAccelerator(key);
            textComponent.registerKeyboardAction(actions1[1], key, 0);
        }
        item = menu.add(new JMenuItem(GuiUtils.getMessage("CMD_PASTE"), GuiUtils.loadImageIcon("paste.gif", "PASTE")));
        actions1[2] = GuiUtils.findAction("paste-from-clipboard", actions);
        item.addActionListener(actions1[2]);
        item.setName("paste-from-clipboard");
        if (surpportHotKey) {
            key = KeyStroke.getKeyStroke(155, 1);
            item.setAccelerator(key);
            textComponent.registerKeyboardAction(actions1[2], key, 0);
        }
        menu.addSeparator();
        item = menu.add(new JMenuItem(GuiUtils.getMessage("CMD_SELECTALL")));
        actions1[4] = GuiUtils.findAction("select-all", actions);
        item.addActionListener(actions1[4]);
        item.setName("select-all");
        if (surpportHotKey) {
            key = KeyStroke.getKeyStroke(65, 2);
            item.setAccelerator(key);
            textComponent.registerKeyboardAction(actions1[4], key, 0);
        }
        menu.addSeparator();
        item = menu.add(new JMenuItem(GuiUtils.getMessage("CMD_DELETE"), GuiUtils.loadImageIcon("delete.gif", "DELETE")));
        actions1[6] = GuiUtils.findAction("delete-next", actions);
        item.addActionListener(actions1[6]);
        item.setName("delete-next");
        if (surpportHotKey) {
            key = KeyStroke.getKeyStroke(127, 0);
            item.setAccelerator(key);
            textComponent.registerKeyboardAction(actions1[6], key, 0);
        }
        UndoHandler undoHandler = null;
        if (surpportUndo) {
            KeyStroke key2;
            undoHandler = new UndoHandler();
            item = menu.add(new JMenuItem(GuiUtils.getMessage("CMD_UNDO"), GuiUtils.loadImageIcon("undo.gif", "UNDO")));
            actions1[7] = undoHandler.getUndoAction();
            item.addActionListener(actions1[7]);
            item.setName("undo");
            if (surpportHotKey) {
                key2 = KeyStroke.getKeyStroke(90, 2);
                item.setAccelerator(key2);
                textComponent.registerKeyboardAction(actions1[7], key2, 0);
            }
            item = menu.add(new JMenuItem(GuiUtils.getMessage("CMD_REDO"), GuiUtils.loadImageIcon("redo.gif", "REDO")));
            actions1[8] = undoHandler.getRedoAction();
            item.addActionListener(actions1[8]);
            item.setName("redo");
            if (surpportHotKey) {
                key2 = KeyStroke.getKeyStroke(90, 3);
                item.setAccelerator(key2);
                textComponent.registerKeyboardAction(actions1[8], key2, 0);
            }
            Document doc = textComponent.getDocument();
            doc.addUndoableEditListener(undoHandler);
            undoHandler.discardAllEdits();
            undoHandler.die();
        }
        PopupMenuHandeler handler = new PopupMenuHandeler(textComponent, menu, actions1);
        textComponent.addMouseListener(handler);
    }

    public static Action findAction(String name2, Action[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            if (!name2.equals(actions[i].getValue("Name"))) continue;
            return actions[i];
        }
        return null;
    }

    public static MouseListener getPopupMenuHandeler(JTextComponent textComponent, JPopupMenu menu) {
        return new PopupMenuHandeler(textComponent, menu, null);
    }

    public static void setCursorToComponent(Component c, Cursor cursor) {
        c.setCursor(cursor);
        if (c instanceof Container) {
            Container cont = (Container)c;
            int count2 = cont.getComponentCount();
            for (int i = 0; i < count2; ++i) {
                GuiUtils.setCursorToComponent(cont.getComponent(i), cursor);
            }
        }
    }

    static {
        String classbase;
        int k;
        raisedBorder = new BevelBorder(0);
        lightLoweredBorder = new BevelBorder(1, Color.white, Color.gray);
        loweredBorder = new SoftBevelBorder(1);
        defaultFont = new Font("Dialog", 0, 12);
        boldFont = new Font("Dialog", 1, 12);
        bigFont = new Font("Dialog", 0, 18);
        bigBoldFont = new Font("Dialog", 1, 18);
        reallyBigFont = new Font("Dialog", 0, 18);
        reallyBigBoldFont = new Font("Dialog", 1, 24);
        lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if ((k = (classbase = GuiUtils.class.getName()).lastIndexOf(".")) > 0) {
            classbase = classbase.substring(0, k + 1);
        }
        classbase = classbase + "MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.out.println(e1);
                System.exit(1);
            }
        }
    }

    public static class UndoHandler
    implements UndoableEditListener {
        private UndoManager undo = new UndoManager();
        private UndoAction undoAction = new UndoAction(this.undo);
        private RedoAction redoAction = new RedoAction(this.undo);

        public UndoHandler() {
            this.undoAction.setRedoAction(this.redoAction);
            this.redoAction.setUndoAction(this.undoAction);
        }

        public UndoManager getUndoManager() {
            return this.undo;
        }

        public Action getUndoAction() {
            return this.undoAction;
        }

        public Action getRedoAction() {
            return this.redoAction;
        }

        public void discardAllEdits() {
            this.undo.discardAllEdits();
        }

        public void die() {
            this.undo.die();
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.undo.addEdit(e.getEdit());
            this.undoAction.update();
            this.redoAction.update();
        }
    }

    public static class RedoAction
    extends AbstractAction {
        private UndoManager undo;
        private UndoAction undoAction;

        public RedoAction(UndoManager undo) {
            super("redo");
            this.undo = undo;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.update();
            if (this.undoAction != null) {
                this.undoAction.update();
            }
        }

        public void setUndoAction(UndoAction undoAction) {
            this.undoAction = undoAction;
        }

        protected void update() {
            if (this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "redo");
            }
        }
    }

    public static class UndoAction
    extends AbstractAction {
        private UndoManager undo;
        private RedoAction redoAction;

        public UndoAction(UndoManager undo) {
            super("undo");
            this.undo = undo;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            if (this.redoAction != null) {
                this.redoAction.update();
            }
        }

        public void setRedoAction(RedoAction redoAction) {
            this.redoAction = redoAction;
        }

        protected void update() {
            if (this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "undo");
            }
        }
    }

    static class PopupMenuHandeler
    implements MouseListener {
        JPopupMenu menu;
        Action[] actions;
        JTextComponent textComponent;

        public PopupMenuHandeler(JTextComponent textComponent, JPopupMenu menu, Action[] actions) {
            this.textComponent = textComponent;
            this.menu = menu;
            this.actions = actions;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int mod = e.getModifiers();
            if (mod == 8 || mod == 4) {
                this.setMenuItemEnabled();
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void setMenuItemEnabled() {
            boolean b = this.textComponent.getSelectionEnd() != this.textComponent.getSelectionStart();
            int n = this.menu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = this.menu.getComponent(i);
                String name2 = c.getName();
                if ("cut-to-clipboard".equals(name2) || "copy-to-clipboard".equals(name2) || "delete-next".equals(name2)) {
                    c.setEnabled(b);
                    continue;
                }
                if ("paste-from-clipboard".equals(name2) || "select-all".equals(name2)) {
                    c.setEnabled(true);
                    continue;
                }
                if (this.actions == null || this.actions[i] == null) continue;
                c.setEnabled(this.actions[i].isEnabled());
            }
        }
    }
}

