/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ViewerContent;
import com.argo21.common.gui.ViewerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JavaClassMemberViewer
extends JPanel
implements ViewerContent {
    public static final short FIELD = 1;
    public static final short METHOD = 2;
    JTree tree;
    DefaultMutableTreeNode root;
    DefaultTreeModel treeModel;
    private Font defaultFont = null;
    Class clazz;
    private short viewerType = 0;

    public JavaClassMemberViewer(Class clazz, short viewerType) {
        super(new BorderLayout());
        this.clazz = clazz;
        this.viewerType = viewerType;
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode(clazz.getName());
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this.tree);
        this.add((Component)new JScrollPane(this.tree), "Center");
        if ((viewerType & 1) != 0) {
            this.listAllField();
        }
        if ((viewerType & 2) != 0) {
            this.listAllMethod();
        }
        this.tree.expandRow(0);
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.tree.addTreeSelectionListener(l);
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public Object getSelectedObject() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node.getUserObject();
    }

    public Member showDialog(Component parent) {
        return this.showDialog(parent, null);
    }

    public Member showDialog(Component parent, String title) {
        Frame frame = GuiUtils.getFrame(parent);
        ViewerDialog dlg = new ViewerDialog(frame, this, true);
        Rectangle rect = frame.getBounds();
        dlg.setSize(frame.getWidth() - 100, frame.getHeight() - 100);
        dlg.setLocation(rect.x + (rect.width - dlg.getWidth()) / 2, rect.y + (rect.height - dlg.getHeight()) / 2);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.setVisible(true);
        Object obj = dlg.getSelectedObject();
        if (obj instanceof Member) {
            return (Member)obj;
        }
        return null;
    }

    private void listAllField() {
        Field[] fds = this.clazz.getFields();
        for (int i = 0; i < fds.length; ++i) {
            this.root.add(new DefaultMutableTreeNode(fds[i]));
        }
    }

    private void listAllMethod() {
        Constructor<?>[] cons = this.clazz.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            this.root.add(new DefaultMutableTreeNode(cons[i]));
        }
        Method[] mds = this.clazz.getMethods();
        for (int i = 0; i < mds.length; ++i) {
            this.root.add(new DefaultMutableTreeNode(mds[i]));
        }
    }
}

