/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ViewerContent;
import com.argo21.common.gui.ViewerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JavaClassViewer
extends JPanel
implements ViewerContent {
    public static final String fileSeparator = System.getProperty("file.separator", "/");
    JTree tree;
    DefaultMutableTreeNode root;
    DefaultTreeModel treeModel;
    private Font defaultFont = null;
    String[] paths;

    public JavaClassViewer(String[] paths) {
        super(new BorderLayout());
        this.paths = paths;
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode("class viewer");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this.tree);
        this.add((Component)new JScrollPane(this.tree), "Center");
        this.listAllPackage();
        this.tree.expandRow(0);
    }

    void listAllPackage() {
        for (int i = 0; i < this.paths.length; ++i) {
            File file = new File(this.paths[i]);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(file);
            this.treeModel.insertNodeInto(node, this.root, i);
            if (file.isDirectory()) {
                this.listAllDirPackage(node, file);
            } else {
                String s = this.paths[i].toLowerCase();
                if (s.endsWith(".zip") || s.endsWith(".jar")) {
                    this.listAllZipPackage(node, file);
                }
            }
            this.tree.expandPath(new TreePath(node.getPath()));
        }
    }

    private void listAllDirPackage(DefaultMutableTreeNode parent, File file) {
        int i;
        String path = file.getPath();
        String[] files = file.list();
        this.sortFiles(files);
        for (i = 0; i < files.length; ++i) {
            MyFile file1 = new MyFile(file, files[i]);
            if (!file1.isDirectory()) continue;
            parent.add(new DynamicTreeNode(file1));
            files[i] = null;
        }
        for (i = 0; i < files.length; ++i) {
            String s = files[i];
            if (s == null || !s.endsWith(".class")) continue;
            s = s.substring(0, s.length() - 6);
            this.addClassNameToTreeNode(parent, s);
        }
    }

    private void sortFiles(String[] files) {
        int n = files.length;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (files[i].compareToIgnoreCase(files[j]) <= 0) continue;
                String s = files[i];
                files[i] = files[j];
                files[j] = s;
            }
        }
    }

    private void addClassNameToTreeNode(DefaultMutableTreeNode treenode, String classname) {
        treenode.add(new DefaultMutableTreeNode(classname));
    }

    private void listAllZipPackage(DefaultMutableTreeNode parent, File file) {
        ZipFile zipfile;
        try {
            zipfile = new ZipFile(file);
        }
        catch (IOException e) {
            return;
        }
        Enumeration<? extends ZipEntry> enu = zipfile.entries();
        Vector<ZipEntry> v = new Vector<ZipEntry>();
        block2: while (enu.hasMoreElements()) {
            ZipEntry entry = enu.nextElement();
            String s = entry.getName();
            int n = v.size();
            for (int i = 0; i < n; ++i) {
                ZipEntry entry1 = (ZipEntry)v.elementAt(i);
                if (s.compareToIgnoreCase(entry1.getName()) >= 0) continue;
                v.insertElementAt(entry, i);
                continue block2;
            }
            v.addElement(entry);
        }
        Hashtable store = new Hashtable();
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            String s;
            ZipEntry entry = (ZipEntry)v.elementAt(i);
            if (entry.isDirectory() || !(s = entry.getName()).endsWith(".class")) continue;
            int pos = (s = s.substring(0, s.length() - 6)).lastIndexOf("/");
            if (pos <= 0) {
                this.addClassNameToTreeNode(parent, s);
                continue;
            }
            String nodename = s.substring(pos + 1);
            String parentpath = s.substring(0, pos);
            DefaultMutableTreeNode pn = this.getPackageNode(parent, store, parentpath);
            if (pn == null) continue;
            this.addClassNameToTreeNode(pn, nodename);
        }
    }

    DefaultMutableTreeNode getPackageNode(DefaultMutableTreeNode jarNode, Hashtable store, String path) {
        DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)store.get(path);
        if (treenode != null) {
            return treenode;
        }
        int pos = path.lastIndexOf("/");
        if (pos < 0) {
            treenode = new DefaultMutableTreeNode(path);
            store.put(path, treenode);
            jarNode.add(treenode);
            return treenode;
        }
        String nodename = path.substring(pos + 1);
        String parentpath = path.substring(0, pos);
        DefaultMutableTreeNode parent = this.getPackageNode(jarNode, store, parentpath);
        if (parent != null) {
            treenode = new DefaultMutableTreeNode(nodename);
            store.put(path, treenode);
            parent.add(treenode);
            return treenode;
        }
        return null;
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public Object getSelectedObject() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getChildCount() > 0) {
            return null;
        }
        int n = path.getPathCount();
        if (n < 2) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 2; i < n; ++i) {
            sb.append(path.getPathComponent(i).toString());
            if (i >= n - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public String showDialog(Component parent) {
        return this.showDialog(parent, null);
    }

    public String showDialog(Component parent, String title) {
        Frame frame = GuiUtils.getFrame(parent);
        ViewerDialog dlg = new ViewerDialog(frame, this, true);
        Rectangle rect = frame.getBounds();
        dlg.setSize(frame.getWidth() - 100, frame.getHeight() - 100);
        dlg.setLocation(rect.x + (rect.width - dlg.getWidth()) / 2, rect.y + (rect.height - dlg.getHeight()) / 2);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.setVisible(true);
        return (String)dlg.getSelectedObject();
    }

    public static void main(String[] args) {
        JFrame fream = new JFrame();
        JavaClassViewer v = new JavaClassViewer(new String[]{"e:\\eSooner3\\lib\\eSooner.jar"});
        fream.setContentPane(v);
        fream.setBounds(100, 100, 1000, 800);
        fream.setVisible(true);
    }

    static class MyFile
    extends File {
        public MyFile(String parent, String child) {
            super(parent, child);
        }

        public MyFile(File parent, String child) {
            super(parent, child);
        }

        @Override
        public String toString() {
            String s = this.getPath();
            int k = s.lastIndexOf("/");
            if (k > 0) {
                return s.substring(k + 1);
            }
            k = s.lastIndexOf("\\");
            if (k > 0) {
                return s.substring(k + 1);
            }
            return s;
        }
    }

    class DynamicTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasLoaded;

        public DynamicTreeNode(Object obj) {
            super(obj);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getChildCount() {
            if (!this.hasLoaded) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.hasLoaded = true;
            Object obj = this.getUserObject();
            if (obj instanceof File) {
                JavaClassViewer.this.listAllDirPackage(this, (File)obj);
            }
        }
    }
}

