/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.JavaClassMemberViewer;
import com.argo21.common.gui.ViewerContent;
import com.argo21.common.gui.ViewerDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JavaMethodDefiner
extends JSplitPane
implements ViewerContent,
TreeSelectionListener {
    Class clazz;
    static String[] tableHead = new String[]{"\u30d1\u30e9\u30e1\u30fc\u30bf\u578b", "\u30d1\u30e9\u30e1\u30fc\u30bf\u5024"};
    Object[][] tableData = new Object[0][2];
    JavaClassMemberViewer methodsViewer;
    JTable parametersList;

    public JavaMethodDefiner(Class clazz) {
        super(0, false);
        this.clazz = clazz;
        this.methodsViewer = new JavaClassMemberViewer(clazz, 2);
        MyTableModel dataModel = new MyTableModel();
        this.parametersList = new JTable(dataModel);
        TableColumnModel columnmodel = this.parametersList.getColumnModel();
        TableColumn column = columnmodel.getColumn(0);
        column.setPreferredWidth(160);
        this.parametersList.sizeColumnsToFit(1);
        this.parametersList.setColumnSelectionAllowed(false);
        JScrollPane sp = new JScrollPane(this.parametersList);
        this.setTopComponent(this.methodsViewer);
        this.setBottomComponent(sp);
        this.setDividerSize(2);
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public Object getSelectedObject() {
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.showAllParameters();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.setDividerLocation(0.5);
    }

    private static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public String showDialog(Component parent) {
        Frame frame = GuiUtils.getFrame(parent);
        ViewerDialog dlg = new ViewerDialog(frame, this, true);
        Rectangle rect = frame.getBounds();
        dlg.setSize(frame.getWidth() / 2, frame.getHeight() / 2);
        dlg.setLocation(rect.x + (rect.width - dlg.getWidth()) / 2, rect.y + (rect.height - dlg.getHeight()) / 2);
        dlg.setVisible(true);
        return String.valueOf(dlg.getSelectedObject());
    }

    void showAllParameters() {
        Object method = this.methodsViewer.getSelectedObject();
        if (method == null) {
            this.clearAllParameters();
            return;
        }
        Class<?> returnType = null;
        Class<?>[] parameterTypes = null;
        if (method instanceof Constructor) {
            parameterTypes = ((Constructor)method).getParameterTypes();
        } else if (method instanceof Method) {
            returnType = ((Method)method).getReturnType();
            if (returnType == Void.TYPE) {
                returnType = null;
            }
            parameterTypes = ((Method)method).getParameterTypes();
        }
        if (parameterTypes == null) {
            return;
        }
        int n = parameterTypes.length;
        int k = 0;
        if (returnType != null && returnType != Void.TYPE) {
            k = 1;
            this.tableData = new Object[n + 1][2];
            this.tableData[0][0] = JavaMethodDefiner.getTypeName(returnType) + "(\u623b\u308a\u5024)";
            this.tableData[0][1] = "";
        } else {
            this.tableData = new Object[n][2];
        }
        for (int i = 0; i < n; ++i) {
            String s = JavaMethodDefiner.getTypeName(parameterTypes[i]);
            this.tableData[k + i][0] = s;
            this.tableData[k + i][1] = s.endsWith("[]") ? "{}" : "";
        }
        MyTableModel ts = (MyTableModel)this.parametersList.getModel();
        ts.fireTableDataChanged();
    }

    void clearAllParameters() {
        this.tableData = new Object[0][2];
        MyTableModel ts = (MyTableModel)this.parametersList.getModel();
        ts.fireTableDataChanged();
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return tableHead.length;
        }

        @Override
        public int getRowCount() {
            return JavaMethodDefiner.this.tableData.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return JavaMethodDefiner.this.tableData[row][col];
        }

        @Override
        public String getColumnName(int column) {
            return tableHead[column];
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            JavaMethodDefiner.this.tableData[row][column] = aValue;
            this.fireTableChanged(new TableModelEvent(this, row, row, column));
        }
    }
}

