/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ListTextFieldEx
extends JPanel
implements PropertyEditor,
ActionListener {
    boolean ishandel = false;
    boolean enabledEvent = false;
    private JList accessList;
    private JTextField accessField;
    private JButton addAccess;
    private JButton delAccess;
    String propertyName = null;

    public ListTextFieldEx() {
        this(new String[0]);
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public ListTextFieldEx(String[] items) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        c.weightx = 1.0;
        this.setLayout(new GridBagLayout());
        this.accessList = new JList(new DefaultListModel());
        this.add((Component)new JScrollPane(this.accessList), c);
        ++c.gridy;
        JPanel button_p = new JPanel();
        button_p.setLayout(new FlowLayout(1, 20, 0));
        this.addAccess = new JButton(ImageLoader.load("toup.gif", "add"));
        button_p.add(this.addAccess);
        this.delAccess = new JButton(ImageLoader.load("todown.gif", "del"));
        button_p.add(this.delAccess);
        this.addAccess.setBorder(null);
        this.addAccess.setMargin(new Insets(0, 0, 0, 0));
        this.addAccess.addActionListener(this);
        this.delAccess.setBorder(null);
        this.delAccess.setMargin(new Insets(0, 0, 0, 0));
        this.delAccess.addActionListener(this);
        this.add((Component)button_p, c);
        ++c.gridy;
        this.accessField = new JTextField("");
        this.add((Component)this.accessField, c);
        GuiUtils.addWindowsEditorHotKey(this.accessField);
        this.setList(items);
    }

    public void setEnabledEvent(boolean b) {
        this.enabledEvent = b;
    }

    public void setList(Vector vector) {
        this.ishandel = true;
        DefaultListModel v = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            v.addElement(vector.elementAt(i));
        }
        this.accessList.setModel(v);
        this.accessField.setText("");
        this.ishandel = false;
    }

    public void setList(String[] ss) {
        this.ishandel = true;
        DefaultListModel<String> v = new DefaultListModel<String>();
        for (int i = 0; i < ss.length; ++i) {
            v.addElement(ss[i]);
        }
        this.accessList.setModel(v);
        this.accessField.setText("");
        this.ishandel = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        int index = this.accessList.getSelectedIndex();
        if (obj == this.addAccess) {
            String value = this.accessField.getText().trim();
            if (value.length() == 0) {
                return;
            }
            DefaultListModel dm = (DefaultListModel)this.accessList.getModel();
            if (!dm.contains(value)) {
                if (!this.maybeInsert(this, value)) {
                    return;
                }
                Object[] res = new String[dm.getSize()];
                dm.copyInto(res);
                if (index < 0) {
                    dm.addElement(value);
                } else {
                    dm.insertElementAt(value, index);
                }
                Object[] res1 = new String[dm.getSize()];
                dm.copyInto(res1);
                this.valueChanged(this, (String[])res1);
                this.accessField.setText("");
                if (this.propertyName != null) {
                    this.firePropertyChange(this.propertyName, res, res1);
                }
            }
        } else if (obj == this.delAccess && index >= 0) {
            DefaultListModel dm = (DefaultListModel)this.accessList.getModel();
            String s = (String)dm.elementAt(index);
            if (!this.maybeRemove(this, s)) {
                return;
            }
            Object[] res = new String[dm.getSize()];
            dm.copyInto(res);
            dm.removeElementAt(index);
            Object[] res1 = new String[dm.getSize()];
            dm.copyInto(res1);
            this.valueChanged(this, (String[])res1);
            this.accessField.setText(s);
            if (this.propertyName != null) {
                this.firePropertyChange(this.propertyName, res, res1);
            }
        }
    }

    public boolean maybeInsert(Object source, String value) {
        return true;
    }

    public boolean maybeRemove(Object source, String value) {
        return true;
    }

    public void valueChanged(Object source, String[] value) {
    }

    @Override
    public Object getValue() {
        DefaultListModel mo = (DefaultListModel)this.accessList.getModel();
        Object[] res = new String[mo.size()];
        mo.copyInto(res);
        return res;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String[]) {
            this.setList((String[])value);
        } else if (value.getClass().isArray()) {
            Object[] objs = (Object[])value;
            String[] res = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                res[i] = String.valueOf(res[i]);
            }
            this.setList(res);
        } else {
            String[] res = new String[]{String.valueOf(value)};
            this.setList(res);
        }
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return "\"" + this.getAsText() + "\"";
    }

    @Override
    public String getAsText() {
        StringBuffer sb = new StringBuffer();
        DefaultListModel dm = (DefaultListModel)this.accessList.getModel();
        int n = dm.getSize();
        for (int i = 0; i < n; ++i) {
            sb.append(dm.elementAt(i));
            if (i >= n - 1) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    @Override
    public void setAsText(String text) {
        StringTokenizer sz = new StringTokenizer(text, "|");
        DefaultListModel dm = (DefaultListModel)this.accessList.getModel();
        dm.clear();
        while (sz.hasMoreElements()) {
            dm.addElement(sz.nextElement());
        }
        this.accessField.setText("");
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

