/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.FindDialog;
import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.StatusChangedListener;
import com.argo21.common.gui.TextDragAndDrop;
import com.argo21.common.lang.MessageCatalog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TextEditorPanel
extends JScrollPane
implements TextDragAndDrop,
FocusListener {
    public static final String CMD_UNDO = "UNDO";
    public static final String CMD_REDO = "REDO";
    public static final String CMD_CUT = "CUT";
    public static final String CMD_COPY = "COPY";
    public static final String CMD_PASTE = "PASTE";
    public static final String CMD_DELETE = "DELETE";
    public static final String CMD_SELECTALL = "SELECTALL";
    public static final String CMD_FINDTEXT = "FINDTEXT";
    public static final String CMD_REFINDTEXT = "REFINDTEXT";
    public static final String CMD_MARKLINE = "MARKLINE";
    public static final int CAN_UNDO = 1;
    public static final int CAN_REDO = 2;
    public static final int CAN_CUT = 4;
    public static final int CAN_COPY = 8;
    public static final int CAN_PASTE = 16;
    public static final int CAN_DELETE = 32;
    public static final int CAN_SELECTALL = 64;
    public static final int CAN_FINDTEXT = 128;
    public static final int CAN_REFINDTEXT = 256;
    public static final int CAN_MARKLINE = 512;
    static MessageCatalog msgCatalog = GuiUtils.msgCatalog;
    private JTextArea textEdit = null;
    private boolean textEditChanged = false;
    private UndoableEditListener undoHandler;
    private DocumentListener myDocumentListener;
    private UndoManager undo;
    private UndoAction undoAction = new UndoAction(ImageLoader.load("undo.gif", "UNDO"));
    private RedoAction redoAction = new RedoAction(ImageLoader.load("redo.gif", "REDO"));
    private Vector myStatusChangedListener = new Vector(1);
    private Hashtable actions = null;
    private boolean isForward = true;
    private boolean ignoreCase = true;
    private String searchText = "";
    FindDialog findDialog = null;
    private Color highcolor = Color.red;

    static String getMessage(String MsgId) {
        return msgCatalog.getMessage(MsgId);
    }

    public TextEditorPanel() {
        this(true);
    }

    public TextEditorPanel(boolean editable) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.textEdit = new JTextArea();
        this.textEdit.setEditable(editable);
        this.textEdit.getCaret().setVisible(true);
        try {
            Font font = new Font("Monospaced", 0, 12);
            this.textEdit.setFont(font);
        }
        catch (Exception font) {
            // empty catch block
        }
        this.undoHandler = new UndoHandler();
        this.myDocumentListener = new DocumentHandler();
        this.undo = new UndoManager();
        this.setViewportView(this.textEdit);
        this.registActions();
        this.textEdit.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TextEditorPanel.this.caretChanged(e);
            }
        });
        this.textEdit.addFocusListener(this);
        this.textEdit.setMargin(new Insets(0, 10, 0, 0));
        DefaultHighlighter dh = new DefaultHighlighter();
        dh.setDrawsLayeredHighlights(false);
        this.textEdit.setHighlighter(dh);
    }

    @Override
    public void focusGained(FocusEvent e) {
        boolean en = this.textEdit.isEditable() && this.textEdit.getCaret().getDot() != this.textEdit.getCaret().getMark();
        boolean change = false;
        Action a = (Action)this.actions.get(CMD_CUT);
        if (a.isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        if ((a = (Action)this.actions.get(CMD_COPY)).isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        if ((a = (Action)this.actions.get(CMD_DELETE)).isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        en = this.searchText != null & this.searchText.length() > 0;
        a = (Action)this.actions.get(CMD_REFINDTEXT);
        if (a.isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        if (change) {
            this.textpropertyChange();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void addStatusChangedListener(StatusChangedListener l) {
        if (!this.myStatusChangedListener.contains(l)) {
            this.myStatusChangedListener.addElement(l);
        }
    }

    public void removeStatusChangedListener(StatusChangedListener l) {
        this.myStatusChangedListener.removeElement(l);
    }

    public void clearStatusChangedListener() {
        this.myStatusChangedListener.removeAllElements();
    }

    public Action getAction(String cmd) {
        return cmd == null ? null : (Action)this.actions.get(cmd);
    }

    void textpropertyChange() {
        for (int i = 0; i < this.myStatusChangedListener.size(); ++i) {
            StatusChangedListener o = (StatusChangedListener)this.myStatusChangedListener.elementAt(i);
            o.statusChanged(1, new EventObject(this));
        }
    }

    void caretChanged(CaretEvent e) {
        if (!this.textEdit.getCaret().isVisible()) {
            this.textEdit.getCaret().setVisible(true);
        }
        boolean en = this.textEdit.isEditable() && e.getDot() != e.getMark();
        boolean change = false;
        Action a = (Action)this.actions.get(CMD_CUT);
        if (a.isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        if ((a = (Action)this.actions.get(CMD_COPY)).isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        if ((a = (Action)this.actions.get(CMD_DELETE)).isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        en = this.searchText != null & this.searchText.length() > 0;
        a = (Action)this.actions.get(CMD_REFINDTEXT);
        if (a.isEnabled() != en) {
            a.setEnabled(en);
            change = true;
        }
        if (change) {
            this.textpropertyChange();
        }
    }

    public void changeContents() {
        this.textEditChanged = true;
        Highlighter high = this.textEdit.getHighlighter();
        Highlighter.Highlight[] hs = high.getHighlights();
        for (int i = 0; i < hs.length; ++i) {
            try {
                int pos = hs[i].getStartOffset();
                int pos1 = hs[i].getEndOffset();
                int line = this.textEdit.getLineOfOffset(pos);
                int start = this.textEdit.getLineStartOffset(line);
                int end = this.textEdit.getLineEndOffset(line);
                if (start == end) {
                    start = this.textEdit.getLineStartOffset(++line);
                    end = this.textEdit.getLineEndOffset(line);
                }
                if (pos == start && pos1 == end) continue;
                high.changeHighlight(hs[i], start, end);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clearChanged() {
        this.textEditChanged = false;
    }

    public boolean isChanged() {
        return this.textEditChanged;
    }

    public String getText() {
        return this.textEdit.getText();
    }

    public void setTabSize(int size) {
        this.textEdit.setTabSize(size);
    }

    public int getTabSize() {
        return this.textEdit.getTabSize();
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        PlainDocument doc = new PlainDocument();
        try {
            StringReader rd = new StringReader(text);
            EditorKit kit = this.textEdit.getUI().getEditorKit(this.textEdit);
            kit.read(rd, (Document)doc, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDocument(doc);
    }

    public void setText(Reader in) {
        PlainDocument doc = new PlainDocument();
        try {
            EditorKit kit = this.textEdit.getUI().getEditorKit(this.textEdit);
            kit.read(in, (Document)doc, 0);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.setDocument(doc);
    }

    public void write(Writer out) throws IOException {
        this.textEdit.write(out);
    }

    public void setDocument(Document doc) {
        Document oldDoc = this.textEdit.getDocument();
        if (oldDoc != doc) {
            if (oldDoc != null) {
                oldDoc.removeUndoableEditListener(this.undoHandler);
                oldDoc.removeDocumentListener(this.myDocumentListener);
            }
            doc.addUndoableEditListener(this.undoHandler);
            doc.addDocumentListener(this.myDocumentListener);
            this.textEdit.setDocument(doc);
        } else {
            oldDoc.removeUndoableEditListener(this.undoHandler);
            oldDoc.removeDocumentListener(this.myDocumentListener);
            oldDoc.addUndoableEditListener(this.undoHandler);
            oldDoc.addDocumentListener(this.myDocumentListener);
        }
        this.textEditChanged = false;
        try {
            this.textEdit.select(0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.undo != null) {
            this.undo.discardAllEdits();
            this.undo.die();
            this.undoAction.update();
            this.redoAction.update();
        }
    }

    public Document getDocument() {
        Document doc = this.textEdit.getDocument();
        doc.removeUndoableEditListener(this.undoHandler);
        doc.removeDocumentListener(this.myDocumentListener);
        return doc;
    }

    public Segment getSegment() {
        Document doc = this.textEdit.getDocument();
        int n = doc.getLength();
        Segment seg = new Segment();
        try {
            doc.getText(0, n, seg);
        }
        catch (Exception e) {
            seg.array = new char[0];
        }
        return seg;
    }

    public void refind() {
        int pos2;
        int pos1 = this.textEdit.getSelectionStart();
        int maxpos = pos1 > (pos2 = this.textEdit.getSelectionEnd()) ? pos1 : pos2;
        int minpos = pos1 > pos2 ? pos2 : pos1;
        int pos = this.isForward ? maxpos + 1 : minpos - 1;
        this.findText(this.searchText, pos, this.ignoreCase, this.isForward);
    }

    private Frame getFrame() {
        Container parent;
        for (parent = this; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    public void find() {
        String text;
        if (this.findDialog == null) {
            Frame f = this.getFrame();
            if (f == null) {
                return;
            }
            this.findDialog = new FindDialog(f);
        }
        if ((text = this.textEdit.getSelectedText()) == null || text.length() == 0) {
            this.findDialog.setText(this.searchText);
        } else {
            StringTokenizer st = new StringTokenizer(text, "\t\n\r");
            if (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.findDialog.setText(token);
            } else {
                this.findDialog.setText(this.searchText);
            }
        }
        this.findDialog.setIgnoreCase(this.ignoreCase);
        this.findDialog.setForward(this.isForward);
        this.findDialog.setVisible(true);
        if (!this.findDialog.isOK()) {
            return;
        }
        this.isForward = this.findDialog.isForward();
        this.ignoreCase = this.findDialog.ignoreCase();
        this.searchText = this.findDialog.getText();
        this.refind();
    }

    public void findText(String text, int pos, boolean ignoreCase, boolean forward) {
        if (text == null) {
            return;
        }
        int len = text.length();
        if (text.length() == 0) {
            return;
        }
        Segment seg = this.getSegment();
        if (seg.count == 0) {
            return;
        }
        if (forward) {
            char c;
            char c2 = c = ignoreCase ? Character.toLowerCase(text.charAt(0)) : text.charAt(0);
            while (pos < seg.count) {
                char c1;
                char c3 = c1 = ignoreCase ? Character.toLowerCase(seg.array[pos]) : seg.array[pos];
                if (c == c1 && pos + len < seg.count) {
                    boolean b = true;
                    for (int i = 1; i < len; ++i) {
                        char c32;
                        char c22 = ignoreCase ? Character.toLowerCase(text.charAt(i)) : text.charAt(i);
                        char c4 = c32 = ignoreCase ? Character.toLowerCase(seg.array[pos + i]) : seg.array[pos + i];
                        if (c22 == c32) continue;
                        b = false;
                        break;
                    }
                    if (b) {
                        this.textEdit.select(pos, pos + len);
                        break;
                    }
                }
                ++pos;
            }
        } else {
            char c;
            int last2 = len - 1;
            char c5 = c = ignoreCase ? Character.toLowerCase(text.charAt(last2)) : text.charAt(last2);
            while (pos > 0) {
                char c1;
                char c6 = c1 = ignoreCase ? Character.toLowerCase(seg.array[pos]) : seg.array[pos];
                if (c == c1 && pos - len > 0) {
                    boolean b = true;
                    for (int i = 1; i < len; ++i) {
                        char c3;
                        char c2 = ignoreCase ? Character.toLowerCase(text.charAt(last2 - i)) : text.charAt(last2 - i);
                        char c7 = c3 = ignoreCase ? Character.toLowerCase(seg.array[pos - i]) : seg.array[pos - i];
                        if (c2 == c3) continue;
                        b = false;
                        break;
                    }
                    if (b) {
                        this.textEdit.select(pos - len + 1, pos + 1);
                        break;
                    }
                }
                --pos;
            }
        }
    }

    public void setMarkColor(Color color) {
        this.highcolor = color;
    }

    public boolean setMark(int line) {
        --line;
        Highlighter h = this.textEdit.getHighlighter();
        try {
            MyHighlightPainter markPainter = new MyHighlightPainter(this.highcolor, true, false);
            h.addHighlight(this.textEdit.getLineStartOffset(line), this.textEdit.getLineEndOffset(line), markPainter);
            this.textEdit.repaint();
            return true;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public Object getMarkTag(int line) {
        --line;
        int start = -1;
        int end = -1;
        try {
            start = this.textEdit.getLineStartOffset(line);
            end = this.textEdit.getLineEndOffset(line);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (start < 0 || end < 0) {
            return null;
        }
        Highlighter h = this.textEdit.getHighlighter();
        Highlighter.Highlight[] hs = h.getHighlights();
        for (int i = 0; i < hs.length; ++i) {
            Highlighter.HighlightPainter hp;
            if (hs[i].getStartOffset() < start || hs[i].getEndOffset() > end || !((hp = hs[i].getPainter()) instanceof MyHighlightPainter) || !((MyHighlightPainter)hp).markPointer) continue;
            return hs[i];
        }
        return null;
    }

    public void removeMark(Object high) {
        Highlighter h = this.textEdit.getHighlighter();
        h.removeHighlight(high);
        this.textEdit.repaint();
    }

    public void clearAllMark() {
        Highlighter h = this.textEdit.getHighlighter();
        h.removeAllHighlights();
        this.textEdit.repaint();
    }

    public int[] getMarks() {
        Highlighter h = this.textEdit.getHighlighter();
        Highlighter.Highlight[] hs = h.getHighlights();
        int n = hs.length;
        int[] bks = new int[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            try {
                Highlighter.HighlightPainter hp = hs[i].getPainter();
                if (!(hp instanceof MyHighlightPainter) || !((MyHighlightPainter)hp).markPointer) continue;
                bks[k] = this.textEdit.getLineOfOffset(hs[i].getStartOffset()) + 1;
                ++k;
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (k != n) {
            int[] bks1 = new int[k];
            System.arraycopy(bks, 0, bks1, 0, k);
            return bks1;
        }
        return bks;
    }

    public void moveLineMark(int line) {
        Highlighter h = this.textEdit.getHighlighter();
        Highlighter.Highlight[] hs = h.getHighlights();
        for (int i = 0; i < hs.length; ++i) {
            Highlighter.HighlightPainter hp = hs[i].getPainter();
            if (!(hp instanceof MyHighlightPainter)) continue;
            MyHighlightPainter p = (MyHighlightPainter)hp;
            if (p.markLine) {
                p.markLine = false;
            }
            if (p.markLine || p.markPointer) continue;
            h.removeHighlight(hs[i]);
        }
        if (line <= 0) {
            this.textEdit.repaint();
            return;
        }
        --line;
        int start = -1;
        int end = -1;
        try {
            start = this.textEdit.getLineStartOffset(line);
            end = this.textEdit.getLineEndOffset(line);
        }
        catch (BadLocationException p) {
            // empty catch block
        }
        if (start < 0 || end < 0) {
            return;
        }
        hs = h.getHighlights();
        for (int i = 0; i < hs.length; ++i) {
            Highlighter.HighlightPainter hp = hs[i].getPainter();
            if (!(hp instanceof MyHighlightPainter) || hs[i].getStartOffset() < start || hs[i].getEndOffset() > end) continue;
            ((MyHighlightPainter)hp).markLine = true;
            this.textEdit.repaint();
            return;
        }
        MyHighlightPainter markPainter = new MyHighlightPainter(this.highcolor, false, true);
        try {
            h.addHighlight(start, end, markPainter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.textEdit.repaint();
        this.scrollToPos(start);
    }

    private void scrollToPos(int pos) {
        JViewport vp = this.getViewport();
        Rectangle rect = vp.getViewRect();
        Rectangle rect1 = null;
        try {
            rect1 = this.textEdit.modelToView(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rect1 == null) {
            return;
        }
        if (rect.y <= rect1.y && rect1.y <= rect.y + rect.height) {
            return;
        }
        rect.setLocation(0, rect1.y - rect.y);
        vp.scrollRectToVisible(rect);
    }

    public boolean selectLine(int line) {
        --line;
        try {
            int startpos = this.textEdit.getLineStartOffset(line);
            int endpos = this.textEdit.getLineEndOffset(line);
            this.textEdit.setCaretPosition(endpos);
            this.textEdit.moveCaretPosition(startpos);
            this.scrollToPos(startpos);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setCaretToLine(int line) {
        --line;
        try {
            int startpos = this.textEdit.getLineStartOffset(line);
            this.textEdit.setCaretPosition(startpos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void select(int startpos, int endpos) {
        this.textEdit.select(startpos, endpos);
    }

    public void setEditable(boolean b) {
        this.textEdit.setEditable(b);
        this.textEdit.getCaret().setVisible(true);
    }

    public void execCommand(String cmd) {
        Action a = (Action)this.actions.get(cmd);
        if (a != null) {
            ActionEvent ae = new ActionEvent(this, 1001, cmd);
            a.actionPerformed(ae);
        }
    }

    public int getEditorStatus() {
        int status = 0;
        if (((Action)this.actions.get(CMD_UNDO)).isEnabled()) {
            status |= 1;
        }
        if (((Action)this.actions.get(CMD_REDO)).isEnabled()) {
            status |= 2;
        }
        if (((Action)this.actions.get(CMD_CUT)).isEnabled()) {
            status |= 4;
        }
        if (((Action)this.actions.get(CMD_COPY)).isEnabled()) {
            status |= 8;
        }
        if (((Action)this.actions.get(CMD_PASTE)).isEnabled()) {
            status |= 0x10;
        }
        if (((Action)this.actions.get(CMD_DELETE)).isEnabled()) {
            status |= 0x20;
        }
        if (((Action)this.actions.get(CMD_SELECTALL)).isEnabled()) {
            status |= 0x40;
        }
        if (((Action)this.actions.get(CMD_FINDTEXT)).isEnabled()) {
            status |= 0x80;
        }
        if (((Action)this.actions.get(CMD_REFINDTEXT)).isEnabled()) {
            status |= 0x100;
        }
        if (((Action)this.actions.get(CMD_MARKLINE)).isEnabled()) {
            status |= 0x200;
        }
        return status;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.textEdit.requestFocus();
    }

    @Override
    public Component getDragComponent() {
        return this.textEdit;
    }

    @Override
    public String getSelectedText() {
        return this.textEdit.getSelectedText();
    }

    @Override
    public void setToolTipText(String text) {
        this.textEdit.setToolTipText(text);
    }

    public String getSelectWord() {
        char c;
        char c2;
        int p2;
        int p1;
        Document doc;
        int len;
        int k = this.textEdit.getSelectionStart();
        if (k >= (len = (doc = this.textEdit.getDocument()).getLength())) {
            k = len - 1;
        }
        if ((p1 = k - 100) < 0) {
            p1 = 0;
        }
        if ((p2 = k + 100) >= len) {
            p2 = len - 1;
        }
        String s = null;
        try {
            s = doc.getText(p1, p2 - p1 + 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (s == null) {
            return null;
        }
        k -= p1;
        for (p1 = k; p1 >= 0 && (Character.isLetterOrDigit(c2 = s.charAt(p1)) || c2 == '_'); --p1) {
        }
        ++p1;
        p2 = k;
        k = s.length();
        while (p2 < k && (Character.isLetterOrDigit(c = s.charAt(p2)) || c == '_')) {
            ++p2;
        }
        return p2 <= p1 ? null : s.substring(p1, p2);
    }

    public int getSelectLine() {
        int k = this.textEdit.getSelectionStart();
        try {
            return this.textEdit.getLineOfOffset(k) + 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public boolean dragStart(Component source, int x, int y) {
        String s = this.textEdit.getSelectedText();
        return s != null && s.trim().length() > 0;
    }

    @Override
    public boolean dragOver(Component source, int x, int y, String dragText) {
        if (source == this.textEdit) {
            return false;
        }
        int pos = this.textEdit.viewToModel(new Point(x, y));
        if (pos >= 0) {
            this.textEdit.setCaretPosition(pos);
            this.textEdit.setSelectionStart(pos);
            this.textEdit.setSelectionEnd(pos);
            this.textEdit.requestFocus();
        }
        return true;
    }

    @Override
    public boolean drop(Component source, int x, int y, String dragText) {
        if (source == this.textEdit) {
            return false;
        }
        this.textEdit.insert(dragText, this.textEdit.getSelectionStart());
        return true;
    }

    void turnMark() {
        int k = this.getSelectLine();
        if (k >= 0) {
            Object tag = this.getMarkTag(k);
            if (tag == null) {
                this.setMark(k);
            } else {
                this.removeMark(tag);
            }
        }
    }

    void registActions() {
        if (this.actions != null) {
            return;
        }
        this.actions = new Hashtable(23);
        Action[] actions1 = this.textEdit.getActions();
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName.equals("enabled")) {
                    TextEditorPanel.this.textpropertyChange();
                }
            }
        };
        for (int j = 0; j < actions1.length; ++j) {
            ImageIcon icon;
            String name2 = (String)actions1[j].getValue("Name");
            if (name2.equals("cut-to-clipboard")) {
                this.actions.put(CMD_CUT, actions1[j]);
                actions1[j].addPropertyChangeListener(pl);
                icon = ImageLoader.load("cut.gif", CMD_CUT);
                actions1[j].putValue("SmallIcon", icon);
                actions1[j].putValue("ShortDescription", TextEditorPanel.getMessage("CMD_CUT"));
                continue;
            }
            if (name2.equals("copy-to-clipboard")) {
                this.actions.put(CMD_COPY, actions1[j]);
                actions1[j].addPropertyChangeListener(pl);
                icon = ImageLoader.load("copy.gif", CMD_COPY);
                actions1[j].putValue("SmallIcon", icon);
                actions1[j].putValue("ShortDescription", TextEditorPanel.getMessage("CMD_COPY"));
                continue;
            }
            if (name2.equals("paste-from-clipboard")) {
                this.actions.put(CMD_PASTE, actions1[j]);
                actions1[j].addPropertyChangeListener(pl);
                icon = ImageLoader.load("paste.gif", CMD_PASTE);
                actions1[j].putValue("SmallIcon", icon);
                actions1[j].putValue("ShortDescription", TextEditorPanel.getMessage("CMD_PASTE"));
                continue;
            }
            if (name2.equals("select-all")) {
                this.actions.put(CMD_SELECTALL, actions1[j]);
                actions1[j].addPropertyChangeListener(pl);
                actions1[j].putValue("ShortDescription", TextEditorPanel.getMessage("CMD_SELECTALL"));
                continue;
            }
            if (!name2.equals("delete-next")) continue;
            this.actions.put(CMD_DELETE, actions1[j]);
            actions1[j].addPropertyChangeListener(pl);
            icon = ImageLoader.load("delete.gif", CMD_DELETE);
            actions1[j].putValue("SmallIcon", icon);
            actions1[j].putValue("ShortDescription", TextEditorPanel.getMessage("CMD_DELETE"));
        }
        this.undoAction.putValue("ShortDescription", TextEditorPanel.getMessage("CMD_UNDO"));
        this.undoAction.addPropertyChangeListener(pl);
        this.actions.put(CMD_UNDO, this.undoAction);
        this.redoAction.putValue("ShortDescription", TextEditorPanel.getMessage("CMD_REDO"));
        this.redoAction.addPropertyChangeListener(pl);
        this.actions.put(CMD_REDO, this.redoAction);
        ImageIcon icon = ImageLoader.load("find.gif", "FIND");
        String s = TextEditorPanel.getMessage("CMD_FIND");
        MyAction findAction = new MyAction(CMD_FINDTEXT, s, s, icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorPanel.this.find();
            }
        };
        findAction.setEnabled(true);
        this.actions.put(CMD_FINDTEXT, findAction);
        s = TextEditorPanel.getMessage("CMD_REFIND");
        MyAction refindAction = new MyAction(CMD_REFINDTEXT, s, s, null){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorPanel.this.refind();
            }
        };
        this.actions.put(CMD_REFINDTEXT, refindAction);
        s = TextEditorPanel.getMessage("CMD_MARKLINE");
        MyAction markAction = new MyAction(CMD_REFINDTEXT, s, s, null){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorPanel.this.turnMark();
            }
        };
        this.actions.put(CMD_MARKLINE, markAction);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("sdaglnsdlkg");
        TextEditorPanel t = new TextEditorPanel();
        f.setContentPane(t);
        t.setText("sdkajvkjsdfvksdkfvb\nsdkajvkjsdfvksdkfvb\nsdkajvkjs\ndfvksdkfvb\n");
        f.setSize(600, 600);
        f.setVisible(true);
        t.setMark(1);
        t.moveLineMark(2);
        t.selectLine(3);
    }

    static class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        boolean markPointer;
        boolean markLine;

        public MyHighlightPainter(Color c) {
            this(c, false, true);
        }

        public MyHighlightPainter(Color c, boolean markPointer, boolean markLine) {
            super(c);
            this.markLine = markLine;
            this.markPointer = markPointer;
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            Rectangle alloc = bounds.getBounds();
            try {
                TextUI mapper = c.getUI();
                Rectangle p0 = mapper.modelToView(c, offs0);
                Rectangle p1 = mapper.modelToView(c, offs1);
                Color color = this.getColor();
                if (color == null) {
                    g.setColor(c.getSelectionColor());
                } else {
                    g.setColor(color);
                }
                if (this.markPointer) {
                    g.fillOval(0, p0.y + p0.height / 2 - 3, 6, 6);
                }
                if (this.markLine) {
                    if (p0.y == p1.y) {
                        Rectangle r = p0.union(p1);
                        g.fillRect(r.x, r.y, r.width, r.height);
                    } else {
                        int p0ToMarginWidth = alloc.x + alloc.width - p0.x;
                        g.fillRect(p0.x, p0.y, p0ToMarginWidth, p0.height);
                        if (p0.y + p0.height != p1.y) {
                            g.fillRect(alloc.x, p0.y + p0.height, alloc.width, p1.y - (p0.y + p0.height));
                        }
                        g.fillRect(alloc.x, p1.y, p1.x - alloc.x, p1.height);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Color color = this.getColor();
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            if (this.markPointer) {
                try {
                    TextUI mapper = c.getUI();
                    Rectangle p0 = mapper.modelToView(c, offs0);
                    g.fillOval(0, p0.y + p0.height / 2 - 3, 6, 6);
                }
                catch (BadLocationException mapper) {
                    // empty catch block
                }
            }
            if (!this.markLine) {
                return null;
            }
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                g.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
                return alloc;
            }
            try {
                Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
                return r;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    class MyAction
    extends AbstractAction {
        MyAction(String name2, String description) {
            super(name2);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String description, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", description);
            this.setEnabled(false);
        }

        MyAction(String name2, String shortdes, String longdes, Icon icon) {
            super(name2, icon);
            this.putValue("ShortDescription", shortdes);
            this.putValue("LongDescription", longdes);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("redo");
            this.setEnabled(false);
        }

        public RedoAction(ImageIcon icon) {
            super("redo", icon);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextEditorPanel.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.update();
            TextEditorPanel.this.undoAction.update();
        }

        protected void update() {
            if (TextEditorPanel.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", TextEditorPanel.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("undo");
            this.setEnabled(false);
        }

        public UndoAction(ImageIcon icon) {
            super("undo", icon);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TextEditorPanel.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            TextEditorPanel.this.redoAction.update();
        }

        protected void update() {
            if (TextEditorPanel.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", TextEditorPanel.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            TextEditorPanel.this.undo.addEdit(e.getEdit());
            TextEditorPanel.this.undoAction.update();
            TextEditorPanel.this.redoAction.update();
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextEditorPanel.this.changeContents();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextEditorPanel.this.changeContents();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

