/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.gui;

import com.argo21.common.gui.ImageLoader;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class TreeCombo
extends JComboBox
implements ItemListener {
    static final int OFFSET = 16;
    boolean ishandel = false;
    boolean enabledEvent = false;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public TreeCombo(String root) {
        this(new DefaultTreeModel(new DefaultMutableTreeNode(root)));
    }

    public TreeCombo(DefaultTreeModel aTreeModel) {
        this.setModel(new TreeToListModel(aTreeModel));
        this.setRenderer(new ListEntryRenderer());
        this.addItemListener(this);
    }

    public void addItem(String item) {
        this.addItem(null, item);
    }

    public void addItem(String parentItem, String item) {
        TreeToListModel mode = (TreeToListModel)this.getModel();
        mode.addItem(parentItem, item);
    }

    @Override
    public void removeAllItems() {
        this.removeAllItems(null);
    }

    public void removeAllItems(String parentItem) {
        TreeToListModel mode = (TreeToListModel)this.getModel();
        mode.removeAllItems(parentItem);
    }

    public void setEnabledEvent(boolean b) {
        this.enabledEvent = b;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (!this.ishandel && this.enabledEvent && event.getStateChange() == 1) {
            this.ishandel = true;
            ListEntry et = (ListEntry)this.getSelectedItem();
            String s = et == null ? "" : et.object().toString();
            this.valueChanged(this, s);
        }
        this.ishandel = false;
    }

    public boolean valueChanged(Object source, String value) {
        return true;
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        ImageIcon leafIcon = ImageLoader.load("document.gif", "Document");
        ImageIcon nodeIcon = ImageLoader.load("folder.gif", "Folder");

        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListEntry listEntry = (ListEntry)value;
            if (listEntry != null) {
                this.setText(listEntry.object().toString());
                this.setIcon(listEntry.isNode() ? this.nodeIcon : this.leafIcon);
                Border border = index != -1 ? new EmptyBorder(0, 16 * listEntry.level(), 0, 0) : emptyBorder;
                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    if (index == -1) {
                        this.setOpaque(false);
                    } else {
                        this.setOpaque(true);
                    }
                } else {
                    this.setOpaque(true);
                }
                this.setBorder(border);
                if (isSelected) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    class ListEntry {
        Object object;
        int level;
        boolean isNode;

        public ListEntry(Object anObject, int aLevel, boolean isNode) {
            this.object = anObject;
            this.level = aLevel;
            this.isNode = isNode;
        }

        public Object object() {
            return this.object;
        }

        public int level() {
            return this.level;
        }

        public boolean isNode() {
            return this.isNode;
        }
    }

    class TreeToListModel
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        DefaultTreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(DefaultTreeModel aTreeModel) {
            this.source = aTreeModel;
            aTreeModel.addTreeModelListener(this);
            TreeCombo.this.setRenderer(new ListEntryRenderer());
        }

        public int getItemIndex(Object item) {
            int n = this.cache.size();
            for (int i = 0; i < n; ++i) {
                ListEntry le = (ListEntry)this.cache.elementAt(i);
                if (!item.equals(le.object.toString())) continue;
                return i;
            }
            return -1;
        }

        public void addItem(Object parentItem, Object item) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.source.getRoot();
            if (parentItem == null) {
                this.source.insertNodeInto(new DefaultMutableTreeNode(item), root, root.getChildCount());
            } else {
                int index = this.getItemIndex(parentItem);
                if (index < 0) {
                    return;
                }
                ListEntry le = (ListEntry)this.cache.elementAt(index);
                MutableTreeNode node = (MutableTreeNode)le.object;
                this.source.insertNodeInto(new DefaultMutableTreeNode(item), node, node.getChildCount());
            }
            this.invalid = true;
            this.validate();
        }

        public void insertItem(Object parentItem, Object item, int index) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.source.getRoot();
            if (parentItem == null) {
                this.source.insertNodeInto(new DefaultMutableTreeNode(item), root, index);
            } else {
                int index1 = this.getItemIndex(parentItem);
                if (index1 < 0) {
                    return;
                }
                ListEntry le = (ListEntry)this.cache.elementAt(index1);
                MutableTreeNode node = (MutableTreeNode)le.object;
                this.source.insertNodeInto(new DefaultMutableTreeNode(item), node, index);
            }
            this.invalid = true;
            this.validate();
        }

        public void removeAllItems(Object parentItem) {
            MutableTreeNode parent;
            if (parentItem == null) {
                parent = (DefaultMutableTreeNode)this.source.getRoot();
            } else {
                int index1 = this.getItemIndex(parentItem);
                if (index1 < 0) {
                    return;
                }
                ListEntry le = (ListEntry)this.cache.elementAt(index1);
                parent = (MutableTreeNode)le.object;
            }
            while (this.source.getChildCount(parent) > 0) {
                this.source.removeNodeFromParent((MutableTreeNode)parent.getChildAt(0));
            }
            this.invalid = true;
            this.validate();
        }

        @Override
        public void setSelectedItem(Object anObject) {
            this.currentValue = anObject;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.currentValue;
        }

        @Override
        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.cache.elementAt(index);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.invalid = true;
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new Vector();
                this.cacheTree(this.source.getRoot(), 0);
                if (this.cache.size() > 0) {
                    this.currentValue = this.cache.elementAt(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object anObject, int level) {
            if (this.source.isLeaf(anObject)) {
                this.addListEntry(anObject, level, false);
            } else {
                int c = this.source.getChildCount(anObject);
                this.addListEntry(anObject, level, true);
                ++level;
                for (int i = 0; i < c; ++i) {
                    Object child = this.source.getChild(anObject, i);
                    this.cacheTree(child, level);
                }
                --level;
            }
        }

        void addListEntry(Object anObject, int level, boolean isNode) {
            this.cache.addElement(new ListEntry(anObject, level, isNode));
        }
    }
}

