/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import com.argo21.common.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

final class AsciiReader
extends BaseReader {
    AsciiReader(InputStream in) {
        super(in);
    }

    @Override
    public String getEncoding() {
        return "ASCII";
    }

    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        int i;
        if (this.instream == null) {
            return -1;
        }
        for (i = 0; i < len; ++i) {
            byte c;
            if (this.start >= this.finish) {
                this.start = 0;
                this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                if (this.finish <= 0) {
                    if (this.finish > 0) break;
                    this.close();
                    break;
                }
            }
            if (((c = this.buffer[this.start++]) & 0x80) != 0) {
                throw new CharConversionException("Illegal ASCII character, 0x" + Integer.toHexString(c & 0xFF));
            }
            buf[offset + i] = (char)c;
        }
        if (i == 0 && this.finish <= 0) {
            return -1;
        }
        return i;
    }
}

