/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

abstract class BaseReader
extends Reader {
    protected InputStream instream;
    protected byte[] buffer;
    protected int start;
    protected int finish;

    BaseReader(InputStream stream) {
        super(stream);
        this.instream = stream;
        this.buffer = new byte[1024];
    }

    public abstract String getEncoding();

    @Override
    public boolean ready() throws IOException {
        return this.instream == null || this.finish - this.start > 0 || this.instream.available() != 0;
    }

    @Override
    public void close() throws IOException {
        if (this.instream != null) {
            this.instream.close();
            this.finish = 0;
            this.start = 0;
            this.buffer = null;
            this.instream = null;
        }
    }
}

