/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import com.argo21.common.io.BufferedStreamListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStreamEx
extends BufferedInputStream {
    private BufferedStreamListener listener = null;

    public BufferedInputStreamEx(InputStream in) {
        super(in);
    }

    public BufferedInputStreamEx(InputStream in, int bufsize) {
        super(in, bufsize);
    }

    public void setBufferedStreamListener(BufferedStreamListener listener) {
        this.listener = listener;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fillEx() throws IOException {
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.buf, 0, nbuf, 0, this.pos);
                this.buf = nbuf;
            }
        }
        this.count = this.pos;
        int n = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
            if (this.listener != null) {
                this.listener.passed(this, this.buf, this.pos, n);
            }
        }
    }

    @Override
    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fillEx();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1Ex(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.buf.length && this.markpos < 0) {
                return this.in.read(b, off, len);
            }
            this.fillEx();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            if (this.markpos < 0) {
                return this.in.skip(n);
            }
            this.fillEx();
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n1;
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.read1Ex(b, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && this.in.available() > 0 && (n1 = this.read1Ex(b, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    public int readWord() throws IOException {
        int b1 = this.read();
        if (b1 == -1) {
            return -1;
        }
        int b2 = this.read();
        if (b2 == -1) {
            return -1;
        }
        return (b1 << 8 | b2) & 0xFFFF;
    }

    public String readString(String def) throws IOException {
        int r;
        int len = this.readWord();
        if (len == 65535) {
            return def;
        }
        if (len == -1) {
            throw new IOException("Stream broken");
        }
        byte[] b = new byte[len];
        for (int p = 0; p < len; p += r) {
            r = this.read(b, p, len - p);
            if (r >= 0) continue;
            throw new IOException("Stream broken, couldn't demarshal string :" + len + ":" + p);
        }
        return new String(b);
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public String readLine(boolean skipLF) throws IOException {
        StringBuffer s = new StringBuffer();
        this.ensureOpen();
        while (true) {
            int i;
            if (this.pos >= this.count) {
                this.fillEx();
                if (this.pos >= this.count) {
                    return s.length() > 0 ? s.toString() : null;
                }
            }
            boolean eol = false;
            int c = 0;
            if (!skipLF || (this.buf[this.pos] & 0xFF) == 10) {
                // empty if block
            }
            for (i = ++this.pos; i < this.count; ++i) {
                c = this.buf[i] & 0xFF;
                if (c == 10 || c == 13) {
                    eol = true;
                    break;
                }
                s.append((char)c);
            }
            this.pos = i;
            if (eol) {
                ++this.pos;
                if (c != 13) break;
                if (this.pos >= this.count) {
                    this.fillEx();
                }
                if (this.pos >= this.count || (this.buf[this.pos] & 0xFF) != 10) break;
                ++this.pos;
                break;
            }
            skipLF = false;
        }
        return s.toString();
    }

    public void passAll() throws IOException {
        this.ensureOpen();
        while (this.pos >= this.count) {
            this.fillEx();
            if (this.pos >= this.count) {
                return;
            }
            this.pos = this.count;
        }
    }
}

