/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import com.argo21.common.io.BufferedStreamListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStreamEx
extends BufferedOutputStream {
    private BufferedStreamListener listener = null;

    public BufferedOutputStreamEx(OutputStream out) {
        super(out, 512);
    }

    public BufferedOutputStreamEx(OutputStream out, int size) {
        super(out, size);
    }

    private void flushBufferEx() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            if (this.listener != null) {
                this.listener.passed(this, this.buf, 0, this.count);
            }
            this.count = 0;
        }
    }

    public void setBufferedStreamListener(BufferedStreamListener listener) {
        this.listener = listener;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBufferEx();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBufferEx();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBufferEx();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBufferEx();
        this.out.flush();
    }

    public void passAll() throws IOException {
        this.flushBufferEx();
    }
}

