/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MIME2Java {
    private static Hashtable s_enchash;
    private static Hashtable s_revhash;
    static String[][] en_table;

    private MIME2Java() {
    }

    public static String[] getAllStandardEncoding() {
        String[] res = new String[en_table.length];
        int k = 0;
        for (int i = 0; i < en_table.length; ++i) {
            try {
                String en = en_table[i][0];
                new String(new byte[0], (String)s_enchash.get(en));
                res[k++] = en;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (k == en_table.length) {
            return res;
        }
        String[] res1 = new String[k];
        System.arraycopy(res, 0, res1, 0, k);
        return res1;
    }

    public static String[] getAllJavaEncoding() {
        int n = s_revhash.size();
        String[] res = new String[n];
        Enumeration em = s_revhash.keys();
        int k = 0;
        while (em.hasMoreElements() && k < n) {
            try {
                String en = (String)em.nextElement();
                new String(new byte[0], en);
                res[k++] = en;
            }
            catch (UnsupportedEncodingException en) {}
        }
        if (k == n) {
            return res;
        }
        String[] res1 = new String[k];
        System.arraycopy(res, 0, res1, 0, k);
        return res1;
    }

    public static String convert(String mimeCharsetName) {
        if (mimeCharsetName == null) {
            return null;
        }
        String javaCode = (String)s_enchash.get(mimeCharsetName);
        if (javaCode != null) {
            try {
                new String(new byte[0], javaCode);
                return javaCode;
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        try {
            InputStreamReader rd = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), mimeCharsetName);
            return rd.getEncoding();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String reverse(String encoding) {
        return encoding == null ? null : (String)s_revhash.get(encoding.toUpperCase());
    }

    public static String getDefaultJavaEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getDefaultStandardEncoding() {
        String encoding = System.getProperty("file.encoding");
        String encoding1 = (String)s_revhash.get(encoding.toUpperCase());
        return encoding1 == null ? encoding : encoding1;
    }

    static {
        en_table = new String[][]{{"UTF-8", "UTF8"}, {"UTF-16", "Unicode"}, {"US-ASCII", "ASCII"}, {"SHIFT_JIS", "MS932"}, {"EUC-JP", "EUC_JP"}, {"ISO-2022-JP", "ISO2022JP"}, {"ISO-8859-1", "ISO8859_1"}, {"ISO-8859-2", "ISO8859_2"}, {"ISO-8859-3", "ISO8859_3"}, {"ISO-8859-4", "ISO8859_4"}, {"ISO-8859-5", "ISO8859_5"}, {"ISO-8859-6", "ISO8859_6"}, {"ISO-8859-7", "ISO8859_7"}, {"ISO-8859-8", "ISO8859_8"}, {"ISO-8859-9", "ISO8859_9"}, {"GB2312", "EUC_CN"}, {"BIG5", "Big5"}, {"EUC-KR", "EUC_KR"}, {"ISO-2022-KR", "ISO2022KR"}, {"KOI8-R", "KOI8_R"}, {"EBCDIC-CP-US", "Cp037"}, {"EBCDIC-CP-CA", "Cp037"}, {"EBCDIC-CP-NL", "Cp037"}, {"EBCDIC-CP-DK", "Cp277"}, {"EBCDIC-CP-NO", "Cp277"}, {"EBCDIC-CP-FI", "Cp278"}, {"EBCDIC-CP-SE", "Cp278"}, {"EBCDIC-CP-IT", "Cp280"}, {"EBCDIC-CP-ES", "Cp284"}, {"EBCDIC-CP-GB", "Cp285"}, {"EBCDIC-CP-FR", "Cp297"}, {"EBCDIC-CP-AR1", "Cp420"}, {"EBCDIC-CP-HE", "Cp424"}, {"EBCDIC-CP-CH", "Cp500"}, {"EBCDIC-CP-ROECE", "Cp870"}, {"EBCDIC-CP-YU", "Cp870"}, {"EBCDIC-CP-IS", "Cp871"}, {"EBCDIC-CP-AR2", "Cp918"}};
        s_enchash = new Hashtable();
        for (int i = 0; i < en_table.length; ++i) {
            s_enchash.put(en_table[i][0], en_table[i][1]);
            s_enchash.put(en_table[i][1], en_table[i][1]);
        }
        s_enchash.put("SHIFT-JIS", "SJIS");
        s_revhash = new Hashtable();
        s_revhash.put("UTF8", "UTF-8");
        s_revhash.put("Unicode", "UTF-16");
        s_revhash.put("ASCII", "US-ASCII");
        s_revhash.put("ASCII7", "US-ASCII");
        s_revhash.put("SJIS", "SHIFT_JIS");
        s_revhash.put("MS932", "SHIFT_JIS");
        s_revhash.put("ISO2022JP", "ISO-2022-JP");
        s_revhash.put("ISO8859_1", "ISO-8859-1");
        s_revhash.put("ISO8859_2", "ISO-8859-2");
        s_revhash.put("ISO8859_3", "ISO-8859-3");
        s_revhash.put("ISO8859_4", "ISO-8859-4");
        s_revhash.put("ISO8859_5", "ISO-8859-5");
        s_revhash.put("ISO8859_6", "ISO-8859-6");
        s_revhash.put("ISO8859_7", "ISO-8859-7");
        s_revhash.put("ISO8859_8", "ISO-8859-8");
        s_revhash.put("ISO8859_9", "ISO-8859-9");
        s_revhash.put("EUC_CN", "GB2312");
        s_revhash.put("EUC_JP", "EUC-JP");
        s_revhash.put("EUC_KR", "EUC-KR");
        s_revhash.put("ISO2022KR", "ISO-2022-KR");
        s_revhash.put("BIG5", "Big5");
        s_revhash.put("KOI8_R", "KOI8-R");
        s_revhash.put("CP037", "EBCDIC-CP-US");
        s_revhash.put("CP037", "EBCDIC-CP-CA");
        s_revhash.put("CP037", "EBCDIC-CP-NL");
        s_revhash.put("CP277", "EBCDIC-CP-DK");
        s_revhash.put("CP277", "EBCDIC-CP-NO");
        s_revhash.put("CP278", "EBCDIC-CP-FI");
        s_revhash.put("CP278", "EBCDIC-CP-SE");
        s_revhash.put("CP280", "EBCDIC-CP-IT");
        s_revhash.put("CP284", "EBCDIC-CP-ES");
        s_revhash.put("CP285", "EBCDIC-CP-GB");
        s_revhash.put("CP297", "EBCDIC-CP-FR");
        s_revhash.put("CP420", "EBCDIC-CP-AR1");
        s_revhash.put("CP424", "EBCDIC-CP-HE");
        s_revhash.put("CP500", "EBCDIC-CP-CH");
        s_revhash.put("CP870", "EBCDIC-CP-ROECE");
        s_revhash.put("CP870", "EBCDIC-CP-YU");
        s_revhash.put("CP871", "EBCDIC-CP-IS");
        s_revhash.put("CP918", "EBCDIC-CP-AR2");
    }
}

