/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import com.argo21.common.io.AsciiReader;
import com.argo21.common.io.Iso8859_1Reader;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.UTF8Reader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;

public final class MIMEReader
extends Reader {
    private static final int MAXPUSHBACK = 512;
    private Reader in;
    private String assignedEncoding;
    private boolean closed;

    public static Reader createReader(InputStream in) throws IOException {
        return new MIMEReader(in);
    }

    public static Reader createReader(InputStream in, String encoding) throws IOException {
        if (encoding == null) {
            return new MIMEReader(in);
        }
        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF8".equalsIgnoreCase(encoding)) {
            return new UTF8Reader(in);
        }
        if ("US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding)) {
            return new AsciiReader(in);
        }
        if ("ISO-8859-1".equalsIgnoreCase(encoding)) {
            return new Iso8859_1Reader(in);
        }
        String ec = MIME2Java.convert(encoding);
        if (ec != null) {
            return new InputStreamReader(in, ec);
        }
        return new InputStreamReader(in);
    }

    public String getEncoding() {
        return this.assignedEncoding;
    }

    private MIMEReader(InputStream stream) throws IOException {
        super(stream);
        PushbackInputStream pb = new PushbackInputStream(stream, 512);
        byte[] buf = new byte[4];
        int len = pb.read(buf);
        if (len > 0) {
            pb.unread(buf, 0, len);
        }
        if (len == 4) {
            block0 : switch (buf[0] & 0xFF) {
                case 0: {
                    if (buf[1] != 60 || buf[2] != 0 || buf[3] != 63) break;
                    this.setEncoding(pb, "UnicodeBig");
                    return;
                }
                case 60: {
                    switch (buf[1] & 0xFF) {
                        default: {
                            break block0;
                        }
                        case 0: {
                            if (buf[2] != 63 || buf[3] != 0) break block0;
                            this.setEncoding(pb, "UnicodeLittle");
                            return;
                        }
                        case 63: 
                    }
                    if (buf[2] != 120 || buf[3] != 109) break;
                    this.useEncodingDecl(pb, "UTF8");
                    return;
                }
                case 76: {
                    if (buf[1] != 111 || (0xFF & buf[2]) != 167 || (0xFF & buf[3]) != 148) break;
                    this.useEncodingDecl(pb, "CP037");
                    return;
                }
                case 254: {
                    if ((buf[1] & 0xFF) != 255) break;
                    this.setEncoding(pb, "UTF-16");
                    return;
                }
                case 255: {
                    if ((buf[1] & 0xFF) != 254) break;
                    this.setEncoding(pb, "UTF-16");
                    return;
                }
            }
        }
        this.setEncoding(pb, "UTF-8");
    }

    private void useEncodingDecl(PushbackInputStream pb, String encoding) throws IOException {
        byte[] buffer = new byte[512];
        int len = pb.read(buffer, 0, buffer.length);
        pb.unread(buffer, 0, len);
        InputStreamReader r = new InputStreamReader((InputStream)new ByteArrayInputStream(buffer, 4, len), encoding);
        int c = ((Reader)r).read();
        if (c != 108) {
            this.setEncoding(pb, "UTF-8");
            return;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer keyBuf = null;
        String key = null;
        boolean sawEq = false;
        char quoteChar = '\u0000';
        boolean sawQuestion = false;
        block0: for (int i = 0; i < 507 && (c = ((Reader)r).read()) != -1; ++i) {
            if (c == 32 || c == 9 || c == 10 || c == 13) continue;
            if (i == 0) break;
            if (c == 63) {
                sawQuestion = true;
            } else if (sawQuestion) {
                if (c == 62) break;
                sawQuestion = false;
            }
            if (key == null || !sawEq) {
                if (keyBuf == null) {
                    if (Character.isWhitespace((char)c)) continue;
                    keyBuf = buf;
                    buf.setLength(0);
                    buf.append((char)c);
                    sawEq = false;
                    continue;
                }
                if (Character.isWhitespace((char)c)) {
                    key = keyBuf.toString();
                    continue;
                }
                if (c == 61) {
                    if (key == null) {
                        key = keyBuf.toString();
                    }
                    sawEq = true;
                    keyBuf = null;
                    quoteChar = '\u0000';
                    continue;
                }
                keyBuf.append((char)c);
                continue;
            }
            if (Character.isWhitespace((char)c)) continue;
            if (c == 34 || c == 39) {
                if (quoteChar == '\u0000') {
                    quoteChar = (char)c;
                    buf.setLength(0);
                    continue;
                }
                if (c == quoteChar) {
                    if ("encoding".equals(key)) {
                        this.assignedEncoding = buf.toString();
                        for (i = 0; i < this.assignedEncoding.length(); ++i) {
                            c = this.assignedEncoding.charAt(i);
                            if (!(c >= 65 && c <= 90 || c >= 97 && c <= 122) && (i == 0 || i <= 0 || c != 45 && (c < 48 || c > 57) && c != 46 && c != 95)) break block0;
                        }
                        this.setEncoding(pb, this.assignedEncoding);
                        return;
                    }
                    key = null;
                    continue;
                }
            }
            buf.append((char)c);
        }
        this.setEncoding(pb, "UTF-8");
    }

    private void setEncoding(InputStream stream, String encoding) throws IOException {
        this.assignedEncoding = encoding;
        this.in = MIMEReader.createReader(stream, encoding);
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        int val = this.in.read(buf, off, len);
        if (val == -1) {
            this.close();
        }
        return val;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int val = this.in.read();
        if (val == -1) {
            this.close();
        }
        return val;
    }

    @Override
    public boolean markSupported() {
        return this.in == null ? false : this.in.markSupported();
    }

    @Override
    public void mark(int value) throws IOException {
        if (this.in != null) {
            this.in.mark(value);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    @Override
    public long skip(long value) throws IOException {
        return this.in == null ? 0L : this.in.skip(value);
    }

    @Override
    public boolean ready() throws IOException {
        return this.in == null ? false : this.in.ready();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.in.close();
        this.in = null;
        this.closed = true;
    }
}

