/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import java.io.IOException;
import java.io.Writer;

public class ReplaceLFWriter
extends Writer {
    private Writer writer = null;
    private boolean isTagEnd = false;
    private String eol = "";

    public ReplaceLFWriter(Writer writer, String eol) {
        if (writer == null) {
            throw new IllegalArgumentException("ReplaceLFWriter : Writer is NULL.");
        }
        this.writer = writer;
        this.eol = eol;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(char[] arg0, int arg1, int arg2) throws IOException {
        char[] replaceChar = new char[arg2];
        System.arraycopy(arg0, arg1, replaceChar, 0, arg2);
        char[] writeChar = this.replaceLF(replaceChar);
        this.writer.write(writeChar, 0, writeChar.length);
    }

    @Override
    public void write(char[] arg0) throws IOException {
        char[] writeChar = this.replaceLF(arg0);
        this.writer.write(writeChar);
    }

    @Override
    public void write(String arg0, int arg1, int arg2) throws IOException {
        String subString = arg0.substring(arg1, arg1 + arg2);
        if (subString != null) {
            char[] writeChar = this.replaceLF(subString.toCharArray());
            this.writer.write(new String(writeChar));
        }
    }

    @Override
    public void write(String arg0) throws IOException {
        char[] writeChar = this.replaceLF(arg0.toCharArray());
        this.writer.write(new String(writeChar));
    }

    @Override
    public void write(int arg0) throws IOException {
        this.writer.write(arg0);
    }

    private char[] replaceLF(char[] baseCahrs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < baseCahrs.length; ++i) {
            if (baseCahrs[i] == '\n' && this.isTagEnd) {
                sb.append(this.eol);
            } else {
                sb.append(baseCahrs[i]);
            }
            this.isTagEnd = baseCahrs[i] == '>';
        }
        String writeString = sb.toString();
        if (writeString != null) {
            return writeString.toCharArray();
        }
        return new char[0];
    }
}

