/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import com.argo21.common.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

final class UTF8Reader
extends BaseReader {
    private char nextChar;

    UTF8Reader(InputStream stream) throws IOException {
        super(stream);
        this.start = 0;
        this.finish = this.instream.read(this.buffer, 0, 3);
        if (this.finish == 3 && (this.buffer[0] & 0xFF) == 239 && (this.buffer[1] & 0xFF) == 187 && (this.buffer[2] & 0xFF) == 191) {
            this.start = 3;
        }
    }

    @Override
    public String getEncoding() {
        return "UTF8";
    }

    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        int i = 0;
        int c = 0;
        if (len <= 0) {
            return 0;
        }
        if (this.nextChar != '\u0000') {
            buf[offset + i++] = this.nextChar;
            this.nextChar = '\u0000';
        }
        while (i < len) {
            int off;
            block18: {
                if (this.finish <= this.start) {
                    if (this.instream == null) {
                        c = -1;
                        break;
                    }
                    this.start = 0;
                    this.finish = this.instream.read(this.buffer, 0, this.buffer.length);
                    if (this.finish <= 0) {
                        this.close();
                        c = -1;
                        break;
                    }
                }
                if (((c = this.buffer[this.start] & 0xFF) & 0x80) == 0) {
                    ++this.start;
                    buf[offset + i++] = (char)c;
                    continue;
                }
                off = this.start;
                try {
                    if ((this.buffer[off] & 0xE0) == 192) {
                        c = (this.buffer[off++] & 0x1F) << 6;
                        c += this.buffer[off++] & 0x3F;
                        break block18;
                    }
                    if ((this.buffer[off] & 0xF0) == 224) {
                        c = (this.buffer[off++] & 0xF) << 12;
                        c += (this.buffer[off++] & 0x3F) << 6;
                        c += this.buffer[off++] & 0x3F;
                        break block18;
                    }
                    if ((this.buffer[off] & 0xF8) == 240) {
                        c = (this.buffer[off++] & 7) << 18;
                        c += (this.buffer[off++] & 0x3F) << 12;
                        c += (this.buffer[off++] & 0x3F) << 6;
                        if ((c += this.buffer[off++] & 0x3F) > 0x10FFFF) {
                            throw new CharConversionException("UTF-8 encoding of character 0x00" + Integer.toHexString(c) + " can't be converted to Unicode.");
                        }
                        this.nextChar = (char)(56320 + ((c -= 65536) & 0x3FF));
                        c = 55296 + (c >> 10);
                        break block18;
                    }
                    throw new CharConversionException("Unconvertible UTF-8 character beginning with 0x" + Integer.toHexString(this.buffer[this.start] & 0xFF));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    c = 0;
                }
            }
            if (off > this.finish) {
                System.arraycopy(this.buffer, this.start, this.buffer, 0, this.finish - this.start);
                this.finish -= this.start;
                this.start = 0;
                off = this.instream.read(this.buffer, this.finish, this.buffer.length - this.finish);
                if (off < 0) {
                    this.close();
                    throw new CharConversionException("Partial UTF-8 char");
                }
                this.finish += off;
                continue;
            }
            ++this.start;
            while (this.start < off) {
                if ((this.buffer[this.start] & 0xC0) != 128) {
                    this.close();
                    throw new CharConversionException("Malformed UTF-8 char -- is an XML encoding declaration missing?");
                }
                ++this.start;
            }
            buf[offset + i++] = (char)c;
            if (this.nextChar == '\u0000' || i >= len) continue;
            buf[offset + i++] = this.nextChar;
            this.nextChar = '\u0000';
        }
        if (i > 0) {
            return i;
        }
        return c == -1 ? -1 : 0;
    }
}

