/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.io;

import com.argo21.common.io.BaseReader;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.MIMEReader;
import com.argo21.common.lang.XmlChars;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XReader
extends Reader
implements Locator {
    private static final String[] types = new String[]{"application/xml", "text/xml", "text/plain", "text/html", "application/x-netcdf", "content/unknown"};
    private static final int BUFSIZ = 4097;
    private static final int HALFBUFSIZ = 2048;
    private static final char[] newline = new char[]{'\n'};
    private Reader in;
    private String assignedEncoding;
    private char[] buf;
    private int bufPointer = 0;
    private int bufLength = 0;
    private int bufAbandon = 0;
    private int lineNumber = 1;
    private StringBuffer rememberedText;
    private int startRemember = -1;
    private boolean isClosed;
    private boolean maybeInCRLF = false;
    private boolean returnedFirstHalf = false;
    private char[] nameTmp = new char[16];
    private ErrorHandler errHandler = null;
    private String publicid = null;
    private String systemid = null;
    private int svpos = 0;
    private boolean enableAbandon = true;
    private String parentPath = null;

    public static XReader createReader(InputStream in) throws IOException {
        Reader reader = MIMEReader.createReader(in);
        return new XReader(reader);
    }

    public static XReader createReader(Reader reader) {
        return new XReader(reader);
    }

    public static XReader createReader(Reader reader, String parentPath) {
        XReader r = new XReader(reader);
        r.setParentPath(parentPath);
        return r;
    }

    public static XReader createReader(InputStream in, String encoding) throws IOException {
        Reader reader = MIMEReader.createReader(in, encoding);
        return new XReader(reader);
    }

    public static XReader createReader(URL url, boolean checkType) throws IOException {
        InputSource is = XReader.createInputSource(url, checkType);
        return new XReader(is);
    }

    public static XReader createReader(File file) throws IOException {
        InputSource is = XReader.createInputSource(file);
        return new XReader(is);
    }

    public static XReader createReader(InputSource is) throws IOException {
        return new XReader(is);
    }

    public static XReader createReader(char[] buf, String encoding) {
        return new XReader(buf, 0, buf.length, encoding);
    }

    public static XReader createReader(char[] buf, int length, String encoding) {
        return new XReader(buf, 0, length, encoding);
    }

    public static XReader createReader(char[] buf, int first, int length, String encoding, String parentPath) {
        XReader r = new XReader(buf, first, length, encoding);
        r.setParentPath(parentPath);
        return r;
    }

    public static XReader createReader(char[] buf, int first, int length, String encoding) {
        return new XReader(buf, first, length, encoding);
    }

    public static InputSource createInputSource(String contentType, InputStream stream, boolean checkType, String scheme) throws IOException {
        String charset = null;
        if (contentType != null) {
            int index = (contentType = contentType.toLowerCase()).indexOf(59);
            if (index != -1) {
                String attributes = contentType.substring(index + 1);
                contentType = contentType.substring(0, index);
                index = attributes.indexOf("charset");
                if (index != -1) {
                    if ((index = (attributes = attributes.substring(index + 7)).indexOf(59)) != -1) {
                        attributes = attributes.substring(0, index);
                    }
                    if ((index = attributes.indexOf(61)) != -1) {
                        if ((index = (attributes = attributes.substring(index + 1)).indexOf(40)) != -1) {
                            attributes = attributes.substring(0, index);
                        }
                        if ((index = attributes.indexOf(34)) != -1) {
                            attributes = attributes.substring(index + 1);
                            attributes = attributes.substring(0, attributes.indexOf(34));
                        }
                        charset = attributes.trim();
                    }
                }
            }
            if (checkType) {
                boolean isOK = false;
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].equals(contentType)) continue;
                    isOK = true;
                    break;
                }
                if (!isOK) {
                    throw new IOException("Not Contents: " + contentType);
                }
            }
        }
        Reader rd = MIMEReader.createReader(stream, charset);
        InputSource retval = new InputSource(rd);
        if (charset != null) {
            retval.setEncoding(charset);
        } else if (rd instanceof MIMEReader) {
            retval.setEncoding(((MIMEReader)rd).getEncoding());
        } else if (rd instanceof BaseReader) {
            retval.setEncoding(((BaseReader)rd).getEncoding());
        } else if (rd instanceof InputStreamReader) {
            retval.setEncoding(MIME2Java.reverse(((InputStreamReader)rd).getEncoding()));
        }
        return retval;
    }

    public static InputSource createInputSource(URL url, boolean checkType) throws IOException {
        InputSource retval;
        URLConnection conn = url.openConnection();
        if (checkType) {
            String contentType = conn.getContentType();
            retval = XReader.createInputSource(contentType, conn.getInputStream(), false, url.getProtocol());
        } else {
            Reader rd = MIMEReader.createReader(conn.getInputStream());
            retval = new InputSource(rd);
            if (rd instanceof MIMEReader) {
                retval.setEncoding(((MIMEReader)rd).getEncoding());
            } else if (rd instanceof BaseReader) {
                retval.setEncoding(((BaseReader)rd).getEncoding());
            } else if (rd instanceof InputStreamReader) {
                retval.setEncoding(MIME2Java.reverse(((InputStreamReader)rd).getEncoding()));
            }
        }
        retval.setSystemId(conn.getURL().toString());
        return retval;
    }

    public static InputSource createInputSource(File file) throws IOException {
        Reader rd = MIMEReader.createReader(new FileInputStream(file));
        InputSource retval = new InputSource(rd);
        if (rd instanceof MIMEReader) {
            retval.setEncoding(((MIMEReader)rd).getEncoding());
        } else if (rd instanceof BaseReader) {
            retval.setEncoding(((BaseReader)rd).getEncoding());
        } else if (rd instanceof InputStreamReader) {
            retval.setEncoding(MIME2Java.reverse(((InputStreamReader)rd).getEncoding()));
        }
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        retval.setSystemId("file:" + path);
        return retval;
    }

    private XReader(Reader reader) {
        this.in = reader;
    }

    private XReader(char[] buf, int pos, int length, String encoding) {
        this.in = null;
        this.buf = buf;
        this.bufPointer = pos;
        this.bufLength = length;
        this.assignedEncoding = encoding;
    }

    private XReader(InputSource input) throws IOException {
        Object xr = null;
        this.in = input.getCharacterStream();
        if (this.in == null) {
            InputStream bytes = input.getByteStream();
            this.in = bytes == null ? MIMEReader.createReader(new URL(input.getSystemId()).openStream()) : (input.getEncoding() != null ? MIMEReader.createReader(input.getByteStream(), input.getEncoding()) : MIMEReader.createReader(input.getByteStream()));
        }
        this.publicid = input.getPublicId();
        this.systemid = input.getSystemId();
    }

    public void backup() {
        this.svpos = this.getAbsolutePosition();
    }

    public void restore() {
        this.back(this.getAbsolutePosition() - this.svpos);
    }

    public void setEncoding(String encoding) {
        if (this.in == null) {
            this.assignedEncoding = encoding;
        }
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        char c;
        if (this.isEOF()) {
            return -1;
        }
        int k = 0;
        if (off + len > buf.length) {
            len = buf.length - off;
        }
        while (k < len && (c = this.getc()) > '\u0000') {
            buf[off + k] = c;
            ++k;
        }
        return k;
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.bufLength <= this.bufPointer) {
                this.fillbuf();
            }
        }
        catch (Exception e) {
            return -1;
        }
        if (this.bufLength > this.bufPointer) {
            char c = this.buf[this.bufPointer++];
            if (this.returnedFirstHalf) {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c;
                }
                return -1;
            }
            if (c >= ' ' && c <= '\ud7ff' || c == '\t' || c >= '\ue000' && c <= '\ufffd') {
                return c;
            }
            if (c == '\r' && !this.isInternal()) {
                this.maybeInCRLF = true;
                int k = this.read();
                if (k < 0) {
                    return k;
                }
                c = (char)k;
                if (c != '\n' && c != '\u0000') {
                    this.ungetc();
                }
                this.maybeInCRLF = false;
                ++this.lineNumber;
                return 10;
            }
            if (c == '\n' || c == '\r') {
                if (!this.isInternal() && !this.maybeInCRLF) {
                    ++this.lineNumber;
                }
                return c;
            }
            if (c >= '\ud800' && c < '\udc00') {
                this.returnedFirstHalf = true;
                return c;
            }
            return -1;
        }
        throw new EndOfInputException();
    }

    @Override
    public boolean markSupported() {
        return this.in == null ? false : this.in.markSupported();
    }

    @Override
    public void mark(int value) throws IOException {
        if (this.in != null) {
            this.in.mark(value);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    @Override
    public long skip(long value) throws IOException {
        return this.in == null ? 0L : this.in.skip(value);
    }

    @Override
    public boolean ready() throws IOException {
        return this.in == null ? false : this.in.ready();
    }

    public void skip(int n) {
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                char c;
                if (this.bufLength <= this.bufPointer) {
                    try {
                        this.fillbuf();
                    }
                    catch (IOException e) {
                        return;
                    }
                }
                if (this.bufLength <= this.bufPointer) {
                    return;
                }
                if ((c = this.buf[this.bufPointer++]) == '\r' && !this.isInternal()) {
                    this.maybeInCRLF = true;
                    if (this.bufLength <= this.bufPointer) {
                        try {
                            this.fillbuf();
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                    if ((c = this.buf[this.bufPointer++]) != '\n') {
                        --this.bufPointer;
                    }
                    this.maybeInCRLF = false;
                    ++this.lineNumber;
                    return;
                }
                if (c == '\n' || c == '\r') {
                    if (!this.isInternal() && !this.maybeInCRLF) {
                        ++this.lineNumber;
                    }
                    return;
                }
                if (c < '\ud800' || c >= '\udc00') continue;
                this.returnedFirstHalf = true;
                return;
            }
        }
    }

    public void back(int n) {
        if (n <= 0) {
            return;
        }
        if (n + this.bufPointer < 0) {
            throw new InternalError("back");
        }
        while (n > 0) {
            char c;
            if ((c = this.buf[--this.bufPointer]) == '\n' && !this.isInternal()) {
                this.maybeInCRLF = true;
                if (this.bufPointer > 0 && this.buf[this.bufPointer - 1] == '\r') {
                    --this.bufPointer;
                    --n;
                }
                this.maybeInCRLF = false;
                --this.lineNumber;
            } else if (c == '\n' || c == '\r') {
                if (!this.isInternal()) {
                    --this.lineNumber;
                }
            } else if (this.returnedFirstHalf) {
                this.returnedFirstHalf = false;
            }
            --n;
        }
    }

    public char getc() {
        if (this.bufLength <= this.bufPointer) {
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return '\u0000';
            }
        }
        if (this.bufLength > this.bufPointer) {
            char c = this.buf[this.bufPointer++];
            if (this.returnedFirstHalf) {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c;
                }
                return '\u0000';
            }
            if (c >= ' ' && c <= '\ud7ff' || c == '\t' || c >= '\ue000' && c <= '\ufffd') {
                return c;
            }
            if (c == '\r' && !this.isInternal()) {
                this.maybeInCRLF = true;
                c = this.getc();
                if (c != '\n' && c != '\u0000') {
                    this.ungetc();
                }
                this.maybeInCRLF = false;
                ++this.lineNumber;
                return '\n';
            }
            if (c == '\n' || c == '\r') {
                if (!this.isInternal() && !this.maybeInCRLF) {
                    ++this.lineNumber;
                }
                return c;
            }
            if (c >= '\ud800' && c < '\udc00') {
                this.returnedFirstHalf = true;
                return c;
            }
        }
        return '\u0000';
    }

    public void ungetc() {
        if (this.bufPointer > 0) {
            --this.bufPointer;
            if (this.buf[this.bufPointer] == '\n' && !this.isInternal()) {
                this.maybeInCRLF = true;
                if (this.bufPointer > 0 && this.buf[this.bufPointer - 1] == '\r') {
                    --this.bufPointer;
                }
                this.maybeInCRLF = false;
                --this.lineNumber;
            } else if (this.buf[this.bufPointer] == '\n' || this.buf[this.bufPointer] == '\r') {
                if (!this.isInternal()) {
                    --this.lineNumber;
                }
            } else if (this.returnedFirstHalf) {
                this.returnedFirstHalf = false;
            }
        }
    }

    public char lookupChar() {
        if (this.bufLength <= this.bufPointer) {
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return '\u0000';
            }
        }
        if (this.bufLength > this.bufPointer) {
            return this.buf[this.bufPointer];
        }
        return '\u0000';
    }

    public String lookupWord() {
        char c;
        int oldpos = this.getAbsolutePosition();
        this.peekWhitespace();
        int k = 0;
        while (XmlChars.isLetter(c = this.getc())) {
            if (k >= this.nameTmp.length) {
                this.extendsNameTmp();
            }
            this.nameTmp[k++] = c;
        }
        int newpos = this.getAbsolutePosition();
        this.back(newpos - oldpos);
        return String.valueOf(this.nameTmp, 0, k);
    }

    public boolean peekc(char c) {
        try {
            if (this.bufLength <= this.bufPointer) {
                this.fillbuf();
            }
            if (this.bufLength > this.bufPointer) {
                if (this.buf[this.bufPointer] == c) {
                    ++this.bufPointer;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public char getNameChar() {
        try {
            if (this.bufLength <= this.bufPointer) {
                this.fillbuf();
            }
            if (this.bufLength > this.bufPointer) {
                char c;
                if (XmlChars.isNameChar(c = this.buf[this.bufPointer++])) {
                    return c;
                }
                --this.bufPointer;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return '\u0000';
    }

    public boolean peek(char[] next) {
        int i;
        int len = next.length;
        if (this.bufLength <= this.bufPointer || this.bufLength - this.bufPointer < len) {
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.bufLength <= this.bufPointer) {
            return false;
        }
        for (i = 0; i < len && this.bufPointer + i < this.bufLength; ++i) {
            if (this.buf[this.bufPointer + i] == next[i]) continue;
            return false;
        }
        if (i < len) {
            if (this.in == null || this.isClosed) {
                return false;
            }
            if (len > this.buf.length) {
                return false;
            }
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return false;
            }
            return this.peek(next);
        }
        this.bufPointer += len;
        return true;
    }

    public boolean peek(String next) {
        int i;
        int len = next.length();
        if (this.bufLength <= this.bufPointer || this.bufLength - this.bufPointer < len) {
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.bufLength <= this.bufPointer) {
            return false;
        }
        for (i = 0; i < len && this.bufPointer + i < this.bufLength; ++i) {
            if (this.buf[this.bufPointer + i] == next.charAt(i)) continue;
            return false;
        }
        if (i < len) {
            if (this.in == null || this.isClosed) {
                return false;
            }
            if (len > this.buf.length) {
                return false;
            }
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return false;
            }
            return this.peek(next);
        }
        this.bufPointer += len;
        return true;
    }

    public boolean peekIgnoreCase(String next) {
        int i;
        int len = next.length();
        if (this.bufLength <= this.bufPointer || this.bufLength - this.bufPointer < len) {
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.bufLength <= this.bufPointer) {
            return false;
        }
        for (i = 0; i < len && this.bufPointer + i < this.bufLength; ++i) {
            if (Character.toLowerCase(this.buf[this.bufPointer + i]) == Character.toLowerCase(next.charAt(i))) continue;
            return false;
        }
        if (i < len) {
            if (this.in == null || this.isClosed) {
                return false;
            }
            if (len > this.buf.length) {
                return false;
            }
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return false;
            }
            return this.peek(next);
        }
        this.bufPointer += len;
        return true;
    }

    public String peekQuotedString() {
        char c;
        char quote = this.getc();
        if (quote != '\'' && quote != '\"') {
            if (quote != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        StringBuffer strTmp = new StringBuffer();
        while ((c = this.getc()) != quote && c != '\u0000') {
            strTmp.append(c);
        }
        return strTmp.toString();
    }

    public String peekQuotedStringOneLine() {
        char c;
        char quote = this.getc();
        if (quote != '\'' && quote != '\"') {
            if (quote != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        StringBuffer strTmp = new StringBuffer();
        while ((c = this.getc()) != quote && c != '\u0000') {
            if (c == '\n' || c == '\r') {
                this.back(strTmp.length() + 1);
                return null;
            }
            strTmp.append(c);
        }
        return strTmp.toString();
    }

    public void skipLine() {
        char c;
        while ((c = this.getc()) != '\u0000') {
            if (c == '\r') {
                if (!this.isChar('\n')) break;
                this.getc();
                break;
            }
            if (c != '\n') continue;
            break;
        }
    }

    public String readToEol() {
        char c;
        StringBuffer strTmp = new StringBuffer();
        while ((c = this.getc()) != '\u0000') {
            if (c == '\r' || c == '\n') {
                this.ungetc();
                break;
            }
            strTmp.append(c);
        }
        return strTmp.toString();
    }

    public String readLine() {
        char c;
        StringBuffer strTmp = new StringBuffer();
        while ((c = this.getc()) != '\u0000') {
            if (c == '\r') {
                if (!this.isChar('\n')) break;
                this.getc();
                break;
            }
            if (c == '\n') break;
            strTmp.append(c);
        }
        return strTmp.toString();
    }

    public void skipTo(String s) {
        char c;
        int n = s.length();
        if (n == 0) {
            return;
        }
        block0: while ((c = this.getc()) != '\u0000') {
            if (c != s.charAt(0)) continue;
            for (int i = 1; i < n && (c = this.getc()) != '\u0000'; ++i) {
                if (c != s.charAt(i)) continue block0;
            }
            return;
        }
    }

    public String readStringTo(String s, boolean skipQuote) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        this.readStringTo1(s, skipQuote, sb);
        return sb.toString();
    }

    private boolean readStringTo1(String s, boolean skipQuote, StringBuffer sb) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        String sub = s.substring(1);
        if (!this.readStringTo1(c, skipQuote, sb)) {
            return false;
        }
        if (!this.isEOF() && !this.peek(sub)) {
            sb.append(c);
            return this.readStringTo1(s, skipQuote, sb);
        }
        return true;
    }

    public String readStringToIgnoreCase(String s, boolean skipQuote) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        this.readStringToIgnoreCase1(s, skipQuote, sb);
        return sb.toString();
    }

    private boolean readStringToIgnoreCase1(String s, boolean skipQuote, StringBuffer sb) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        String sub = s.substring(1);
        if (!this.readStringToIgnoreCase1(c, skipQuote, sb)) {
            return false;
        }
        if (!this.isEOF() && !this.peekIgnoreCase(sub)) {
            sb.append(c);
            this.readStringToIgnoreCase1(s, skipQuote, sb);
        }
        return true;
    }

    public String readStringTo(char ch, boolean skipQuote) {
        StringBuffer sb = new StringBuffer();
        this.readStringTo1(ch, skipQuote, sb);
        return sb.toString();
    }

    private boolean readStringTo1(char ch, boolean skipQuote, StringBuffer sb) {
        char c;
        while ((c = this.getc()) != '\u0000') {
            if (skipQuote && (c == '\"' || c == '\"')) {
                sb.append(c);
                this.readStringTo1(c, false, sb);
                sb.append(c);
                continue;
            }
            if (c != ch) {
                sb.append(c);
                continue;
            }
            return true;
        }
        return false;
    }

    public String readStringToIgnoreCase(char ch, boolean skipQuote) {
        StringBuffer sb = new StringBuffer();
        this.readStringTo1(ch, skipQuote, sb);
        return sb.toString();
    }

    private boolean readStringToIgnoreCase1(char ch, boolean skipQuote, StringBuffer sb) {
        char c;
        while ((c = this.getc()) != '\u0000') {
            if (skipQuote && (c == '\"' || c == '\"')) {
                sb.append(c);
                this.readStringToIgnoreCase1(c, false, sb);
                sb.append(c);
                continue;
            }
            if (Character.toLowerCase(c) != Character.toLowerCase(ch)) {
                sb.append(c);
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isEOF() {
        if (this.bufPointer >= this.bufLength) {
            try {
                this.fillbuf();
            }
            catch (Exception e) {
                return true;
            }
            return this.bufPointer >= this.bufLength;
        }
        return false;
    }

    public void startRemembering() {
        this.startRemember = this.bufPointer;
    }

    public boolean peekWhitespace() {
        boolean isSpace = false;
        boolean sawCR = false;
        while (true) {
            char c;
            if (this.bufLength <= this.bufPointer) {
                try {
                    this.fillbuf();
                }
                catch (Exception e) {
                    return isSpace;
                }
            }
            if (this.bufLength <= this.bufPointer) {
                return isSpace;
            }
            if ((c = this.buf[this.bufPointer++]) != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            isSpace = true;
            char cc = c;
            if (c != '\n' && c != '\r' || this.isInternal()) continue;
            if (c != '\n' || !sawCR) {
                ++this.lineNumber;
                sawCR = false;
            }
            if (c != '\r') continue;
            sawCR = true;
        }
        --this.bufPointer;
        return isSpace;
    }

    public boolean peekSpace() {
        boolean isSpace = false;
        while (true) {
            char c;
            if (this.bufLength <= this.bufPointer) {
                try {
                    this.fillbuf();
                }
                catch (Exception e) {
                    return isSpace;
                }
            }
            if (this.bufLength <= this.bufPointer) {
                return isSpace;
            }
            if ((c = this.buf[this.bufPointer++]) != ' ' && c != '\t') break;
            isSpace = true;
        }
        --this.bufPointer;
        return isSpace;
    }

    public boolean isChar(char c) {
        if (this.bufLength <= this.bufPointer) {
            try {
                this.fillbuf();
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.bufLength <= this.bufPointer) {
            return false;
        }
        return c == this.buf[this.bufPointer];
    }

    public String peekName() {
        char c = this.getc();
        if (!Character.isLetter(c) && c != '_') {
            if (c != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        int i = 1;
        this.nameTmp[0] = c;
        while (true) {
            if (!Character.isLetterOrDigit(c = this.getc()) && c != '_') {
                if (c == '\u0000') break;
                this.ungetc();
                break;
            }
            if (i >= this.nameTmp.length) {
                this.extendsNameTmp();
            }
            this.nameTmp[i++] = c;
        }
        return String.valueOf(this.nameTmp, 0, i);
    }

    public String peekXmlName() {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != ':' && c != '_') {
            if (c != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        int i = 1;
        this.nameTmp[0] = c;
        while (true) {
            if (!XmlChars.isNameChar(c = this.getc())) {
                if (c == '\u0000') break;
                this.ungetc();
                break;
            }
            if (i >= this.nameTmp.length) {
                this.extendsNameTmp();
            }
            this.nameTmp[i++] = c;
        }
        return String.valueOf(this.nameTmp, 0, i);
    }

    public String peekNmtoken() {
        char c = this.getc();
        if (!XmlChars.isNameChar(c)) {
            if (c != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        int i = 1;
        this.nameTmp[0] = c;
        while (true) {
            if (!XmlChars.isNameChar(c = this.getc())) {
                if (c == '\u0000') break;
                this.ungetc();
                break;
            }
            if (i >= this.nameTmp.length) {
                this.extendsNameTmp();
            }
            this.nameTmp[i++] = c;
        }
        return String.valueOf(this.nameTmp, 0, i);
    }

    public String peekNCName() {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != '_') {
            if (c != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        int i = 1;
        this.nameTmp[0] = c;
        while (true) {
            if (!XmlChars.isNCNameChar(c = this.getc())) {
                if (c == '\u0000') break;
                this.ungetc();
                break;
            }
            if (i >= this.nameTmp.length) {
                this.extendsNameTmp();
            }
            this.nameTmp[i++] = c;
        }
        return String.valueOf(this.nameTmp, 0, i);
    }

    public String peekSName() {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != '_') {
            if (c != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        int i = 1;
        this.nameTmp[0] = c;
        while (true) {
            if (!XmlChars.isLetter(c = this.getc()) && !Character.isDigit(c) && c != '_') {
                if (c == '\u0000') break;
                this.ungetc();
                break;
            }
            if (i >= this.nameTmp.length) {
                this.extendsNameTmp();
            }
            this.nameTmp[i++] = c;
        }
        return String.valueOf(this.nameTmp, 0, i);
    }

    public String peekXmlNmtoken() throws SAXException, IOException {
        char c = this.getc();
        if (!XmlChars.isNameChar(c)) {
            if (c != '\u0000') {
                this.ungetc();
            }
            return null;
        }
        return this.nameCharString(c);
    }

    public Number peekNumber() {
        char c;
        boolean isHex = false;
        int k = 0;
        this.nameTmp[k++] = c = this.getc();
        if (c == '-') {
            this.nameTmp[k++] = c = this.getc();
            if (c < '0' || c > '9') {
                this.back(k);
                return null;
            }
        }
        if (c == '0') {
            c = this.getc();
            if (c != 'x' || c < '0' || c > '9') {
                this.ungetc();
                String s = new String(this.nameTmp, 0, k);
                return new Double(s);
            }
            this.nameTmp[k++] = c;
        } else if (c < '0' || c > '9') {
            this.back(k);
            return null;
        }
        if (!isHex) {
            while (true) {
                if (k >= this.nameTmp.length) {
                    this.extendsNameTmp();
                }
                if ((c = this.getc()) >= '0' && c <= '9') {
                    this.nameTmp[k++] = c;
                    continue;
                }
                if (c != '.') break;
                this.nameTmp[k++] = c;
            }
            this.ungetc();
        } else {
            while (true) {
                if (k >= this.nameTmp.length) {
                    this.extendsNameTmp();
                }
                if ((c = this.getc()) >= '0' && c <= '9') {
                    this.nameTmp[k++] = c;
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    this.nameTmp[k++] = c;
                    continue;
                }
                if (c >= 'A' && c <= 'F') {
                    this.nameTmp[k++] = c;
                    continue;
                }
                if (c != '.') break;
                this.nameTmp[k++] = c;
            }
            this.ungetc();
        }
        String s = new String(this.nameTmp, 0, k);
        return new Double(s);
    }

    private String nameCharString(char c) {
        int i = 1;
        this.nameTmp[0] = c;
        while (true) {
            if (!XmlChars.isNameChar(c = this.getc())) {
                if (c == '\u0000') break;
                this.ungetc();
                break;
            }
            if (i >= this.nameTmp.length) {
                this.extendsNameTmp();
            }
            this.nameTmp[i++] = c;
        }
        return String.valueOf(this.nameTmp, 0, i);
    }

    private void extendsNameTmp() {
        char[] tmp = new char[this.nameTmp.length + 10];
        System.arraycopy(this.nameTmp, 0, tmp, 0, this.nameTmp.length);
        this.nameTmp = tmp;
    }

    public int getAbsolutePosition() {
        return this.bufAbandon + this.bufPointer;
    }

    public void top() {
        this.bufPointer = 0;
        this.bufAbandon = 0;
        this.lineNumber = 1;
    }

    public String getEncoding() {
        if (this.in == null) {
            if (this.assignedEncoding != null) {
                return this.assignedEncoding;
            }
            System.getProperty("file.encoding");
        }
        if (this.in instanceof MIMEReader) {
            return ((MIMEReader)this.in).getEncoding();
        }
        if (this.in instanceof BaseReader) {
            return ((BaseReader)this.in).getEncoding();
        }
        if (this.in instanceof InputStreamReader) {
            return ((InputStreamReader)this.in).getEncoding();
        }
        return null;
    }

    private Locator getLocator() {
        return this;
    }

    @Override
    public String getPublicId() {
        return this.publicid;
    }

    @Override
    public String getSystemId() {
        return this.systemid;
    }

    public void setPublicId(String publicid) {
        this.publicid = publicid;
    }

    public void setSystemId(String systemid) {
        this.systemid = systemid;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        char c;
        int k = 0;
        int i = this.bufPointer;
        if (i == this.bufLength) {
            --i;
        }
        while (i >= 0 && (c = this.buf[i]) != '\r' && c != '\n') {
            ++k;
            --i;
        }
        return k;
    }

    public String rememberText() {
        String retval;
        if (this.startRemember < 0) {
            return "";
        }
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.bufPointer - this.startRemember);
            retval = this.rememberedText.toString();
        } else {
            retval = new String(this.buf, this.startRemember, this.bufPointer - this.startRemember);
        }
        this.startRemember = -1;
        this.rememberedText = null;
        return retval;
    }

    public char[] rememberChars() {
        char[] retval;
        if (this.startRemember < 0) {
            return new char[0];
        }
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.bufPointer - this.startRemember);
            int len = this.rememberedText.length();
            retval = new char[len];
            this.rememberedText.getChars(0, len, retval, 0);
        } else {
            int len = this.bufPointer - this.startRemember;
            retval = new char[len];
            System.arraycopy(this.buf, this.startRemember, retval, 0, len);
        }
        this.startRemember = -1;
        this.rememberedText = null;
        return retval;
    }

    public boolean getEnableAbandon() {
        return this.enableAbandon;
    }

    public void setEnableAbandon(boolean b) {
        this.enableAbandon = b;
    }

    public String getAll() {
        boolean b = this.enableAbandon;
        this.enableAbandon = false;
        try {
            while (!this.isClosed) {
                this.fillbuf();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enableAbandon = b;
        return new String(this.buf, 0, this.bufLength);
    }

    protected void fillbuf() throws IOException {
        int len1;
        int len2;
        int len;
        int half;
        boolean extra;
        int c;
        if (this.in == null || this.isClosed) {
            return;
        }
        if (this.buf == null) {
            this.buf = new char[4097];
        }
        if ((c = this.in.read()) < 0) {
            this.close();
            return;
        }
        if (!this.enableAbandon) {
            int len3 = this.buf.length + 1024;
            char[] tmp = new char[len3];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
            this.buf[this.bufLength++] = (char)c;
            len3 = this.buf.length - this.bufLength;
            len3 = this.in.read(this.buf, this.bufLength, len3);
            if (len3 >= 0) {
                this.bufLength += len3;
            } else {
                this.close();
            }
            return;
        }
        if (this.startRemember >= 0) {
            if (this.rememberedText == null) {
                this.rememberedText = new StringBuffer();
            }
            this.rememberedText.append(this.buf, this.startRemember, this.bufPointer - this.startRemember);
        }
        boolean bl = extra = this.bufLength > 0 && this.bufPointer > 0;
        if (extra) {
            --this.bufPointer;
        }
        if (this.bufPointer > (half = this.buf.length >> 1)) {
            len = this.bufLength - half;
            System.arraycopy(this.buf, half, this.buf, 0, len);
            this.bufAbandon += half;
            this.bufPointer -= half;
            this.bufLength = len;
        } else {
            len = this.bufLength - this.bufPointer;
            System.arraycopy(this.buf, this.bufPointer, this.buf, 0, len);
            this.bufAbandon += this.bufPointer;
            this.bufPointer = 0;
        }
        this.bufLength = len;
        this.buf[this.bufLength++] = (char)c;
        len = this.buf.length - this.bufLength;
        for (len1 = 0; len1 < len && (len2 = this.in.read(this.buf, this.bufLength + len1, len - len1)) >= 0; len1 += len2) {
        }
        if (len1 >= 0) {
            this.bufLength += len1;
        } else {
            this.close();
        }
        if (extra) {
            ++this.bufPointer;
        }
        if (this.startRemember >= 0) {
            this.startRemember = this.bufPointer;
        }
    }

    @Override
    public void close() {
        try {
            if (this.in != null && !this.isClosed) {
                this.in.close();
            }
            this.in = null;
            this.isClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void fatal(String message) throws SAXException {
        this.fatal(message, null, null);
    }

    protected void fatal(String message, Object[] parameters) throws SAXException {
        this.fatal(message, parameters, null);
    }

    protected void fatal(String messageId, Object[] params, Exception e) throws SAXException {
        String msg = messageId;
        SAXParseException x = new SAXParseException(msg, this, e);
        this.close();
        if (this.errHandler != null) {
            this.errHandler.fatalError(x);
        }
        throw x;
    }

    protected void warning(String messageId, Object[] parameters) throws SAXException {
        String msg = "";
        SAXParseException x = new SAXParseException(msg, this);
        if (this.errHandler != null) {
            this.errHandler.warning(x);
        }
    }

    protected void error(String messageId, Object[] parameters) throws SAXException {
        String msg = "";
        SAXParseException x = new SAXParseException(msg, this);
        if (this.errHandler != null) {
            this.errHandler.error(x);
        }
    }

    public int peekCharNumber() {
        int retval = 0;
        boolean isNumber = false;
        char c = this.getc();
        if (c != 'x') {
            if (c != '\u0000') {
                this.ungetc();
            }
            while ((c = this.getc()) >= '0' && c <= '9') {
                retval *= 10;
                retval += c - 48;
                isNumber = true;
            }
            if (c != '\u0000') {
                this.ungetc();
            }
        } else {
            while (true) {
                if ((c = this.getc()) >= '0' && c <= '9') {
                    retval <<= 4;
                    retval += c - 48;
                    isNumber = true;
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    retval <<= 4;
                    retval += 10 + (c - 97);
                    isNumber = true;
                    continue;
                }
                if (c < 'A' || c > 'F') break;
                retval <<= 4;
                retval += 10 + (c - 65);
                isNumber = true;
            }
            if (c != '\u0000') {
                this.ungetc();
            }
        }
        return isNumber ? retval : -1;
    }

    public String peekQName() {
        String s = this.peekNCName();
        if (s == null) {
            return null;
        }
        if (!this.peekc(':')) {
            return s;
        }
        s = s + ":";
        String s1 = this.peekNCName();
        if (s1 == null) {
            this.back(s.length());
            return null;
        }
        return s + s1;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    private void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public class EndOfInputException
    extends IOException {
    }
}

