/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XFloat;
import com.argo21.common.lang.XFloatSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringSet;

public final class ArithmeticOperate
extends Operate {
    boolean enText = false;

    public ArithmeticOperate(int optCode, Operand left, Operand right) {
        this(optCode, left, right, true);
    }

    public ArithmeticOperate(int optCode, Operand left, Operand right, boolean enText) {
        super(optCode, left, right);
        this.enText = enText;
    }

    public ArithmeticOperate(String strOpt, Operand left, Operand right) {
        this(ArithmeticOperate.findCode(strOpt), left, right);
    }

    @Override
    public XData getData() throws XDataException {
        XData leftData = this.left.getData();
        XData rightData = this.right.getData();
        if (leftData == null) {
            XData.error("FIRST_INVALID", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (rightData == null) {
            XData.error("SECOND_INVALID", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (leftData.getDimension() > 1) {
            XData.error("FIRST_OVER_DIM1", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (rightData.getDimension() > 1) {
            XData.error("SECOND_OVER_DIM1", OPT[this.optCode]);
            return new XInteger(0);
        }
        int type = leftData.getPrimitiveType();
        int type2 = rightData.getPrimitiveType();
        if (type2 > type) {
            type = type2;
        }
        switch (type) {
            case 1: {
                return this.intOperate(leftData, rightData);
            }
            case 2: {
                return this.longOperate(leftData, rightData);
            }
            case 3: {
                return this.floatOperate(leftData, rightData);
            }
            case 4: {
                return this.doubleOperate(leftData, rightData);
            }
            case 6: {
                if (!this.enText || this.optCode != 2 && this.optCode != 1) break;
                return this.strOperate(leftData, rightData);
            }
        }
        return this.doubleOperate(leftData, rightData);
    }

    XData intOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            int result = 0;
            switch (this.optCode) {
                case 1: {
                    result = left.intValue() + right.intValue();
                    break;
                }
                case 2: {
                    result = left.intValue() - right.intValue();
                    break;
                }
                case 3: {
                    result = left.intValue() * right.intValue();
                    break;
                }
                case 4: {
                    int tmp = right.intValue();
                    if (tmp != 0) {
                        result = left.intValue() / tmp;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
                case 5: {
                    int tmp2 = right.intValue();
                    if (tmp2 != 0) {
                        result = left.intValue() % tmp2;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
            }
            return new XInteger(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        int[] result = new int[len];
        switch (this.optCode) {
            case 1: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) + right.intValue(i);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) - right.intValue(i);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) * right.intValue(i);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < len; ++i) {
                    int tmp = right.intValue(i);
                    if (tmp == 0) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.intValue(i) / tmp;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < len; ++i) {
                    int tmp = right.intValue(i);
                    if (tmp == 0) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.intValue(i) % tmp;
                }
                break;
            }
        }
        return new XIntegerSet(result);
    }

    XData longOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            long result = 0L;
            switch (this.optCode) {
                case 1: {
                    result = left.longValue() + right.longValue();
                    break;
                }
                case 2: {
                    result = left.longValue() - right.longValue();
                    break;
                }
                case 3: {
                    result = left.longValue() * right.longValue();
                    break;
                }
                case 4: {
                    long tmp = right.longValue();
                    if (tmp != 0L) {
                        result = left.longValue() / tmp;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
                case 5: {
                    long tmp2 = right.longValue();
                    if (tmp2 != 0L) {
                        result = left.longValue() % tmp2;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
            }
            return new XLong(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        long[] result = new long[len];
        switch (this.optCode) {
            case 1: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) + right.longValue(i);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) - right.longValue(i);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) * right.longValue(i);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < len; ++i) {
                    long tmp = right.longValue(i);
                    if (tmp == 0L) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.longValue(i) / tmp;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < len; ++i) {
                    long tmp = right.longValue(i);
                    if (tmp == 0L) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.longValue(i) % tmp;
                }
                break;
            }
        }
        return new XLongSet(result);
    }

    XData floatOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            float result = 0.0f;
            switch (this.optCode) {
                case 1: {
                    result = left.floatValue() + right.floatValue();
                    break;
                }
                case 2: {
                    result = left.floatValue() - right.floatValue();
                    break;
                }
                case 3: {
                    result = left.floatValue() * right.floatValue();
                    break;
                }
                case 4: {
                    float tmp = right.floatValue();
                    if (tmp != 0.0f) {
                        result = left.floatValue() / tmp;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
                case 5: {
                    float tmp2 = right.floatValue();
                    if (tmp2 != 0.0f) {
                        result = left.floatValue() % tmp2;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
            }
            return new XFloat(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        float[] result = new float[len];
        switch (this.optCode) {
            case 1: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.floatValue(i) + right.floatValue(i);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.floatValue(i) - right.floatValue(i);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.floatValue(i) * right.floatValue(i);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < len; ++i) {
                    float tmp = right.floatValue(i);
                    if (tmp == 0.0f) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.floatValue(i) / tmp;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < len; ++i) {
                    float tmp = right.floatValue(i);
                    if (tmp == 0.0f) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.floatValue(i) % tmp;
                }
                break;
            }
        }
        return new XFloatSet(result);
    }

    XData doubleOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            double result = 0.0;
            switch (this.optCode) {
                case 1: {
                    result = left.doubleValue() + right.doubleValue();
                    break;
                }
                case 2: {
                    result = left.doubleValue() - right.doubleValue();
                    break;
                }
                case 3: {
                    result = left.doubleValue() * right.doubleValue();
                    break;
                }
                case 4: {
                    double tmp = right.doubleValue();
                    if (tmp != 0.0) {
                        result = left.doubleValue() / tmp;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
                case 5: {
                    double tmp2 = right.doubleValue();
                    if (tmp2 != 0.0) {
                        result = left.doubleValue() % tmp2;
                        break;
                    }
                    XData.error("CANT_DIV_ZERO", new Object[0], true);
                    return left;
                }
            }
            return new XDouble(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        double[] result = new double[len];
        switch (this.optCode) {
            case 1: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.doubleValue(i) + right.doubleValue(i);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.doubleValue(i) - right.doubleValue(i);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.doubleValue(i) * right.doubleValue(i);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < len; ++i) {
                    double tmp = right.doubleValue(i);
                    if (tmp == 0.0) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.doubleValue(i) / tmp;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < len; ++i) {
                    double tmp = right.doubleValue(i);
                    if (tmp == 0.0) {
                        XData.error("CANT_DIV_ZERO", new Object[0], true);
                        return left;
                    }
                    result[i] = left.doubleValue(i) % tmp;
                }
                break;
            }
        }
        return new XDoubleSet(result);
    }

    private XData strOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            String result = "";
            if (this.optCode == 1) {
                result = left.stringValue() + right.stringValue();
            } else if (this.optCode == 2) {
                String s1 = left.stringValue();
                String s2 = right.stringValue();
                int len = s2.length();
                if (len != 0) {
                    int k = s1.indexOf(s2);
                    while (k >= 0) {
                        s1 = s1.substring(0, k) + s1.substring(k + len);
                        k = s1.indexOf(s2);
                    }
                }
                result = s1;
            }
            return new XString(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        String[] result = new String[len];
        if (this.optCode == 1) {
            for (int i = 0; i < len; ++i) {
                result[i] = left.stringValue(i) + right.stringValue(i);
            }
        } else if (this.optCode == 2) {
            for (int i = 0; i < len; ++i) {
                String s1 = left.stringValue();
                String s2 = right.stringValue();
                int slen = s2.length();
                if (slen != 0) {
                    int k = s1.indexOf(s2);
                    while (k >= 0) {
                        s1 = s1.substring(0, k) + s1.substring(k + slen);
                        k = s1.indexOf(s2);
                    }
                }
                result[i] = s1;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                result[i] = "";
            }
        }
        return new XStringSet(result);
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

