/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BeanUtils {
    private static Hashtable primitiveTypes = new Hashtable(11);

    public static Class getPrimitiveType(String name2) {
        return (Class)primitiveTypes.get(name2);
    }

    public static Class getClassType(ClassLoader loader, String name2) throws ClassNotFoundException {
        Class<?> type;
        String pname;
        int dimension = 0;
        int k1 = name2.indexOf("[]");
        if (k1 > 0) {
            pname = name2.substring(0, k1);
            ++dimension;
            k1 += 2;
            while ((k1 = name2.indexOf("[]", k1)) > 0) {
                ++dimension;
                k1 += 2;
            }
        } else {
            pname = name2;
        }
        if ((type = (Class<?>)primitiveTypes.get(pname)) == null) {
            type = loader != null ? Class.forName(pname, true, loader) : Class.forName(pname);
        }
        if (dimension == 0) {
            return type;
        }
        int[] def = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            def[i] = 1;
        }
        Object o = Array.newInstance(type, def);
        return o.getClass();
    }

    public static PropertyDescriptor findPropertyDescriptor(PropertyDescriptor[] pds, String name2) {
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(name2)) continue;
            return pds[i];
        }
        return null;
    }

    public static PropertyDescriptor findPropertyDescriptor(Class beanClass, String name2, boolean enSuper) {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor pd = BeanUtils.findPropertyDescriptor(info.getPropertyDescriptors(), name2);
            if (pd != null) {
                return pd;
            }
            if (enSuper && beanClass.getSuperclass() != null) {
                return BeanUtils.findPropertyDescriptor(beanClass.getSuperclass(), name2, enSuper);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static MethodDescriptor findMethodDescriptor(MethodDescriptor[] mds, String name2, int paramCount) {
        for (int i = 0; i < mds.length; ++i) {
            MethodDescriptor md = mds[i];
            if (!md.getName().equals(name2) || md.getMethod().getParameterTypes().length != paramCount) continue;
            return md;
        }
        return null;
    }

    public static MethodDescriptor findMethodDescriptor(Class beanClass, String name2, int paramCount, boolean enSuper) {
        try {
            Class scls;
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            MethodDescriptor md = BeanUtils.findMethodDescriptor(info.getMethodDescriptors(), name2, paramCount);
            if (md != null) {
                return md;
            }
            if (enSuper && (scls = beanClass.getSuperclass()) != null) {
                return BeanUtils.findMethodDescriptor(scls, name2, paramCount, enSuper);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setPropertyValue(Object bean, String name2, Object index, Object value) throws IllegalAccessException, NoSuchFieldException {
        PropertyDescriptor pd = BeanUtils.findPropertyDescriptor(bean.getClass(), name2, true);
        if (pd == null) {
            throw new NoSuchFieldException();
        }
        BeanUtils.setPropertyValue(bean, pd, index, value);
    }

    public static void setPropertyValue(Object bean, PropertyDescriptor pd, Object value) throws IllegalAccessException, NoSuchFieldException, IllegalArgumentException {
        BeanUtils.setPropertyValue(bean, pd, null, value);
    }

    public static void setPropertyValue(Object bean, PropertyDescriptor pd, Object index, Object value) throws IllegalAccessException, NoSuchFieldException, IllegalArgumentException {
        Method m = pd.getWriteMethod();
        Class<?> typeClass = pd.getPropertyType();
        Object newValue = BeanUtils.castType(typeClass, value);
        if (m == null) {
            String s = pd.getName();
            s = s.substring(0, 1).toUpperCase() + s.substring(1);
            try {
                m = index != null ? bean.getClass().getMethod("set" + s, index.getClass(), pd.getPropertyType()) : bean.getClass().getMethod("set" + s, pd.getPropertyType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m != null) {
            try {
                if (index != null && m.getParameterTypes().length == 2) {
                    m.invoke(bean, index, newValue);
                } else {
                    m.invoke(bean, newValue);
                }
                return;
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        Field f = bean.getClass().getField(pd.getName());
        f.set(bean, newValue);
    }

    public static Object getPropertyValue(Object bean, String name2, Object index) throws IllegalAccessException, NoSuchFieldException {
        PropertyDescriptor pd = BeanUtils.findPropertyDescriptor(bean.getClass(), name2, true);
        if (pd != null) {
            return BeanUtils.getPropertyValue(bean, pd, index);
        }
        throw new NoSuchFieldException("no such field : " + bean.getClass().getName() + "." + name2 + "[]");
    }

    public static Object getPropertyValue(Object bean, PropertyDescriptor pd) throws IllegalAccessException, NoSuchFieldException {
        return BeanUtils.getPropertyValue(bean, pd, null);
    }

    public static Object getPropertyValue(Object bean, PropertyDescriptor pd, Object index) throws IllegalAccessException, NoSuchFieldException {
        Method m = pd.getReadMethod();
        if (m == null) {
            String s = pd.getName();
            s = s.substring(0, 1).toUpperCase() + s.substring(1);
            try {
                m = index != null ? bean.getClass().getMethod("get" + s, index.getClass()) : bean.getClass().getMethod("get" + s, new Class[0]);
                m = bean.getClass().getMethod("get" + s, new Class[0]);
                if (m == null && pd.getPropertyType() == Boolean.TYPE) {
                    m = bean.getClass().getMethod("is" + s, new Class[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m != null) {
            try {
                if (index != null && m.getParameterTypes().length == 1) {
                    return m.invoke(bean, index);
                }
                return m.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        Field f = bean.getClass().getField(pd.getName());
        return f.get(bean);
    }

    public static Object invoke(Object bean, MethodDescriptor md, Object[] parameters) throws InvocationTargetException, IllegalAccessException {
        Method m = md.getMethod();
        return m.invoke(bean, parameters);
    }

    public static Object invoke(Object bean, String name2, Object[] parameters) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        MethodDescriptor md = BeanUtils.findMethodDescriptor(bean.getClass(), name2, parameters.length, true);
        if (md != null) {
            return BeanUtils.invoke(bean, md, parameters);
        }
        StringBuffer sb = new StringBuffer("no such method : ");
        BeanUtils.methodToString(bean.getClass(), name2, parameters, sb);
        throw new NoSuchMethodException(sb.toString());
    }

    public static void methodToString(Class bean, String name2, Object[] parameters, StringBuffer sb) {
        sb.append(bean.getClass().getName());
        sb.append('.');
        sb.append(name2);
        sb.append('(');
        for (int i = 0; i < parameters.length; ++i) {
            sb.append(BeanUtils.getTypeName(parameters[i].getClass()));
            if (i >= parameters.length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
    }

    public static boolean canCastFrom(Class type, Class from) {
        if (type.isAssignableFrom(from)) {
            return true;
        }
        Class<?>[] inters = type.getInterfaces();
        for (int i = 0; i < inters.length; ++i) {
            if (!BeanUtils.canCastFrom(inters[i], from)) continue;
            return true;
        }
        if ((type = type.getSuperclass()) == null) {
            return false;
        }
        return BeanUtils.canCastFrom(type, from);
    }

    public static Object castType(Class type, Object value) {
        if (value == null || type.isInstance(value)) {
            return value;
        }
        Class<?> type1 = value.getClass();
        if (BeanUtils.canCastFrom(type1, type)) {
            return value;
        }
        if (type.isArray()) {
            return BeanUtils.castArray(type, value);
        }
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                if (value instanceof Integer) {
                    return value;
                }
                return new Integer(String.valueOf(value));
            }
            if (type == Byte.TYPE) {
                if (value instanceof Byte) {
                    return value;
                }
                return new Byte(String.valueOf(value));
            }
            if (type == Long.TYPE) {
                if (value instanceof Long) {
                    return value;
                }
                return new Long(String.valueOf(value));
            }
            if (type == Float.TYPE) {
                if (value instanceof Float) {
                    return value;
                }
                return new Float(String.valueOf(value));
            }
            if (type == Double.TYPE) {
                if (value instanceof Double) {
                    return value;
                }
                return new Double(String.valueOf(value));
            }
            if (type == Short.TYPE) {
                if (value instanceof Short) {
                    return value;
                }
                return new Short(String.valueOf(value));
            }
            if (type == Character.TYPE) {
                if (value instanceof Character) {
                    return value;
                }
                String s = String.valueOf(value);
                if (s.length() > 0) {
                    return new Character(s.charAt(0));
                }
                return new Character('\u0000');
            }
            if (type == Boolean.TYPE) {
                if (value instanceof Boolean) {
                    return value;
                }
                return new Boolean(String.valueOf(value));
            }
        } else if (BeanUtils.canCastFrom(type, String.class)) {
            return String.valueOf(value);
        }
        throw new IllegalArgumentException("can't cast " + BeanUtils.getTypeName(value.getClass()) + " to " + BeanUtils.getTypeName(type));
    }

    public static Object castArray(Class type, Object src) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return (int[])src;
            }
            if (type == Byte.TYPE) {
                return (byte[])src;
            }
            if (type == Long.TYPE) {
                return (long[])src;
            }
            if (type == Float.TYPE) {
                return (float[])src;
            }
            if (type == Double.TYPE) {
                return (double[])src;
            }
            if (type == Short.TYPE) {
                return (short[])src;
            }
            if (type == Character.TYPE) {
                return (char[])src;
            }
            if (type == Boolean.TYPE) {
                return (boolean[])src;
            }
            throw new IllegalArgumentException(src.getClass().getName());
        }
        if (BeanUtils.canCastFrom(type, String.class)) {
            if (src instanceof String[]) {
                return (String[])src;
            }
            Object[] obj1 = (Object[])src;
            String[] res = new String[obj1.length];
            for (int i = 0; i < obj1.length; ++i) {
                res[i] = String.valueOf(obj1[i]);
            }
            return res;
        }
        return (Object[])src;
    }

    public static String getTypeName(Class type) {
        int k;
        String name2;
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                name2 = sb.toString();
            }
            catch (Throwable e) {
                name2 = "";
            }
        } else {
            name2 = type.getName();
        }
        if ((k = name2.lastIndexOf(".")) > 0) {
            return name2.substring(k + 1);
        }
        return name2;
    }

    public static Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException {
        Class<?> cls = bean.getClass();
        Object new_obj = cls.newInstance();
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (Exception e) {
            return new_obj;
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            Method mdr = pds[i].getReadMethod();
            Method mdw = pds[i].getWriteMethod();
            if (mdr == null || mdw == null) continue;
            try {
                Object value = mdr.invoke(bean, new Object[0]);
                mdw.invoke(new_obj, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new_obj;
    }

    public static Object readXMLBean(Writer out) throws ClassNotFoundException, IntrospectionException, IOException {
        Object bean = null;
        return bean;
    }

    public static void writeXMLBean(Object bean, Writer out) throws IntrospectionException, IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        Element root = doc.createElement("Bean");
        doc.appendChild(root);
        root.setAttribute("class", bean.getClass().getName());
    }

    public static void saveBeanPropertyToDom(Object bean, Document doc, Element root) throws IntrospectionException, IOException {
        BeanInfo info = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            try {
                Class<?> type = pds[i].getPropertyType();
                Object value = BeanUtils.getPropertyValue(bean, pds[i], null);
                if (value == null) continue;
                Element param = doc.createElement("Param");
                root.appendChild(param);
                param.setAttribute("name", pds[i].getName());
                if (!type.isArray()) {
                    String s = String.valueOf(value);
                    param.setAttribute("Value", s);
                    continue;
                }
                BeanUtils.createArrayNode(doc, param, (Object[])value);
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private static void createArrayNode(Document doc, Element node, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            Element item = doc.createElement("Item");
            String s = String.valueOf(value);
            node.setAttribute("Value", s);
        }
    }

    static {
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
    }
}

