/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;

public final class BitOperate
extends Operate {
    public BitOperate(int optCode, Operand left, Operand right) {
        super(optCode, left, right);
    }

    @Override
    public XData getData() throws XDataException {
        XData leftData = this.left.getData();
        XData rightData = this.right.getData();
        if (leftData == null) {
            XData.error("FIRST_INVALID", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (rightData == null) {
            XData.error("SECOND_INVALID", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (leftData.getDimension() > 1) {
            XData.error("FIRST_OVER_DIM1", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (rightData.getDimension() > 1) {
            XData.error("SECOND_OVER_DIM1", OPT[this.optCode]);
            return new XInteger(0);
        }
        int type = leftData.getPrimitiveType();
        int type2 = rightData.getPrimitiveType();
        if (type2 > type) {
            type = type2;
        }
        if (type == 1) {
            return this.intOperate(leftData, rightData);
        }
        return this.longOperate(leftData, rightData);
    }

    XData intOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            int result;
            switch (this.optCode) {
                case 6: {
                    result = left.intValue() & right.intValue();
                    break;
                }
                case 7: {
                    result = left.intValue() | right.intValue();
                    break;
                }
                case 8: {
                    result = left.intValue() ^ right.intValue();
                    break;
                }
                default: {
                    result = 0;
                }
            }
            return new XInteger(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        int[] result = new int[len];
        switch (this.optCode) {
            case 6: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) & right.intValue(i);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) | right.intValue(i);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) ^ right.intValue(i);
                }
                break;
            }
        }
        return new XIntegerSet(result);
    }

    XData longOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            long result;
            switch (this.optCode) {
                case 6: {
                    result = left.longValue() & right.longValue();
                    break;
                }
                case 7: {
                    result = left.longValue() | right.longValue();
                    break;
                }
                case 8: {
                    result = left.longValue() ^ right.longValue();
                    break;
                }
                default: {
                    result = 0L;
                }
            }
            return new XLong(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        long[] result = new long[len];
        switch (this.optCode) {
            case 6: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) & right.longValue(i);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) | right.longValue(i);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) ^ right.longValue(i);
                }
                break;
            }
        }
        return new XLongSet(result);
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

