/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;

public final class CompareOperate
extends Operate {
    boolean ignoreCase = false;

    public CompareOperate(int optCode, Operand left, Operand right) {
        super(optCode, left, right);
    }

    public CompareOperate(int optCode, Operand left, Operand right, boolean ignoreCase) {
        super(optCode, left, right);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public XData getData() throws XDataException {
        XData leftData = this.left.getData();
        XData rightData = this.right.getData();
        if (leftData == null) {
            XData.error("FIRST_INVALID", OPT[this.optCode]);
            return new XBoolean(false);
        }
        if (rightData == null) {
            XData.error("SECOND_INVALID", OPT[this.optCode]);
            return new XBoolean(false);
        }
        if (leftData.getDimension() > 1) {
            XData.error("FIRST_OVER_DIM1", OPT[this.optCode]);
            return new XBoolean(false);
        }
        if (rightData.getDimension() > 1) {
            XData.error("SECOND_OVER_DIM1", OPT[this.optCode]);
            return new XBoolean(false);
        }
        int dt = DATATYPE[this.optCode];
        if ((dt & 8) != 0 && (leftData.isBoolean() || rightData.isBoolean())) {
            return this.booleanOperate(leftData, rightData);
        }
        if ((dt & 4) != 0 && leftData.isNumber() && rightData.isNumber()) {
            return this.intOperate(leftData, rightData);
        }
        if ((dt & 2) != 0 && leftData.isNumber() && rightData.isNumber()) {
            if (this.optCode == 6 || this.optCode == 7 || this.optCode == 8 || this.optCode == 9 || this.optCode == 10) {
                return this.intOperate(leftData, rightData);
            }
            return this.floatOperate(leftData, rightData);
        }
        if ((dt & 1) != 0) {
            return this.strOperate(leftData, rightData);
        }
        return null;
    }

    XData booleanOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !left.isArray()) {
            boolean result;
            switch (this.optCode) {
                case 14: {
                    result = left.booleanValue() == right.booleanValue();
                    break;
                }
                case 15: {
                    result = left.booleanValue() != right.booleanValue();
                    break;
                }
                case 20: {
                    result = left.booleanValue() && right.booleanValue();
                    break;
                }
                case 21: {
                    result = left.booleanValue() || right.booleanValue();
                    break;
                }
                default: {
                    result = false;
                }
            }
            return new XBoolean(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        switch (this.optCode) {
            case 14: {
                for (int i = 0; i < len; ++i) {
                    if (left.booleanValue() == right.booleanValue()) continue;
                    new XBoolean(false);
                }
                return new XBoolean(true);
            }
            case 15: {
                for (int i = 0; i < len; ++i) {
                    if (left.booleanValue() != right.booleanValue()) continue;
                    new XBoolean(false);
                }
                return new XBoolean(true);
            }
            case 20: {
                for (int i = 0; i < len; ++i) {
                    if (left.booleanValue() && right.booleanValue()) continue;
                    new XBoolean(false);
                }
                return new XBoolean(true);
            }
            case 21: {
                for (int i = 0; i < len; ++i) {
                    if (left.booleanValue() || right.booleanValue()) continue;
                    new XBoolean(false);
                }
                return new XBoolean(true);
            }
        }
        return new XBoolean(false);
    }

    public XData intOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            boolean result = this.compareOperate(left.longValue(), right.longValue());
            return new XBoolean(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        for (int i = 0; i < len; ++i) {
            boolean result = this.compareOperate(left.longValue(i), right.longValue(i));
            if (result) continue;
            return new XBoolean(false);
        }
        return new XBoolean(true);
    }

    XData floatOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            boolean result = this.compareOperate(left.doubleValue(), right.doubleValue());
            return new XBoolean(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        for (int i = 0; i < len; ++i) {
            boolean result = this.compareOperate(left.doubleValue(i), right.doubleValue(i));
            if (result) continue;
            return new XBoolean(false);
        }
        return new XBoolean(true);
    }

    private XData strOperate(XData left, XData right) throws XDataException {
        int len2;
        if (!left.isArray() && !right.isArray()) {
            boolean result = this.compareOperate(left.stringValue(), right.stringValue());
            return new XBoolean(result);
        }
        int len1 = left.size();
        int len = len1 > (len2 = right.size()) ? len1 : len2;
        for (int i = 0; i < len; ++i) {
            boolean result = this.compareOperate(left.stringValue(i), right.stringValue(i));
            if (result) continue;
            return new XBoolean(false);
        }
        return new XBoolean(true);
    }

    private boolean compareOperate(long left, long right) throws XDataException {
        switch (this.optCode) {
            case 14: {
                return left == right;
            }
            case 15: {
                return left != right;
            }
            case 16: {
                return left < right;
            }
            case 17: {
                return left <= right;
            }
            case 18: {
                return left > right;
            }
            case 19: {
                return left >= right;
            }
        }
        return false;
    }

    private boolean compareOperate(double left, double right) {
        switch (this.optCode) {
            case 14: {
                return left == right;
            }
            case 15: {
                return left != right;
            }
            case 16: {
                return left < right;
            }
            case 17: {
                return left <= right;
            }
            case 18: {
                return left > right;
            }
            case 19: {
                return left >= right;
            }
        }
        return false;
    }

    private boolean compareOperate(String left, String right) throws XDataException {
        switch (this.optCode) {
            case 14: {
                if (this.ignoreCase) {
                    return left.equalsIgnoreCase(right);
                }
                return left.equals(right);
            }
            case 15: {
                if (this.ignoreCase) {
                    return !left.equalsIgnoreCase(right);
                }
                return !left.equals(right);
            }
            case 16: {
                if (this.ignoreCase) {
                    return this.ltStringIgnoreCase(left, right);
                }
                return this.ltString(left, right);
            }
            case 17: {
                if (this.ignoreCase) {
                    return !this.gtStringIgnoreCase(left, right);
                }
                return !this.gtString(left, right);
            }
            case 18: {
                if (this.ignoreCase) {
                    return this.gtStringIgnoreCase(left, right);
                }
                return this.gtString(left, right);
            }
            case 19: {
                if (this.ignoreCase) {
                    return !this.ltStringIgnoreCase(left, right);
                }
                return !this.ltString(left, right);
            }
        }
        return false;
    }

    private boolean ltString(String operand1, String operand2) {
        int l2;
        int l1 = operand1.length();
        int l = l1 < (l2 = operand1.length()) ? l1 : l2;
        for (int i = 0; i < l; ++i) {
            char c2;
            char c1 = operand1.charAt(i);
            if (c1 == (c2 = operand2.charAt(i))) continue;
            return c1 < c2;
        }
        return l1 < l2;
    }

    private boolean ltStringIgnoreCase(String operand1, String operand2) throws XDataException {
        int l2;
        int l1 = operand1.length();
        int l = l1 < (l2 = operand1.length()) ? l1 : l2;
        for (int i = 0; i < l; ++i) {
            char c2;
            char c1 = Character.toLowerCase(operand1.charAt(i));
            if (c1 == (c2 = Character.toLowerCase(operand2.charAt(i)))) continue;
            return c1 < c2;
        }
        return l1 < l2;
    }

    private boolean gtString(String operand1, String operand2) throws XDataException {
        int l2;
        int l1 = operand1.length();
        int l = l1 < (l2 = operand1.length()) ? l1 : l2;
        for (int i = 0; i < l; ++i) {
            char c2;
            char c1 = operand1.charAt(i);
            if (c1 == (c2 = operand2.charAt(i))) continue;
            return c1 > c2;
        }
        return l1 > l2;
    }

    private boolean gtStringIgnoreCase(String operand1, String operand2) throws XDataException {
        int l2;
        int l1 = operand1.length();
        int l = l1 < (l2 = operand1.length()) ? l1 : l2;
        for (int i = 0; i < l; ++i) {
            char c2;
            char c1 = Character.toLowerCase(operand1.charAt(i));
            if (c1 == (c2 = Character.toLowerCase(operand2.charAt(i)))) continue;
            return c1 > c2;
        }
        return l1 > l2;
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

