/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDate;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XFloat;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XString;
import com.argo21.common.util.Properties;
import com.argo21.jxp.parser.XmlParser;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DataTypeDecl {
    public String value = "";
    public int type = 6;
    public int size = 0;
    public String range = null;
    public char fillchar = '\u0000';
    public String format = null;
    private Object formatPattern = null;

    public static DataTypeDecl getDefaultDataTypeDecl() {
        return new DataTypeDecl();
    }

    public static DataTypeDecl getDefaultDataTypeDecl(String typeName) {
        int type = XData.getType(typeName);
        if (type >= 1 && type <= 4) {
            return new DataTypeDecl(type, 0, "0");
        }
        if (type == 5) {
            return new DataTypeDecl(type, 0, "false");
        }
        if (type == 6 || type == 7) {
            return new DataTypeDecl(type, 0, "");
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DataTypeDecl) {
            DataTypeDecl dt = (DataTypeDecl)obj;
            if (dt.type != this.type) {
                return false;
            }
            if (dt.size != this.size) {
                return false;
            }
            if (dt.fillchar != this.fillchar) {
                return false;
            }
            if (this.format != null ? !this.format.equals(dt.format) : dt.format != null && !dt.format.equals(this.format)) {
                return false;
            }
            if (this.value != null ? !this.value.equals(dt.value) : dt.value != null && !dt.value.equals(this.value)) {
                return false;
            }
            return !(this.range != null ? !this.range.equals(dt.range) : dt.range != null && !dt.range.equals(this.range));
        }
        return false;
    }

    public DataTypeDecl() {
    }

    public DataTypeDecl(int type, int size, String value) {
        this.type = type;
        this.size = size;
        this.value = value;
    }

    public DataTypeDecl(int type, int size, char fillchar, String range, String value) {
        this.type = type;
        this.size = size;
        this.fillchar = fillchar;
        this.range = range;
        this.value = value;
    }

    public DataTypeDecl(int type, int size, char fillchar, String range, String format, String value) {
        this.type = type;
        this.size = size;
        this.fillchar = fillchar;
        this.range = range;
        this.value = value;
        this.format = format;
    }

    public Object clone() {
        return new DataTypeDecl(this.type, this.size, this.fillchar, this.range, this.format, this.value);
    }

    public DataTypeDecl(Properties properties) {
        String s = properties.getValue("type");
        if (s != null) {
            this.type = XData.getType(s);
        }
        if ((s = properties.getValue("size")) != null) {
            try {
                this.size = Integer.parseInt(s);
            }
            catch (Exception e) {
                this.size = 0;
            }
        }
        if ((s = properties.getValue("fillchar")) != null) {
            this.fillchar = s.charAt(0);
        }
        if ((s = properties.getValue("range")) != null) {
            this.range = s;
        }
        if ((s = properties.getValue("value")) != null) {
            this.value = s;
        }
        this.format = properties.getValue("format");
        if (this.format != null && this.format.length() == 0) {
            this.format = null;
        }
    }

    public DataTypeDecl(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = attrs.item(i);
            String name2 = node.getNodeName().toUpperCase();
            String s = node.getNodeValue();
            if (name2.equals("TYPE")) {
                this.type = XData.getType(s);
                continue;
            }
            if (name2.equals("SIZE")) {
                try {
                    this.size = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (name2.equals("FILLCHAR")) {
                if (s.length() <= 0) continue;
                this.fillchar = s.charAt(0);
                continue;
            }
            if (name2.equals("RANGE")) {
                this.range = s;
                continue;
            }
            if (!name2.equals("FORMAT")) continue;
            this.format = s;
        }
        this.value = this.getNodeText(element);
        if (this.value == null) {
            this.value = "";
        }
    }

    public boolean isDefalut() {
        if (this.type != 6) {
            return false;
        }
        if (this.size != 0) {
            return false;
        }
        if (this.fillchar != '\u0000') {
            return false;
        }
        if (this.range != null && this.range.length() != 0) {
            return false;
        }
        if (this.format != null && this.format.length() != 0) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        return this.value.length() == 0;
    }

    public String getXML(String attr) {
        int n;
        StringBuffer sb = new StringBuffer();
        if (this.type != 6) {
            sb.append("type=\"");
            sb.append(XData.getTypeName(this.type));
            sb.append("\" ");
        }
        if (this.size != 0) {
            sb.append("size=\"");
            sb.append(this.size);
            sb.append("\" ");
        }
        if (this.fillchar != '\u0000') {
            sb.append("fillchar=\"");
            sb.append(this.fillchar);
            sb.append("\" ");
        }
        if (this.range != null) {
            sb.append("range=\"");
            sb.append(this.range);
            sb.append("\" ");
        }
        if (this.format != null) {
            sb.append("format=\"");
            sb.append(this.format);
            sb.append("\" ");
        }
        if ((n = sb.length()) > 0) {
            sb.setCharAt(n - 1, '>');
            sb.insert(0, "<DATA " + attr + " ");
        } else {
            if (this.value == null) {
                return null;
            }
            if (this.value.length() == 0) {
                return null;
            }
            sb.append("<DATA " + attr + ">");
        }
        if (this.value != null && this.value.length() != 0) {
            sb.append(this.value);
        }
        sb.append("</DATA>");
        return sb.toString();
    }

    private String getNodeText(Node node) {
        if (node.getNodeType() == 1) {
            return XmlParser.getElementText(node).trim();
        }
        return node.getNodeValue();
    }

    public int intValue() throws XDataException {
        if (this.value == null) {
            return 0;
        }
        return this.intValue(this.value);
    }

    public int intValue(String srcStr) throws XDataException {
        if (srcStr.length() == 0) {
            return 0;
        }
        srcStr = srcStr.trim();
        srcStr = this.delFillChar(srcStr, true);
        if (this.format != null) {
            try {
                NumberFormat form = this.getNumberFormat();
                Number num = form.parse(srcStr);
                return num.intValue();
            }
            catch (Exception e) {
                XData.error("CANT_PARSE_FMT", new Object[]{srcStr, this.format});
            }
        } else {
            try {
                return Integer.parseInt(srcStr);
            }
            catch (Exception e) {
                XData.error("VALUE_CANT_TO_TYPE", new Object[]{srcStr, "int"});
                return (int)this.doubleValue(srcStr);
            }
        }
        return 0;
    }

    public long longValue() throws XDataException {
        if (this.value == null) {
            return 0L;
        }
        return this.longValue(this.value);
    }

    public long longValue(String srcStr) throws XDataException {
        if (srcStr.length() == 0) {
            return 0L;
        }
        srcStr = srcStr.trim();
        srcStr = this.delFillChar(srcStr, true);
        if (this.format != null) {
            try {
                NumberFormat form = this.getNumberFormat();
                Number num = form.parse(srcStr);
                return num.longValue();
            }
            catch (Exception e) {
                XData.error("CANT_PARSE_FMT", new Object[]{srcStr, this.format});
            }
        } else {
            try {
                return Long.parseLong(srcStr);
            }
            catch (Exception e) {
                XData.error("VALUE_CANT_TO_TYPE", new Object[]{srcStr, "long"});
                return (long)this.doubleValue(srcStr);
            }
        }
        return 0L;
    }

    public float floatValue() throws XDataException {
        if (this.value == null) {
            return 0.0f;
        }
        return this.floatValue(this.value);
    }

    public float floatValue(String srcStr) throws XDataException {
        if (srcStr.length() == 0) {
            return 0.0f;
        }
        srcStr = srcStr.trim();
        srcStr = this.delFillChar(srcStr, true);
        if (this.format != null) {
            try {
                NumberFormat form = this.getNumberFormat();
                Number num = form.parse(srcStr);
                return num.floatValue();
            }
            catch (Exception e) {
                XData.error("CANT_PARSE_FMT", new Object[]{srcStr, this.format});
            }
        } else {
            try {
                return Float.parseFloat(srcStr);
            }
            catch (Exception e) {
                XData.error("VALUE_CANT_TO_TYPE", new Object[]{srcStr, "float"});
            }
        }
        return 0.0f;
    }

    public double doubleValue() throws XDataException {
        if (this.value == null) {
            return 0.0;
        }
        return this.doubleValue(this.value);
    }

    public double doubleValue(String srcStr) throws XDataException {
        if (srcStr.length() == 0) {
            return 0.0;
        }
        srcStr = srcStr.trim();
        srcStr = this.delFillChar(srcStr, true);
        if (this.format != null) {
            try {
                NumberFormat form = this.getNumberFormat();
                Number num = form.parse(srcStr);
                return num.doubleValue();
            }
            catch (Exception e) {
                XData.error("CANT_PARSE_FMT", new Object[]{srcStr, this.format});
            }
        } else {
            try {
                return Double.parseDouble(srcStr);
            }
            catch (Exception e) {
                XData.error("VALUE_CANT_TO_TYPE", new Object[]{srcStr, XData.getTypeName(this.type)});
            }
        }
        return 0.0;
    }

    public boolean booleanValue() throws XDataException {
        String _value = this.value.trim();
        return Boolean.valueOf(_value);
    }

    public boolean booleanValue(String srcStr) throws XDataException {
        srcStr = srcStr.trim();
        return Boolean.valueOf(srcStr);
    }

    public String stringValue() {
        if (this.value == null) {
            return null;
        }
        return this.stringValue(this.value);
    }

    public String stringValue(String srcStr) {
        return this.delFillChar(srcStr, false);
    }

    private NumberFormat getNumberFormat() {
        if (this.formatPattern == null) {
            this.formatPattern = new DecimalFormat(this.format);
        }
        return (NumberFormat)this.formatPattern;
    }

    private DateFormat getDateFormat() {
        if (this.formatPattern == null) {
            this.formatPattern = new SimpleDateFormat(this.format);
        }
        return (DateFormat)this.formatPattern;
    }

    public Date dateValue() throws XDataException {
        if (this.value == null) {
            return null;
        }
        return this.dateValue(this.value);
    }

    public Date dateValue(String srcStr) throws XDataException {
        if (srcStr == null || srcStr.length() == 0) {
            return null;
        }
        srcStr = this.delFillChar(srcStr, false);
        if (this.format != null) {
            try {
                DateFormat form = this.getDateFormat();
                return form.parse(srcStr);
            }
            catch (Exception e) {
                XData.error("CANT_PARSE_FMT", new Object[]{srcStr, this.format});
            }
        } else {
            try {
                return new Date(srcStr);
            }
            catch (Exception e) {
                XData.error("VALUE_CANT_TO_TYPE", new Object[]{srcStr, "Date"});
            }
        }
        return null;
    }

    public XData parseValue(String srcStr) throws XDataException {
        if (this.type == 6) {
            return new XString(this.stringValue(srcStr));
        }
        if (this.type == 1) {
            return new XInteger(this.intValue(srcStr));
        }
        if (this.type == 2) {
            return new XLong(this.longValue(srcStr));
        }
        if (this.type == 3) {
            return new XFloat(this.floatValue(srcStr));
        }
        if (this.type == 4) {
            return new XDouble(this.doubleValue(srcStr));
        }
        if (this.type == 7) {
            return new XDate(this.dateValue(srcStr));
        }
        if (this.type == 5) {
            return new XBoolean((boolean)Boolean.valueOf(srcStr));
        }
        return new XString(srcStr);
    }

    public String formatValue(long value) throws XDataException {
        if (this.format != null) {
            NumberFormat form = this.getNumberFormat();
            return this.resize(form.format(value));
        }
        return this.resize(String.valueOf(value));
    }

    public String formatValue(double value) throws XDataException {
        if (this.format != null) {
            NumberFormat form = this.getNumberFormat();
            return this.resize(form.format(value));
        }
        return this.resize(String.valueOf(value));
    }

    public String formatValue(boolean value) throws XDataException {
        return this.resize(new Boolean(value).toString());
    }

    public String formatValue(Date value) throws XDataException {
        DateFormat form = this.format != null ? this.getDateFormat() : DateFormat.getDateTimeInstance();
        return value == null ? "" : this.resize(form.format(value));
    }

    public String formatValue() throws XDataException {
        return this.formatValue(this.value);
    }

    public String formatValue(String data) throws XDataException {
        if (data == null) {
            data = "";
        }
        String value = data;
        try {
            if (this.isReal()) {
                double doubleValue = 0.0;
                if (value.length() > 0) {
                    doubleValue = Double.parseDouble(value);
                }
                return this.formatValue(doubleValue);
            }
            if (this.isInteger()) {
                long longValue = 0L;
                if (value.length() > 0) {
                    longValue = Long.parseLong(value);
                }
                return this.formatValue(longValue);
            }
            if (this.type == 7) {
                Date date = null;
                if (value.length() > 0) {
                    date = new Date(value);
                }
                return this.formatValue(date);
            }
            if (this.type == 5) {
                Boolean bool = Boolean.valueOf(value);
                return this.resize(bool.toString());
            }
        }
        catch (Exception e) {
            XData.error("VALUE_CANT_TO_TYPE", new Object[]{data, XData.getTypeName(this.type)});
        }
        return this.resize(value);
    }

    public String formatValue(XData data, int index) throws XDataException {
        String value = null;
        try {
            if (this.isReal()) {
                if (this.format != null) {
                    NumberFormat form = this.getNumberFormat();
                    value = form.format(data.doubleValue(index));
                    return this.resize(value);
                }
            } else if (this.isInteger()) {
                if (this.format != null) {
                    NumberFormat form = this.getNumberFormat();
                    value = form.format(data.longValue(index));
                    return this.resize(value);
                }
            } else if (this.type == 7) {
                if (this.format != null) {
                    DateFormat form = this.getDateFormat();
                    Date date = data.dateValue(index);
                    if (date == null) {
                        return "";
                    }
                    value = form.format(date);
                    return this.resize(value);
                }
            } else if (this.type == 5) {
                Boolean bool = new Boolean(data.booleanValue(index));
                value = bool.toString();
                return this.resize(value);
            }
        }
        catch (Exception e) {
            XData.error("VALUE_CANT_TO_TYPE", new Object[]{data.stringValue(index), XData.getTypeName(this.type)});
        }
        value = data.stringValue(index);
        return value == null ? "null" : this.resize(value);
    }

    private String delFillChar(String value, boolean before) {
        if (this.size == 0 && this.fillchar == '\u0000') {
            return value;
        }
        int n = value.length();
        if (before) {
            int first = 0;
            if (first < n && value.charAt(first) == this.fillchar) {
                ++first;
            }
            return value.substring(first);
        }
        int last2 = n - 1;
        if (last2 >= 0 && value.charAt(last2) == this.fillchar) {
            --last2;
        }
        return value.substring(0, last2 + 1);
    }

    private String resize(String value) {
        StringBuffer sb;
        block7: {
            if (this.size == 0 && this.fillchar == '\u0000') {
                return value;
            }
            sb = new StringBuffer();
            if (this.size > 0 && value.length() > this.size) {
                sb.append(value.substring(0, this.size));
            } else {
                sb.append(value);
            }
            if (this.fillchar == '\u0000') break block7;
            int fillnum = this.size - sb.length();
            if (this.isNumber()) {
                for (int i = 0; i < fillnum; ++i) {
                    sb.insert(0, this.fillchar);
                }
            } else {
                for (int i = 0; i < fillnum; ++i) {
                    sb.append(this.fillchar);
                }
            }
        }
        return sb.toString();
    }

    public int getType() {
        return this.type;
    }

    public boolean isReal() {
        return this.type == 4 | this.type == 3;
    }

    public boolean isInteger() {
        return this.type == 1 | this.type == 2;
    }

    public boolean isNumber() {
        return this.isReal() | this.isInteger();
    }

    public boolean isString() {
        return this.type == 6;
    }
}

