/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XNull;

public final class IncOrDecOperate
extends Operate {
    public IncOrDecOperate(int optCode, Operand left, Operand right) {
        super(optCode, left, right);
    }

    @Override
    public XData getData() throws XDataException {
        if (this.left != null) {
            XData xdata = this.left.getData();
            if (xdata.getPrimitiveType() == 1) {
                return this.leftIntOperate(xdata);
            }
            return this.leftLongOperate(xdata);
        }
        if (this.right != null) {
            XData xdata = this.right.getData();
            if (xdata.getPrimitiveType() == 1) {
                return this.rightIntOperate(xdata);
            }
            return this.rightLongOperate(xdata);
        }
        return new XNull();
    }

    private XData leftIntOperate(XData leftData) throws XDataException {
        if (!leftData.isArray()) {
            int result = leftData.intValue();
            int tmp = this.optCode == 22 ? result + 1 : result - 1;
            this.left.setData(new XInteger(tmp));
            return new XInteger(result);
        }
        XDataSet leftData1 = (XDataSet)leftData;
        int len = leftData.size();
        int[] result = new int[len];
        if (this.optCode == 22) {
            for (int i = 0; i < len; ++i) {
                result[i] = leftData1.intValue(i);
                int tmp = result[i] + 1;
                leftData1.setValue(i, tmp);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                result[i] = leftData1.intValue(i);
                int tmp = result[i] - 1;
                leftData1.setValue(i, tmp);
            }
        }
        return new XIntegerSet(result);
    }

    private XData rightIntOperate(XData rightData) throws XDataException {
        if (!rightData.isArray()) {
            int tmp;
            int result = rightData.intValue();
            result = tmp = this.optCode == 22 ? result + 1 : result - 1;
            this.right.setData(new XInteger(tmp));
            return new XInteger(result);
        }
        XDataSet rightData1 = (XDataSet)rightData;
        int len = rightData.size();
        int[] result = new int[len];
        if (this.optCode == 22) {
            for (int i = 0; i < len; ++i) {
                int tmp = rightData1.intValue(i);
                result[i] = ++tmp;
                rightData1.setValue(i, tmp);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                int tmp = rightData1.intValue(i);
                result[i] = --tmp;
                rightData1.setValue(i, tmp);
            }
        }
        return new XIntegerSet(result);
    }

    private XData leftLongOperate(XData leftData) throws XDataException {
        if (!leftData.isArray()) {
            long result = leftData.longValue();
            long tmp = this.optCode == 22 ? result + 1L : result - 1L;
            this.left.setData(new XLong(tmp));
            return new XLong(result);
        }
        XDataSet leftData1 = (XDataSet)leftData;
        int len = leftData.size();
        long[] result = new long[len];
        if (this.optCode == 22) {
            for (int i = 0; i < len; ++i) {
                result[i] = leftData1.longValue(i);
                long tmp = result[i] + 1L;
                leftData1.setValue(i, tmp);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                result[i] = leftData1.longValue(i);
                long tmp = result[i] - 1L;
                leftData1.setValue(i, tmp);
            }
        }
        return new XLongSet(result);
    }

    private XData rightLongOperate(XData rightData) throws XDataException {
        if (!rightData.isArray()) {
            long tmp;
            long result = rightData.longValue();
            result = tmp = this.optCode == 22 ? result + 1L : result - 1L;
            this.right.setData(new XLong(tmp));
            return new XLong(result);
        }
        XDataSet rightData1 = (XDataSet)rightData;
        int len = rightData.size();
        long[] result = new long[len];
        if (this.optCode == 22) {
            for (int i = 0; i < len; ++i) {
                long tmp = rightData1.longValue(i);
                result[i] = ++tmp;
                rightData1.setValue(i, tmp);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                long tmp = rightData1.longValue(i);
                result[i] = --tmp;
                rightData1.setValue(i, tmp);
            }
        }
        return new XLongSet(result);
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

