/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XBooleanSet;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDate;
import com.argo21.common.lang.XDateSet;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XFloat;
import com.argo21.common.lang.XFloatSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XObjectSet;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringSet;
import java.util.Date;

public final class Index
implements Operand {
    Operand orient;
    Operand min;
    Operand max;

    public Index(Operand orient, Operand min, Operand max) {
        this.orient = orient;
        this.min = min;
        this.max = max;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public XData getData() throws XDataException {
        int maxIndex;
        XData data = this.orient.getData();
        if (!data.isArray()) {
            return data;
        }
        int minIndex = this.min.getData().intValue();
        int n = maxIndex = this.max == null ? minIndex : this.max.getData().intValue();
        if (minIndex > maxIndex) {
            int tmp = minIndex;
            minIndex = maxIndex;
            maxIndex = tmp;
        }
        int type = data.getType();
        switch (type) {
            case 261: {
                return this.booleanValue(data, minIndex, maxIndex);
            }
            case 257: {
                return this.intValue(data, minIndex, maxIndex);
            }
            case 258: {
                return this.longValue(data, minIndex, maxIndex);
            }
            case 259: {
                return this.floatValue(data, minIndex, maxIndex);
            }
            case 260: {
                return this.doubleValue(data, minIndex, maxIndex);
            }
            case 262: {
                return this.stringValue(data, minIndex, maxIndex);
            }
            case 263: {
                return this.dateValue(data, minIndex, maxIndex);
            }
            case 273: {
                return this.objectValue(data, minIndex, maxIndex);
            }
            case 274: {
                return this.nodeValue(data, minIndex, maxIndex);
            }
        }
        XData.error("CANT_INDEX", XData.getTypeName(type));
        return null;
    }

    @Override
    public void setData(XData data) throws XDataException {
        int maxIndex;
        XData old = this.orient.getData();
        if (!old.isArray()) {
            this.orient.setData(data);
        }
        int minIndex = this.min.getData().intValue();
        int n = maxIndex = this.max == null ? minIndex : this.max.getData().intValue();
        if (minIndex > maxIndex) {
            int tmp = minIndex;
            minIndex = maxIndex;
            maxIndex = tmp;
        }
        int type = old.getType();
        switch (type) {
            case 261: {
                this.booleanValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 257: {
                this.intValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 258: {
                this.longValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 259: {
                this.floatValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 260: {
                this.doubleValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 262: {
                this.stringValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 263: {
                this.dateValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 273: {
                this.objectValueSet(old, data, minIndex, maxIndex);
                return;
            }
            case 274: {
                this.nodeValueSet(old, data, minIndex, maxIndex);
                return;
            }
        }
        XData.error("CANT_INDEX", XData.getTypeName(type));
    }

    XData booleanValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XBoolean(data.booleanValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        boolean[] res = new boolean[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.booleanValue(i + minIndex);
        }
        return new XBooleanSet(res);
    }

    XData intValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XInteger(data.intValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        int[] res = new int[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.intValue(i + minIndex);
        }
        return new XIntegerSet(res);
    }

    XData longValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XLong(data.longValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        long[] res = new long[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.longValue(i + minIndex);
        }
        return new XLongSet(res);
    }

    XData floatValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XFloat(data.floatValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        float[] res = new float[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.floatValue(i + minIndex);
        }
        return new XFloatSet(res);
    }

    XData doubleValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XDouble(data.doubleValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        double[] res = new double[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.doubleValue(i + minIndex);
        }
        return new XDoubleSet(res);
    }

    XData stringValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XString(data.stringValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        String[] res = new String[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.stringValue(i + minIndex);
        }
        return new XStringSet(res);
    }

    XData dateValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XDate(data.dateValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        Date[] res = new Date[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.dateValue(i + minIndex);
        }
        return new XDateSet(res);
    }

    XData objectValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XObject(data.objectValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        Object[] res = new Object[count2];
        for (int i = 0; i < count2; ++i) {
            res[i] = data.objectValue(i + minIndex);
        }
        XObjectSet tem = new XObjectSet(res);
        tem.elementType = data.getPrimitiveType();
        return tem;
    }

    XData nodeValue(XData data, int minIndex, int maxIndex) throws XDataException {
        if (maxIndex == minIndex) {
            return new XNode(data.nodeValue(minIndex));
        }
        int count2 = maxIndex - minIndex + 1;
        NodeListImpl res = new NodeListImpl();
        for (int i = 0; i < count2; ++i) {
            res.addNode(data.nodeValue(i + minIndex));
        }
        XNodeSet tem = new XNodeSet(res);
        tem.typeDecl = ((XNodeSet)data).typeDecl;
        return tem;
    }

    void booleanValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.booleanValue(i));
        }
    }

    void intValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.intValue(i));
        }
    }

    void longValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.longValue(i));
        }
    }

    void floatValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.floatValue(i));
        }
    }

    void doubleValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.doubleValue(i));
        }
    }

    void stringValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.stringValue(i));
        }
    }

    void dateValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.dateValue(i));
        }
    }

    void objectValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.objectValue(i));
        }
    }

    void nodeValueSet(XData old, XData data, int minIndex, int maxIndex) throws XDataException {
        int count2 = maxIndex - minIndex + 1;
        for (int i = 0; i < count2; ++i) {
            old.setValue(i + minIndex, data.nodeValue(i));
        }
    }

    @Override
    public Class getDataType() {
        return this.orient.getDataType();
    }

    @Override
    public void setDataType(Class datatype) {
    }

    @Override
    public String getReference() {
        return this.orient.getReference();
    }

    @Override
    public void setReference(String reference) {
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

