/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.io.Debug;
import com.argo21.common.lang.BeanUtils;
import com.argo21.common.lang.CanAccessAsBean;
import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectDeclarationEntry;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XObject;
import java.lang.reflect.InvocationTargetException;

public final class Method
implements Operand {
    Operand orient;
    Operand[] parameters;
    int count = 0;
    String name;
    boolean isStatic;
    Class datatype = null;

    public static boolean contain(Object object, String name2, int paramcount) {
        if (object instanceof CanAccessAsBean) {
            return BeanUtils.findMethodDescriptor(object.getClass(), name2, paramcount, true) != null;
        }
        ObjectDeclaration od = ObjectManager.getObjectDeclaration(object.getClass(), true);
        if (od != null) {
            return od.getObjectDeclarationEntry(name2, paramcount, false) != null;
        }
        return false;
    }

    public Method(Operand orient, String name2) {
        this(orient, name2, false);
    }

    public Method(Operand orient, String name2, boolean isStatic) {
        this.orient = orient;
        this.name = name2;
        this.isStatic = isStatic;
        this.parameters = new Operand[4];
    }

    public Method(Operand orient, String name2, Operand[] parameters) {
        this.orient = orient;
        this.name = name2;
        this.isStatic = false;
        this.parameters = parameters;
        this.count = parameters.length;
    }

    public void addParameters(Operand parameter) {
        if (this.count >= this.parameters.length) {
            Operand[] tmp = new Operand[this.count + 1];
            System.arraycopy(this.parameters, 0, tmp, 0, this.count);
            this.parameters = tmp;
        }
        this.parameters[this.count++] = parameter;
    }

    @Override
    public int getType() {
        return 5;
    }

    public void check() throws XDataException {
        ObjectDeclarationEntry entry;
        ObjectDeclaration od;
        Class<XData> type = this.orient.getDataType();
        if (type == null) {
            type = XData.class;
        }
        if ((od = ObjectManager.getObjectDeclaration(type, true)) == null) {
            XData.error("INVALID_METHOD", this.name, true);
        }
        if ((entry = od.getObjectDeclarationEntry(this.name, this.count, this.isStatic)) == null) {
            XData.error("INVALID_METHOD", this.name, true);
        }
        this.datatype = entry.getValueType();
    }

    @Override
    public XData getData() throws XDataException {
        Object obj1 = this.orient.getData();
        if (obj1 == null) {
            XData.error("INVALID_METHOD", this.name, true);
        }
        if (obj1 instanceof XObject) {
            obj1 = ((XObject)obj1).objectValue();
        }
        XData[] params = new XData[this.count];
        for (int i = 0; i < this.count; ++i) {
            params[i] = this.parameters[i].getData();
        }
        if (obj1 instanceof CanAccessAsBean) {
            try {
                Object[] objs = new Object[this.count];
                for (int i = 0; i < this.count; ++i) {
                    objs[i] = params[i].objectValue();
                }
                Object obj = BeanUtils.invoke(obj1, this.name, objs);
                return XData.convertToXData(obj);
            }
            catch (InvocationTargetException e) {
                Throwable e1 = e.getTargetException();
                if (e1 instanceof XDataException) {
                    throw (XDataException)e1;
                }
                if (e1 instanceof Exception) {
                    XData.error((Exception)e.getTargetException(), true);
                }
                Debug.println(e);
            }
            catch (NoSuchMethodException e) {
                XData.error(e, true);
            }
            catch (IllegalAccessException e) {
                XData.error(e, true);
            }
            catch (Exception e) {
                Debug.println(e);
                return null;
            }
        } else {
            ObjectDeclaration od = ObjectManager.getObjectDeclaration(obj1.getClass(), true);
            if (od != null) {
                try {
                    return od.invoke(this.name, obj1, params, this.isStatic);
                }
                catch (NoSuchMethodException e) {
                    XData.error("INVALID_METHOD", this.name, true);
                }
                catch (XDataException e) {
                    throw e;
                }
                catch (Exception e) {
                    Debug.println(e);
                    return null;
                }
            }
        }
        XData.error("INVALID_METHOD", this.name, true);
        return null;
    }

    @Override
    public void setData(XData data) throws XDataException {
    }

    @Override
    public Class getDataType() {
        if (this.datatype == null) {
            ObjectDeclarationEntry entry;
            ObjectDeclaration od;
            Class<XData> type = this.orient.getDataType();
            if (type == null) {
                type = XData.class;
            }
            if ((od = ObjectManager.getObjectDeclaration(type, true)) != null && (entry = od.getObjectDeclarationEntry(this.name, this.count, this.isStatic)) != null) {
                Class[] types = new Class[this.count];
                for (int i = 0; i < this.count; ++i) {
                    types[i] = this.parameters[i].getDataType();
                }
                this.datatype = entry.getValueType(types);
            }
            if (this.datatype == null) {
                this.datatype = XData.class;
            }
        }
        return this.datatype;
    }

    @Override
    public void setDataType(Class datatype) {
    }

    @Override
    public String getReference() {
        return this.orient.getReference() + "." + this.name + "()";
    }

    @Override
    public void setReference(String reference) {
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

