/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XNull;
import com.argo21.common.lang.XString;

public final class MixOperate
extends Operate {
    Operand third;

    public MixOperate(Operand condition, Operand value1, Operand value2) {
        super(25, condition, value1);
        this.third = value2;
    }

    public MixOperate(int optid, Operand value1, Operand value2) {
        super(optid, value1, value2);
    }

    @Override
    public XData getData() throws XDataException {
        if (this.optCode == 30) {
            XData leftData = this.left.getData();
            XData rightData = this.right.getData();
            int num = rightData.intValue();
            return leftData.extendDataSet(num);
        }
        if (this.optCode == 28) {
            XData leftData = this.left.getData();
            XData rightData = this.right.getData();
            int type = Math.max(leftData.getPrimitiveType(), rightData.getPrimitiveType());
            int n = rightData.size();
            switch (type) {
                case 5: {
                    boolean b = leftData.booleanValue();
                    for (int i = 0; i < n; ++i) {
                        if (rightData.booleanValue(i) != b) continue;
                        return new XBoolean(true);
                    }
                    break;
                }
                case 1: 
                case 2: {
                    long l = leftData.longValue();
                    for (int i = 0; i < n; ++i) {
                        if (rightData.longValue(i) != l) continue;
                        return new XBoolean(true);
                    }
                    break;
                }
                case 3: 
                case 4: {
                    double d = leftData.doubleValue();
                    for (int i = 0; i < n; ++i) {
                        if (rightData.doubleValue(i) != d) continue;
                        return new XBoolean(true);
                    }
                    break;
                }
                default: {
                    Object o = leftData.objectValue();
                    if (o != null) break;
                    for (int i = 0; i < n; ++i) {
                        if (!o.equals(rightData.objectValue(i))) continue;
                        return new XBoolean(true);
                    }
                }
            }
            return new XBoolean(false);
        }
        if (this.optCode == 29) {
            XData rightData = this.right.getData();
            return new XString(rightData.getPrimitiveTypeName());
        }
        if (this.optCode == 25) {
            XData condition = this.left.getData();
            if (condition.booleanValue()) {
                return this.right.getData();
            }
            return this.third.getData();
        }
        return new XNull();
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

