/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeVector {
    private int blocksize = 8;
    protected Node[] nodeBuff;
    private int count = 0;

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.nodeBuff.length;
        if (minCapacity > oldCapacity) {
            Node[] oldData = this.nodeBuff;
            int newCapacity = oldCapacity + this.blocksize;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.nodeBuff = new Node[newCapacity];
            System.arraycopy(oldData, 0, this.nodeBuff, 0, this.count);
        }
    }

    public NodeVector() {
        this.blocksize = 8;
        this.nodeBuff = new Node[this.blocksize];
    }

    public NodeVector(int minCapacity) {
        this.blocksize = 8;
        this.nodeBuff = new Node[minCapacity];
    }

    public NodeVector(int blocksize, int minCapacity) {
        this.blocksize = blocksize;
        this.nodeBuff = new Node[minCapacity];
    }

    public final int size() {
        return this.count;
    }

    public final void addElement(Node value) {
        if (this.count >= this.nodeBuff.length) {
            int newSize = this.nodeBuff.length + this.blocksize;
            Node[] newMap = new Node[newSize];
            System.arraycopy(this.nodeBuff, 0, newMap, 0, this.count);
            this.nodeBuff = newMap;
        }
        this.nodeBuff[this.count++] = value;
    }

    public final void insertElementAt(Node value, int at) {
        if (this.count >= this.nodeBuff.length) {
            int newSize = this.nodeBuff.length + this.blocksize;
            Node[] newMap = new Node[newSize];
            System.arraycopy(this.nodeBuff, 0, newMap, 0, this.count);
            this.nodeBuff = newMap;
        }
        if (at <= this.count - 1) {
            System.arraycopy(this.nodeBuff, at, this.nodeBuff, at + 1, this.count - at);
        }
        this.nodeBuff[at] = value;
        ++this.count;
    }

    public void appendNodes(NodeVector nodes) {
        int nNodes = nodes.size();
        if (this.count + nNodes >= this.nodeBuff.length) {
            int newSize = nNodes + this.nodeBuff.length + this.blocksize;
            Node[] newMap = new Node[newSize];
            System.arraycopy(this.nodeBuff, 0, newMap, 0, this.count);
            this.nodeBuff = newMap;
        }
        System.arraycopy(nodes.nodeBuff, 0, this.nodeBuff, this.count, nNodes);
        this.count += nNodes;
    }

    public void appendNodes(NodeList nodes) {
        int nNodes = nodes.getLength();
        if (this.count + nNodes >= this.nodeBuff.length) {
            int newSize = nNodes + this.nodeBuff.length + this.blocksize;
            Node[] newMap = new Node[newSize];
            System.arraycopy(this.nodeBuff, 0, newMap, 0, this.count);
            this.nodeBuff = newMap;
        }
        for (int i = 0; i < nNodes; ++i) {
            this.nodeBuff[this.count++] = nodes.item(i);
        }
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.count; ++i) {
            this.nodeBuff[i] = null;
        }
        this.count = 0;
    }

    public final String getSameName() {
        if (this.count == 0) {
            return null;
        }
        String name2 = this.nodeBuff[0].getNodeName();
        for (int i = 0; i < this.count; ++i) {
            if (this.nodeBuff[i].getNodeName().equals(name2)) continue;
            return null;
        }
        return name2;
    }

    public final boolean removeElement(Node s) {
        for (int i = 0; i < this.count; ++i) {
            Node node = this.nodeBuff[i];
            if (null == node || !node.equals(s)) continue;
            if (i > this.count) {
                System.arraycopy(this.nodeBuff, i + 1, this.nodeBuff, i - 1, this.count - i);
            } else {
                this.nodeBuff[i] = null;
            }
            --this.count;
            return true;
        }
        return false;
    }

    public final void removeElementAt(int i) {
        if (i > this.count) {
            System.arraycopy(this.nodeBuff, i + 1, this.nodeBuff, i - 1, this.count - i);
        } else {
            this.nodeBuff[i] = null;
        }
    }

    public final void setElementAt(Node node, int index) {
        this.nodeBuff[index] = node;
    }

    public final Node elementAt(int i) {
        return this.nodeBuff[i];
    }

    public final boolean contains(Node s) {
        for (int i = 0; i < this.count; ++i) {
            Node node = this.nodeBuff[i];
            if (null == node || !node.equals(s)) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(Node elem, int index) {
        for (int i = index; i < this.count; ++i) {
            Node node = this.nodeBuff[i];
            if (null == node || !node.equals(elem)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(Node elem) {
        for (int i = 0; i < this.count; ++i) {
            Node node = this.nodeBuff[i];
            if (null == node || !node.equals(elem)) continue;
            return i;
        }
        return -1;
    }
}

