/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.io.Debug;
import com.argo21.common.lang.ObjectDeclarationEntry;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.TypeRefrance;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ObjectDeclaration {
    public static final int ANY_PRAMETERS = 10000;
    private Class cls;
    private String scriptName;
    Hashtable entries;

    ObjectDeclaration(Class cls) {
        this(cls, cls.getName());
    }

    ObjectDeclaration(Class cls, String scriptName) {
        this.cls = cls;
        this.scriptName = scriptName;
        this.entries = new Hashtable();
    }

    public void addPropertyDeclaration(String name2, Method surpportMethod, String invokeId, Class retType, boolean write) {
        this.addPropertyDeclaration(name2, surpportMethod, invokeId, retType, write, false, false);
    }

    public void addPropertyDeclaration(String name2, Method surpportMethod, String invokeId, Class retType, boolean write, boolean canIndex) {
        this.addPropertyDeclaration(name2, surpportMethod, invokeId, retType, write, canIndex, false);
    }

    public void addPropertyDeclaration(String name2, Method surpportMethod, String invokeId, Class retType, boolean write, boolean canIndex, boolean isStatic) {
        String key = canIndex ? name2 + "[]" : name2;
        String string2 = key = write ? key + "-w" : key + "-r";
        if (isStatic) {
            key = "static " + key;
        }
        this.entries.put(key, new ObjectDeclarationEntry(key, name2, surpportMethod, invokeId, retType));
    }

    public void addPropertyDeclaration(String name2, Method surpportMethod, String invokeId, TypeRefrance retType, boolean write, boolean canIndex, boolean isStatic) {
        String key = canIndex ? name2 + "[]" : name2;
        String string2 = key = write ? key + "-w" : key + "-r";
        if (isStatic) {
            key = "static " + key;
        }
        this.entries.put(key, new ObjectDeclarationEntry(key, name2, surpportMethod, invokeId, retType));
    }

    public void addPropertyDeclaration(PropertyDescriptor pd) {
        String key;
        String name2 = pd.getName();
        Method md = pd.getReadMethod();
        if (md != null) {
            key = name2 + "-r";
            this.entries.put(key, new ObjectDeclarationEntry(key, name2, pd));
        }
        if ((md = pd.getWriteMethod()) != null) {
            key = name2 + "-w";
            this.entries.put(key, new ObjectDeclarationEntry(key, name2, pd));
        }
    }

    public void addMethodDeclaration(String name2, Method surpportMethod, String invokeId, Class retType) {
        this.addMethodDeclaration(name2, surpportMethod, invokeId, retType, 0, false);
    }

    public void addMethodDeclaration(String name2, Method surpportMethod, String invokeId, Class retType, int parameterCount) {
        this.addMethodDeclaration(name2, surpportMethod, invokeId, retType, parameterCount, false);
    }

    public void addMethodDeclaration(String name2, Method surpportMethod, String invokeId, Class retType, int parameterCount, boolean isStatic) {
        String key = name2 + "(" + parameterCount + ")";
        if (isStatic) {
            key = "static " + key;
        }
        this.entries.put(key, new ObjectDeclarationEntry(key, name2, surpportMethod, invokeId, retType));
    }

    public void addMethodDeclaration(String name2, Method surpportMethod, String invokeId, TypeRefrance retType, int parameterCount, boolean isStatic) {
        String key = name2 + "(" + parameterCount + ")";
        if (isStatic) {
            key = "static " + key;
        }
        this.entries.put(key, new ObjectDeclarationEntry(key, name2, surpportMethod, invokeId, retType));
    }

    public void addMethodDeclaration(MethodDescriptor method) {
        String name2 = method.getName();
        int n = method.getParameterDescriptors().length;
        String key = name2 + "(" + n + ")";
        this.entries.put(key, new ObjectDeclarationEntry(key, name2, method));
    }

    private static ObjectDeclarationEntry findDeclarationEntry(ObjectDeclaration od, String key) {
        ObjectDeclarationEntry entry = (ObjectDeclarationEntry)od.entries.get(key);
        if (entry != null) {
            return entry;
        }
        Class supercls = od.cls.getSuperclass();
        if (supercls == null) {
            od = ObjectManager.getObjectDeclaration(XData.class);
            if (od != null) {
                return (ObjectDeclarationEntry)od.entries.get(key);
            }
            return null;
        }
        od = ObjectManager.getObjectDeclaration(supercls);
        if (od != null) {
            return ObjectDeclaration.findDeclarationEntry(od, key);
        }
        return null;
    }

    public ObjectDeclarationEntry getObjectDeclarationEntry(String name2, boolean write, boolean canIndex, boolean isStatic) {
        String key = canIndex ? name2 + "[]" : name2;
        key = write ? key + "-w" : key + "-r";
        ObjectDeclarationEntry entry = null;
        if (isStatic) {
            key = "static " + key;
            entry = ObjectDeclaration.findDeclarationEntry(this, key);
        } else {
            entry = ObjectDeclaration.findDeclarationEntry(this, key);
            if (entry == null) {
                entry = ObjectDeclaration.findDeclarationEntry(this, "static" + key);
            }
        }
        return entry;
    }

    public ObjectDeclarationEntry getObjectDeclarationEntry(String name2, int params, boolean isStatic) {
        String key = name2 + "(" + params + ")";
        ObjectDeclarationEntry entry = null;
        if (isStatic) {
            key = "static " + key;
            entry = ObjectDeclaration.findDeclarationEntry(this, key);
        } else {
            entry = ObjectDeclaration.findDeclarationEntry(this, key);
            if (entry == null) {
                entry = ObjectDeclaration.findDeclarationEntry(this, "static " + key);
            }
        }
        if (entry == null) {
            key = name2 + "(" + 10000 + ")";
            if (isStatic) {
                key = "static " + key;
                entry = (ObjectDeclarationEntry)this.entries.get(key);
            } else {
                entry = (ObjectDeclarationEntry)this.entries.get(key);
                if (entry == null) {
                    entry = (ObjectDeclarationEntry)this.entries.get("static " + key);
                }
            }
        }
        return entry;
    }

    public XData invoke(String name2, Object ref, XData[] Paramters, boolean isStatic) throws XDataException, IllegalArgumentException, NoSuchMethodException {
        ObjectDeclarationEntry entry = this.getObjectDeclarationEntry(name2, Paramters.length, isStatic);
        if (entry == null) {
            throw new NoSuchMethodException();
        }
        Method surpportMethod = entry.surpportMethod;
        if (surpportMethod != null) {
            try {
                Object ret = entry.invokeId != null ? surpportMethod.invoke(ref, entry.invokeId, Paramters) : surpportMethod.invoke(ref, new Object[]{Paramters});
                if (ret instanceof XData) {
                    return (XData)ret;
                }
                return XData.convertToXData(ret);
            }
            catch (InvocationTargetException ex) {
                Throwable exx = ex.getTargetException();
                if (exx instanceof XDataException) {
                    throw (XDataException)exx;
                }
                if (exx instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)exx;
                }
                if (exx instanceof NoSuchFieldException) {
                    throw new NoSuchMethodException();
                }
                Debug.println(exx);
                throw new NoSuchMethodException();
            }
            catch (IllegalAccessException exx) {
                throw new NoSuchMethodException();
            }
        }
        return null;
    }

    public XData getValue(String name2, Object ref, XData index, boolean isStatic) throws XDataException, IllegalArgumentException, NoSuchFieldException {
        ObjectDeclarationEntry entry = this.getObjectDeclarationEntry(name2, false, index != null, isStatic);
        if (entry == null) {
            throw new NoSuchFieldException();
        }
        Method surpportMethod = entry.surpportMethod;
        if (surpportMethod != null) {
            if (surpportMethod == null) {
                throw new NoSuchFieldException();
            }
            try {
                XData[] Paramters = index == null ? new XData[]{} : new XData[]{index};
                Object ret = entry.invokeId != null ? surpportMethod.invoke(ref, entry.invokeId, Paramters) : surpportMethod.invoke(ref, new Object[]{Paramters});
                if (ret instanceof XData) {
                    return (XData)ret;
                }
                return XData.convertToXData(ret);
            }
            catch (InvocationTargetException ex) {
                Throwable exx = ex.getTargetException();
                if (exx instanceof XDataException) {
                    throw (XDataException)exx;
                }
                if (exx instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)exx;
                }
                if (exx instanceof NoSuchMethodException) {
                    throw new NoSuchFieldException();
                }
                Debug.println(exx);
                throw new NoSuchFieldException();
            }
            catch (IllegalAccessException exx) {
                throw new NoSuchFieldException();
            }
        }
        return null;
    }

    public void setValue(String name2, Object ref, XData index, XData data, boolean isStatic) throws XDataException, IllegalArgumentException, NoSuchFieldException {
        ObjectDeclarationEntry entry = this.getObjectDeclarationEntry(name2, true, index != null, isStatic);
        if (entry == null) {
            throw new NoSuchFieldException();
        }
        Method surpportMethod = entry.surpportMethod;
        if (surpportMethod != null) {
            if (surpportMethod == null) {
                throw new NoSuchFieldException();
            }
            try {
                XData[] Paramters = index == null ? new XData[]{data} : new XData[]{index, data};
                if (entry.invokeId != null) {
                    surpportMethod.invoke(ref, entry.invokeId, Paramters);
                } else {
                    surpportMethod.invoke(ref, new Object[]{Paramters});
                }
                return;
            }
            catch (InvocationTargetException ex) {
                Throwable exx = ex.getTargetException();
                if (exx instanceof XDataException) {
                    throw (XDataException)exx;
                }
                if (exx instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)exx;
                }
                if (exx instanceof NoSuchMethodException) {
                    throw new NoSuchFieldException();
                }
                Debug.println(exx);
                throw new NoSuchFieldException();
            }
            catch (IllegalAccessException exx) {
                throw new NoSuchFieldException();
            }
        }
    }

    public Class getOwnClass() {
        return this.cls;
    }

    public Enumeration getAllEntries() {
        return this.entries.elements();
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof ObjectDeclaration) {
            return this.cls == ((ObjectDeclaration)anObject).cls;
        }
        return false;
    }
}

