/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.TypeRefrance;
import com.argo21.common.lang.XData;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public final class ObjectDeclarationEntry {
    String name;
    String key;
    Method surpportMethod;
    String invokeId;
    Object extendsDescription;
    Object retType;
    String description = null;

    ObjectDeclarationEntry(String key, String name2, Method surpportMethod, String invokeId, Class retType) {
        this.key = key;
        this.name = name2;
        this.surpportMethod = surpportMethod;
        this.invokeId = invokeId;
        this.retType = retType;
        this.extendsDescription = null;
    }

    ObjectDeclarationEntry(String key, String name2, Method surpportMethod, String invokeId, TypeRefrance retType) {
        this.key = key;
        this.name = name2;
        this.surpportMethod = surpportMethod;
        this.invokeId = invokeId;
        this.retType = retType;
        this.extendsDescription = null;
    }

    public ObjectDeclarationEntry(String key, String name2, Object extendsDescription) {
        this.key = key;
        this.name = name2;
        this.surpportMethod = null;
        this.invokeId = null;
        this.extendsDescription = extendsDescription;
        this.retType = null;
    }

    public Class getValueType() {
        if (this.retType instanceof Class) {
            return (Class)this.retType;
        }
        if (this.retType != null) {
            return ((TypeRefrance)this.retType).getType(new Class[0]);
        }
        return XData.class;
    }

    public Class getValueType(Class[] params) {
        if (this.retType instanceof Class) {
            return (Class)this.retType;
        }
        if (this.retType != null) {
            return ((TypeRefrance)this.retType).getType(params);
        }
        return XData.class;
    }

    public TypeRefrance getValueTypeRefrance() {
        if (this.retType instanceof TypeRefrance) {
            return (TypeRefrance)this.retType;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMethod() {
        return this.key.indexOf("(") > 0;
    }

    public String getDescription() {
        return this.description == null ? this.name : this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public int getParameterCount() {
        int k1 = this.key.indexOf("(");
        int k2 = this.key.indexOf(")");
        if (k1 > 0 && k2 > k1) {
            try {
                return Integer.parseInt(this.key.substring(k1 + 1, k2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean isStatic() {
        return this.key.startsWith("static ");
    }

    public boolean canIndex() {
        return this.key.indexOf("[]") > 0;
    }

    public boolean isWriteable() {
        return this.key.indexOf("-w") > 0;
    }

    public boolean isProperty() {
        return this.key.indexOf("(") < 0;
    }

    public Class getOwnClass() {
        if (this.surpportMethod != null) {
            return this.surpportMethod.getClass();
        }
        if (this.extendsDescription != null) {
            if (this.extendsDescription instanceof PropertyDescriptor) {
                return ((PropertyDescriptor)this.extendsDescription).getClass();
            }
            if (this.extendsDescription instanceof MethodDescriptor) {
                return ((MethodDescriptor)this.extendsDescription).getClass();
            }
        }
        return null;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof ObjectDeclarationEntry) {
            return this.key.equals(((ObjectDeclarationEntry)anObject).key);
        }
        return false;
    }

    public String toString() {
        if (this.isMethod()) {
            int n = this.getParameterCount();
            StringBuffer sb = new StringBuffer(this.name);
            sb.append('(');
            for (int i = 0; i < n; ++i) {
                sb.append("Parameter");
                sb.append(i + 1);
                if (i >= n - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        if (this.canIndex()) {
            return this.name + "[id]";
        }
        return this.name;
    }
}

