/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectDeclarationEntry;
import com.argo21.common.lang.XBytes;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XDate;
import com.argo21.common.lang.XDateSet;
import com.argo21.common.lang.XMath;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringSet;
import com.argo21.msg.csv.CsvMsg;
import com.argo21.msg.rdb.RdbMsg;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ObjectManager {
    private static Hashtable objectRegistor = new Hashtable();
    private static boolean enabled = true;

    public static ObjectDeclaration getObjectDeclaration(Class cls) {
        return ObjectManager.getObjectDeclaration(cls, false);
    }

    public static ObjectDeclaration getObjectDeclaration(Class cls, boolean toSuper) {
        ObjectDeclaration res = (ObjectDeclaration)objectRegistor.get(cls);
        if (res == null && toSuper && (cls = cls.getSuperclass()) != null) {
            return ObjectManager.getObjectDeclaration(cls, true);
        }
        return res;
    }

    public static ObjectDeclaration createObjectDeclaration(Class cls, String scriptName) {
        return ObjectManager.createObjectDeclaration(cls, scriptName, 101);
    }

    public static ObjectDeclaration createObjectDeclaration(Class cls, String scriptName, int initialCapacity) {
        ObjectDeclaration res = (ObjectDeclaration)objectRegistor.get(cls);
        if (res == null && enabled) {
            res = new ObjectDeclaration(cls, scriptName);
            objectRegistor.put(cls, res);
        }
        return res;
    }

    public static boolean isRegisted(Class cls) {
        return objectRegistor.containsKey(cls);
    }

    public static Enumeration getRegistedClasses() {
        return objectRegistor.elements();
    }

    public static Enumeration getObjectDeclarationEntries(Class cls) {
        ObjectDeclaration od;
        Hashtable<String, ObjectDeclarationEntry> tab = new Hashtable<String, ObjectDeclarationEntry>();
        while (cls != null && (od = ObjectManager.getObjectDeclaration(cls, true)) != null) {
            Enumeration en = od.getAllEntries();
            while (en.hasMoreElements()) {
                ObjectDeclarationEntry entry = (ObjectDeclarationEntry)en.nextElement();
                if (tab.containsKey(entry.key)) continue;
                tab.put(entry.key, entry);
            }
            Class cls1 = od.getOwnClass();
            cls = cls1.getSuperclass();
        }
        return tab.elements();
    }

    public static void registBasicDataObject() {
        XData.registObject();
        XString.registObject();
        XDate.registObject();
        XNode.registObject();
        XMath.registObject();
        XBytes.registObject();
        XDataSet.registObject();
        XStringSet.registObject();
        XDateSet.registObject();
        XNodeSet.registObject();
        CsvMsg.registObject();
        RdbMsg.registObject();
    }
}

