/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;

public abstract class Operate
implements Operand {
    int optCode;
    Operand left;
    Operand right;
    public static final int NON = 0;
    public static final int ADD = 1;
    public static final int SUB = 2;
    public static final int MUL = 3;
    public static final int DIV = 4;
    public static final int MOD = 5;
    public static final int AND = 6;
    public static final int OR = 7;
    public static final int XOR = 8;
    public static final int SHL = 9;
    public static final int SHR = 10;
    public static final int SHRT = 11;
    public static final int NOT = 12;
    public static final int NEG = 13;
    public static final int EQ = 14;
    public static final int NE = 15;
    public static final int LT = 16;
    public static final int LE = 17;
    public static final int GT = 18;
    public static final int GE = 19;
    public static final int ANDAND = 20;
    public static final int OROR = 21;
    public static final int INC = 22;
    public static final int DEC = 23;
    public static final int INDEX = 24;
    public static final int IIF = 25;
    public static final int IIFF = 26;
    public static final int NEW = 27;
    public static final int IN = 28;
    public static final int TYPEOF = 29;
    public static final int EXT = 30;
    public static final String[] OPT = new String[]{"NON", "+", "-", "*", "/", "%", "&", "|", "^", "<<", ">>", ">>>", "!", "~", "==", "!=", "<", "<=", ">", ">=", "&&", "||", "++", "--", "[", "?", ":", "new", "in", "typeof", "ext"};
    public static final int[] DATATYPE = new int[]{0, 6, 6, 6, 6, 6, 12, 12, 12, 6, 6, 6, 12, 12, 15, 15, 15, 15, 15, 15, 8, 8, 4, 4, 16, 8, 8, 32, 15, 255, 15};
    public static final int[] PRIORITY = new int[]{0, 11, 11, 12, 12, 12, 7, 5, 6, 10, 10, 10, 13, 13, 8, 8, 9, 9, 9, 9, 4, 3, 13, 13, 14, 2, 2, 13, 13, 13, 13};
    public static final int MAXPRIORITY = 14;

    public static int getOPT(String key) {
        for (int i = 1; i < OPT.length; ++i) {
            if (!OPT[i].equals(key)) continue;
            return i;
        }
        return 0;
    }

    public static boolean isArithmeticOperate(int opt) {
        return opt >= 1 && opt <= 5;
    }

    public static boolean isBitOperate(int opt) {
        return opt >= 6 && opt <= 8;
    }

    public static boolean isShiftOperate(int opt) {
        return opt >= 9 && opt <= 11;
    }

    public static boolean isCompareOperate(int opt) {
        return opt >= 14 && opt <= 21;
    }

    public static boolean isReverseOperate(int opt) {
        return opt == 12 || opt == 13 || opt == 2;
    }

    public static boolean isIncOrDecOperate(int opt) {
        return opt == 22 || opt == 23;
    }

    public static boolean canAssignOperate(int opt) {
        return opt <= 11;
    }

    @Override
    public Class getDataType() {
        if (this.left != null) {
            return this.left.getDataType();
        }
        if (this.right != null) {
            return this.right.getDataType();
        }
        return XData.class;
    }

    @Override
    public void setDataType(Class datatype) {
    }

    public static final int findCode(String strOpt) {
        int n = OPT.length;
        for (int i = 0; i < n; ++i) {
            if (!strOpt.equals(OPT[i])) continue;
            return i;
        }
        return 0;
    }

    Operate(int optCode, Operand left, Operand right) {
        this.optCode = optCode;
        this.left = left;
        this.right = right;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public abstract XData getData() throws XDataException;

    @Override
    public void setData(XData data) throws XDataException {
    }

    protected boolean check() {
        return true;
    }

    @Override
    public String getReference() {
        return "Object";
    }

    @Override
    public void setReference(String reference) {
    }
}

