/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.io.Debug;
import com.argo21.common.lang.BeanUtils;
import com.argo21.common.lang.CanAccessAsBean;
import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectDeclarationEntry;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XObject;

public final class Property
implements Operand {
    Operand orient;
    String name;
    Operand index;
    boolean isStatic;
    boolean writeAble = false;
    Class datatype = null;

    public static boolean contain(Object object, String name2, boolean canindex) {
        if (object instanceof CanAccessAsBean) {
            return BeanUtils.findPropertyDescriptor(object.getClass(), name2, true) != null;
        }
        ObjectDeclaration od = ObjectManager.getObjectDeclaration(object.getClass(), true);
        if (od != null) {
            if (od.getObjectDeclarationEntry(name2, false, canindex, false) != null) {
                return true;
            }
            return od.getObjectDeclarationEntry(name2, true, canindex, false) != null;
        }
        return false;
    }

    public Property(Operand orient, String name2) {
        this(orient, name2, null, false, false);
    }

    public Property(Operand orient, String name2, Operand index) {
        this(orient, name2, index, false, false);
    }

    public Property(Operand orient, String name2, Operand index, boolean isStatic, boolean write) {
        this.orient = orient;
        this.name = name2;
        this.index = index;
        this.isStatic = isStatic;
    }

    @Override
    public int getType() {
        return 4;
    }

    public void check() throws XDataException {
        ObjectDeclarationEntry entry;
        ObjectDeclaration od;
        String sss = this.writeAble ? "CANT_READ_PROPERTY" : "CANT_WRITE_PROPERTY";
        Class<XData> type = this.orient.getDataType();
        if (type == null) {
            type = XData.class;
        }
        if ((od = ObjectManager.getObjectDeclaration(type, true)) == null) {
            XData.error(sss, this.name, true);
        }
        if ((entry = od.getObjectDeclarationEntry(this.name, this.writeAble, this.index != null, this.isStatic)) == null) {
            XData.error(sss, this.name, true);
        }
        this.datatype = entry.getValueType();
    }

    @Override
    public XData getData() throws XDataException {
        Object obj1 = this.orient.getData();
        if (obj1 == null) {
            XData.error("CANT_READ_PROPERTY", this.name, true);
        }
        if (obj1 instanceof XObject) {
            obj1 = ((XObject)obj1).objectValue();
        }
        XData obj2 = null;
        if (this.index != null && (obj2 = this.index.getData()) == null) {
            XData.error("INVAILD_PROPERTY_INDEX", this.name, true);
            return null;
        }
        if (obj1 instanceof CanAccessAsBean) {
            try {
                Object objIndex = obj2 != null ? obj2.objectValue() : null;
                Object obj = BeanUtils.getPropertyValue(obj1, this.name, objIndex);
                return XData.convertToXData(obj);
            }
            catch (NoSuchFieldException objIndex) {
            }
            catch (IllegalAccessException objIndex) {
            }
            catch (Exception e) {
                Debug.println(e);
                return null;
            }
        } else {
            ObjectDeclaration od = ObjectManager.getObjectDeclaration(obj1.getClass(), true);
            if (od != null) {
                try {
                    return od.getValue(this.name, obj1, obj2, this.isStatic);
                }
                catch (NoSuchFieldException obj) {
                }
                catch (XDataException e) {
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    XData.error("CANT_READ_PROPERTY", this.name, true);
                }
                catch (Exception e) {
                    Debug.println(e);
                    return null;
                }
            }
        }
        XData.error("INVALID_METHOD", this.name, true);
        return null;
    }

    @Override
    public void setData(XData data) throws XDataException {
        Object obj1 = this.orient.getData();
        if (obj1 == null) {
            XData.error("CANT_WRITE_PROPERTY", this.name, true);
        }
        if (obj1 instanceof XObject) {
            obj1 = ((XObject)obj1).objectValue();
        }
        XData obj2 = null;
        if (this.index != null && (obj2 = this.index.getData()) == null) {
            XData.error("INVAILD_PROPERTY_INDEX", this.name, true);
            return;
        }
        if (obj1 instanceof CanAccessAsBean) {
            try {
                Object objIndex = obj2 != null ? obj2.objectValue() : null;
                BeanUtils.setPropertyValue(obj1, this.name, objIndex, data.objectValue());
                return;
            }
            catch (NoSuchFieldException objIndex) {
            }
            catch (IllegalAccessException objIndex) {
            }
            catch (Exception e) {
                Debug.println(e);
                return;
            }
        } else {
            ObjectDeclaration od = ObjectManager.getObjectDeclaration(obj1.getClass(), true);
            if (od != null) {
                try {
                    od.setValue(this.name, obj1, obj2, data, this.isStatic);
                    return;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (XDataException e) {
                    throw e;
                }
                catch (Exception e) {
                    Debug.println(e);
                    return;
                }
            }
        }
        XData.error("INVALID_METHOD", this.name, true);
    }

    @Override
    public Class getDataType() {
        if (this.datatype == null) {
            ObjectDeclarationEntry entry;
            ObjectDeclaration od;
            Class<XData> type = this.orient.getDataType();
            if (type == null) {
                type = XData.class;
            }
            if ((od = ObjectManager.getObjectDeclaration(type, true)) != null && (entry = od.getObjectDeclarationEntry(this.name, this.writeAble, this.index != null, this.isStatic)) != null) {
                this.datatype = entry.getValueType();
            }
            if (this.datatype == null) {
                this.datatype = XData.class;
            }
        }
        return this.datatype;
    }

    @Override
    public void setDataType(Class datatype) {
    }

    @Override
    public String getReference() {
        return this.orient.getReference() + "." + this.name;
    }

    @Override
    public void setReference(String reference) {
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

