/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XFloat;
import com.argo21.common.lang.XFloatSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XObjectSet;

public final class ReverseOperate
extends Operate {
    public ReverseOperate(int optCode, Operand operand) {
        super(optCode, null, operand);
    }

    @Override
    public XData getData() throws XDataException {
        XData rightData = this.right.getData();
        if (rightData == null) {
            XData.error("FIRST_INVALID", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (rightData.getDimension() > 1) {
            XData.error("FIRST_OVER_DIM1", OPT[this.optCode]);
            return new XInteger(0);
        }
        int type = rightData.getPrimitiveType();
        switch (type) {
            case 1: {
                return this.intOperate(rightData);
            }
            case 2: {
                return this.longOperate(rightData);
            }
            case 3: {
                if (this.optCode != 2) {
                    return this.intOperate(rightData);
                }
                return this.floatOperate(rightData);
            }
            case 4: {
                if (this.optCode != 2) {
                    return this.longOperate(rightData);
                }
                return this.doubleOperate(rightData);
            }
            case 5: {
                if (this.optCode == 12) {
                    return this.booleanOperate(rightData);
                }
                XData.error("INVAILD_OP_TYPE", new Object[]{rightData.getPrimitiveTypeName(), OPT[this.optCode]});
                return new XBoolean(false);
            }
        }
        XData.error("INVAILD_OP_TYPE", new Object[]{rightData.getPrimitiveTypeName(), OPT[this.optCode]});
        return new XInteger(0);
    }

    private XData booleanOperate(XData rightData) throws XDataException {
        if (!rightData.isArray()) {
            boolean result = rightData.booleanValue();
            return new XBoolean(!result);
        }
        int len = rightData.size();
        XObjectSet datalist = new XObjectSet(5, len);
        for (int i = 0; i < len; ++i) {
            boolean result = rightData.booleanValue(i);
            datalist.append(new Boolean(!result));
        }
        return datalist;
    }

    private XData intOperate(XData rightData) throws XDataException {
        if (!rightData.isArray()) {
            int result = rightData.intValue();
            if (this.optCode == 12) {
                return new XInteger(1 - result);
            }
            if (this.optCode == 13) {
                return new XInteger(~result);
            }
            return new XInteger(-result);
        }
        int len = rightData.size();
        XIntegerSet datalist = new XIntegerSet(len);
        if (this.optCode == 12) {
            for (int i = 0; i < len; ++i) {
                int result = rightData.intValue(i);
                datalist.append(1 - result);
            }
        } else if (this.optCode == 13) {
            for (int i = 0; i < len; ++i) {
                int result = rightData.intValue(i);
                datalist.append(~result);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                int result = rightData.intValue(i);
                datalist.append(-result);
            }
        }
        return datalist;
    }

    private XData longOperate(XData rightData) throws XDataException {
        if (!rightData.isArray()) {
            long result = rightData.longValue();
            if (this.optCode == 12) {
                return new XLong(1L - result);
            }
            if (this.optCode == 13) {
                return new XLong(result ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return new XLong(-result);
        }
        int len = rightData.size();
        XLongSet datalist = new XLongSet(len);
        if (this.optCode == 12) {
            for (int i = 0; i < len; ++i) {
                long result = rightData.longValue(i);
                datalist.append(1L - result);
            }
        } else if (this.optCode == 13) {
            for (int i = 0; i < len; ++i) {
                long result = rightData.longValue(i);
                datalist.append(result ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                long result = rightData.longValue(i);
                datalist.append(-result);
            }
        }
        return datalist;
    }

    private XData floatOperate(XData rightData) throws XDataException {
        if (!rightData.isArray()) {
            float result = rightData.floatValue();
            return new XFloat(-result);
        }
        int len = rightData.size();
        XFloatSet datalist = new XFloatSet(len);
        for (int i = 0; i < len; ++i) {
            float result = rightData.floatValue();
            datalist.append(-result);
        }
        return datalist;
    }

    private XData doubleOperate(XData rightData) throws XDataException {
        if (!rightData.isArray()) {
            double result = rightData.doubleValue();
            return new XDouble(-result);
        }
        int len = rightData.size();
        XDoubleSet datalist = new XDoubleSet(len);
        for (int i = 0; i < len; ++i) {
            double result = rightData.doubleValue();
            datalist.append(-result);
        }
        return datalist;
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

