/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.Operand;
import com.argo21.common.lang.Operate;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;

public final class ShiftOperate
extends Operate {
    public ShiftOperate(int optCode, Operand left, Operand right) {
        super(optCode, left, right);
    }

    @Override
    public XData getData() throws XDataException {
        XData leftData = this.left.getData();
        XData rightData = this.right.getData();
        if (leftData == null) {
            XData.error("FIRST_INVALID", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (rightData == null) {
            XData.error("SECOND_INVALID", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (leftData.getDimension() > 1) {
            XData.error("FIRST_OVER_DIM1", OPT[this.optCode]);
            return new XInteger(0);
        }
        if (rightData.getDimension() > 1) {
            XData.error("SECOND_OVER_DIM1", OPT[this.optCode]);
            return new XInteger(0);
        }
        int type = leftData.getPrimitiveType();
        int num = rightData.intValue();
        if (type == 1) {
            return this.intOperate(leftData, num);
        }
        return this.longOperate(leftData, num);
    }

    XData intOperate(XData left, int num) throws XDataException {
        if (!left.isArray()) {
            int result;
            switch (this.optCode) {
                case 9: {
                    result = left.intValue() << num;
                    break;
                }
                case 10: {
                    result = left.intValue() >> num;
                    break;
                }
                case 11: {
                    result = left.intValue() >>> num;
                    break;
                }
                default: {
                    result = 0;
                }
            }
            return new XInteger(result);
        }
        int len = left.size();
        int[] result = new int[len];
        switch (this.optCode) {
            case 9: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) << num;
                }
                break;
            }
            case 10: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) >> num;
                }
                break;
            }
            case 11: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.intValue(i) >>> num;
                }
                break;
            }
        }
        return new XIntegerSet(result);
    }

    XData longOperate(XData left, int num) throws XDataException {
        if (!left.isArray()) {
            long result;
            switch (this.optCode) {
                case 9: {
                    result = left.longValue() << num;
                    break;
                }
                case 10: {
                    result = left.longValue() >> num;
                    break;
                }
                case 11: {
                    result = left.longValue() >>> num;
                    break;
                }
                default: {
                    result = 0L;
                }
            }
            return new XLong(result);
        }
        int len = left.size();
        long[] result = new long[len];
        switch (this.optCode) {
            case 9: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) << num;
                }
                break;
            }
            case 10: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) >> num;
                }
                break;
            }
            case 11: {
                for (int i = 0; i < len; ++i) {
                    result[i] = left.longValue(i) >>> num;
                }
                break;
            }
        }
        return new XLongSet(result);
    }

    @Override
    public String getEncoding() {
        return null;
    }
}

