/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XBooleanSet;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XNode;
import java.util.Date;
import org.w3c.dom.Node;

public final class XBoolean
extends XData {
    boolean m_val;

    public XBoolean(boolean b) {
        this.m_val = b;
    }

    public XBoolean(Boolean b) {
        this((boolean)b);
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public String getTypeName() {
        return "boolean";
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.m_val;
    }

    @Override
    public int intValue() throws XDataException {
        return this.m_val ? 1 : 0;
    }

    @Override
    public long longValue() throws XDataException {
        return this.m_val ? 1L : 0L;
    }

    @Override
    public float floatValue() throws XDataException {
        return this.m_val ? 1.0f : 0.0f;
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.m_val ? 1.0 : 0.0;
    }

    @Override
    public String stringValue() {
        return this.m_val ? "true" : "false";
    }

    @Override
    public Date dateValue() throws XDataException {
        XBoolean.error("CANT_TO_DATE", new Object[]{this.getTypeName()});
        return null;
    }

    @Override
    public Node nodeValue() throws XDataException {
        XBoolean.error("CANT_TO_NODE", new Object[]{this.getTypeName()});
        return null;
    }

    @Override
    public Object objectValue() {
        return new Boolean(this.m_val);
    }

    @Override
    public void setValue(int value) throws XDataException {
        this.m_val = value != 0;
    }

    @Override
    public void setValue(long value) throws XDataException {
        this.m_val = value != 0L;
    }

    @Override
    public void setValue(float value) throws XDataException {
        this.m_val = value != 0.0f;
    }

    @Override
    public void setValue(double value) throws XDataException {
        this.m_val = value != 0.0;
    }

    @Override
    public void setValue(String value) throws XDataException {
        this.m_val = Boolean.valueOf(value);
    }

    @Override
    public void setValue(boolean value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(Date value) throws XDataException {
        this.m_val = false;
    }

    @Override
    public void setValue(Node value) throws XDataException {
        this.setValue(XNode.getStringFromNode(value));
    }

    @Override
    public void setValue(Object value) throws XDataException {
        this.setValue(value.toString());
    }

    @Override
    public void setValue(XData value) throws XDataException {
        this.m_val = value.booleanValue();
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (obj2.getPrimitiveType() == 18) {
            return obj2.equals(this);
        }
        return this.m_val == obj2.booleanValue();
    }

    @Override
    public XDataSet extendDataSet(int length) {
        boolean[] result = new boolean[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.m_val;
        }
        return new XBooleanSet(result);
    }

    @Override
    public String toString() {
        return String.valueOf(this.m_val);
    }
}

