/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XNode;
import org.w3c.dom.Node;

public final class XBooleanSet
extends XDataSet {
    boolean[] m_val = null;

    public XBooleanSet(int capacity) {
        this.m_val = new boolean[capacity];
        this.count = 0;
    }

    public XBooleanSet(boolean[] val) {
        this.m_val = val;
        this.count = val.length;
    }

    @Override
    public int getType() {
        return 261;
    }

    @Override
    public String getTypeName() {
        return "boolean[]";
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.booleanValue(0);
    }

    @Override
    public boolean booleanValue(int index) throws XDataException {
        return this.count <= index ? false : this.m_val[index];
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.doubleValue(0);
    }

    @Override
    public double doubleValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0.0;
        }
        return this.m_val[index] ? 1.0 : 0.0;
    }

    @Override
    public float floatValue() throws XDataException {
        return this.floatValue(0);
    }

    @Override
    public float floatValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0.0f;
        }
        return this.m_val[index] ? 1.0f : 0.0f;
    }

    @Override
    public int intValue() throws XDataException {
        return this.intValue(0);
    }

    @Override
    public int intValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0;
        }
        return this.m_val[index] ? 1 : 0;
    }

    @Override
    public long longValue() throws XDataException {
        return this.longValue(0);
    }

    @Override
    public long longValue(int index) throws XDataException {
        if (this.count <= index) {
            return 0L;
        }
        return this.m_val[index] ? 1L : 0L;
    }

    @Override
    public Object objectValue() {
        return this.objectValue(0);
    }

    @Override
    public Object objectValue(int index) {
        return this.count <= index ? new Boolean(false) : new Boolean(this.m_val[index]);
    }

    @Override
    public String stringValue() {
        return this.stringValue(0);
    }

    @Override
    public String stringValue(int index) {
        return this.count <= index ? "" : String.valueOf(this.m_val[index]);
    }

    @Override
    public Object[] objectValues() throws XDataException {
        Object[] result = new Object[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = new Boolean(this.m_val[i]);
        }
        return result;
    }

    @Override
    public int[] intValues() throws XDataException {
        int[] result = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i] ? 1 : 0;
        }
        return result;
    }

    @Override
    public long[] longValues() throws XDataException {
        long[] result = new long[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i] ? 1 : 0;
        }
        return result;
    }

    @Override
    public float[] floatValues() throws XDataException {
        float[] result = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i] ? 1.0f : 0.0f;
        }
        return result;
    }

    @Override
    public double[] doubleValues() throws XDataException {
        double[] result = new double[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i] ? 1.0 : 0.0;
        }
        return result;
    }

    @Override
    public String[] stringValues() throws XDataException {
        String[] result = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = String.valueOf(this.m_val[i]);
        }
        return result;
    }

    @Override
    public boolean[] booleanValues() throws XDataException {
        if (this.m_val.length != this.count) {
            boolean[] result = new boolean[this.count];
            System.arraycopy(this.m_val, 0, result, 0, this.count);
            this.m_val = result;
        }
        return this.m_val;
    }

    public boolean containArray() {
        return false;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public void reverse() throws XDataException {
        int start = 0;
        for (int end = this.count - 1; start < end; ++start, --end) {
            boolean tmp = this.m_val[start];
            this.m_val[start] = this.m_val[end];
            this.m_val[end] = tmp;
        }
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (this.count <= 0) {
            return false;
        }
        if (obj2.isNode()) {
            return obj2.equals(this);
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.m_val[i] == obj2.booleanValue(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public XDataSet extendDataSet(int length) {
        boolean[] result = new boolean[length];
        if (this.count > 0) {
            int size;
            for (int k = 0; k < length; k += size) {
                size = length - k < this.count ? length - k : this.count;
                System.arraycopy(this.m_val, 0, result, k, size);
            }
        }
        return new XBooleanSet(result);
    }

    public void append(boolean value) {
        if (this.count >= this.m_val.length) {
            this.expendsCapacity(this.count + 1);
        }
        this.m_val[this.count++] = value;
    }

    @Override
    public void setValue(int index, boolean val) {
        if (index >= this.count) {
            this.expendsCapacity(index + 1);
            this.count = index + 1;
        }
        this.m_val[index] = val;
    }

    @Override
    public void setValue(int index, float value) throws XDataException {
        this.setValue(index, value != 0.0f);
    }

    @Override
    public void setValue(int index, int value) throws XDataException {
        this.setValue(index, value != 0);
    }

    @Override
    public void setValue(int index, long value) throws XDataException {
        this.setValue(index, (double)value != 0.0);
    }

    @Override
    public void setValue(int index, String value) throws XDataException {
        this.setValue(index, Boolean.valueOf(value));
    }

    @Override
    public void setValue(int index, Node value) throws XDataException {
        XNode xn = new XNode(value);
        this.setValue(index, xn.booleanValue());
    }

    @Override
    public void setValue(int index, XData value) throws XDataException {
        this.setValue(index, value.booleanValue());
    }

    @Override
    public synchronized void expendsCapacity(int minCapacity) {
        int oldCapacity = this.m_val.length;
        if (minCapacity > oldCapacity) {
            boolean[] oldData = this.m_val;
            int newCapacity = XBooleanSet.expectCapacity(oldCapacity, minCapacity);
            this.m_val = new boolean[newCapacity];
            System.arraycopy(oldData, 0, this.m_val, 0, this.count);
        }
    }
}

