/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XString;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Date;

public class XBytes
extends XData
implements Serializable,
Comparable {
    private byte[] value;
    private int offset;
    private int count;
    public static final int METHOD_BYTEAT = 257;
    public static final int METHOD_COMPARETO = 258;
    public static final int METHOD_CONCAT = 259;
    public static final int METHOD_EQUALS = 260;
    public static final int METHOD_INDEXOF1 = 261;
    public static final int METHOD_INDEXOF2 = 262;
    public static final int METHOD_LASTINDEXOF1 = 263;
    public static final int METHOD_LASTINDEXOF2 = 264;
    public static final int METHOD_LENGTH = 265;
    public static final int METHOD_REPLACE = 266;
    public static final int METHOD_SUBBYTES1 = 267;
    public static final int METHOD_SUBBYTES2 = 268;
    public static final int METHOD_TRIM = 269;
    public static final int METHOD_TOSTRING = 270;
    public static final int METHOD_TOSTRING1 = 271;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void registObject() {
        Class<XBytes> cls = XBytes.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Date");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("byteAt", md, String.valueOf(257), XString.class, 1);
        od.addMethodDeclaration("compareTo", md, String.valueOf(258), XBoolean.class, 1);
        od.addMethodDeclaration("concat", md, String.valueOf(259), cls, 1);
        od.addMethodDeclaration("equals", md, String.valueOf(260), XBoolean.class, 1);
        od.addMethodDeclaration("indexOf", md, String.valueOf(261), XInteger.class, 1);
        od.addMethodDeclaration("indexOf", md, String.valueOf(262), XInteger.class, 2);
        od.addMethodDeclaration("lastIndexOf", md, String.valueOf(263), XInteger.class, 1);
        od.addMethodDeclaration("lastIndexOf", md, String.valueOf(264), XInteger.class, 2);
        od.addMethodDeclaration("length", md, String.valueOf(265), XInteger.class);
        od.addMethodDeclaration("replace", md, String.valueOf(266), cls, 2);
        od.addMethodDeclaration("subBytes", md, String.valueOf(267), cls, 1);
        od.addMethodDeclaration("subBytes", md, String.valueOf(268), cls, 2);
        od.addMethodDeclaration("trim", md, String.valueOf(269), cls);
        od.addMethodDeclaration("toString", md, String.valueOf(270), XString.class);
        od.addMethodDeclaration("toString", md, String.valueOf(271), XString.class, 1);
    }

    @Override
    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (idd) {
            case 257: {
                int tmpInt = parameters[0].intValue();
                if (tmpInt >= this.length()) {
                    return new XInteger(0);
                }
                return new XInteger(this.byteAt(tmpInt));
            }
            case 258: {
                XBytes tmp = parameters[0].getType() == 19 ? (XBytes)parameters[0] : new XBytes(parameters[0].stringValue().getBytes());
                int tmpInt = this.compareTo(tmp);
                return new XInteger(tmpInt);
            }
            case 259: {
                XBytes tmp = parameters[0].getType() == 19 ? (XBytes)parameters[0] : new XBytes(parameters[0].stringValue().getBytes());
                return this.concat(tmp);
            }
            case 260: {
                XBytes tmp = parameters[0].getType() == 19 ? (XBytes)parameters[0] : new XBytes(parameters[0].stringValue().getBytes());
                return new XBoolean(this.equals((Object)tmp));
            }
            case 261: {
                int tmpInt = this.indexOf((byte)parameters[0].intValue());
                return new XInteger(tmpInt);
            }
            case 262: {
                int tmpInt = parameters[1].intValue();
                tmpInt = this.indexOf((byte)parameters[0].intValue(), tmpInt);
                return new XInteger(tmpInt);
            }
            case 263: {
                int tmpInt = this.lastIndexOf((byte)parameters[0].intValue());
                return new XInteger(tmpInt);
            }
            case 264: {
                int tmpInt = parameters[1].intValue();
                tmpInt = this.lastIndexOf((byte)parameters[0].intValue(), tmpInt);
                return new XInteger(tmpInt);
            }
            case 265: {
                return new XInteger(this.count);
            }
            case 266: {
                return this.replace((byte)parameters[0].intValue(), (byte)parameters[1].intValue());
            }
            case 267: {
                return this.subBytes(parameters[0].intValue());
            }
            case 268: {
                return this.subBytes(parameters[0].intValue(), parameters[1].intValue());
            }
            case 269: {
                return this.trim();
            }
            case 270: {
                return new XString(this.toString());
            }
            case 271: {
                try {
                    return new XString(this.toString(parameters[0].stringValue()));
                }
                catch (UnsupportedEncodingException e) {
                    XBytes.error("INVAILD_ENCODING", new Object[]{parameters[0].stringValue()});
                    return new XString(this.toString());
                }
            }
        }
        return super.invoke(id2, parameters);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null || this.count == 0;
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public String getTypeName() {
        return this.getPrimitiveTypeName();
    }

    @Override
    public int intValue() throws XDataException {
        int v = 0;
        for (int i = 0; i < this.count && i < 4; ++i) {
            v = (v << 8) + (this.value[i] & 0xFF);
        }
        return v;
    }

    @Override
    public long longValue() throws XDataException {
        long v = 0L;
        for (int i = 0; i < this.count && i < 8; ++i) {
            v = (v << 8) + (long)(this.value[i] & 0xFF);
        }
        return v;
    }

    @Override
    public float floatValue() throws XDataException {
        return this.longValue();
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.longValue();
    }

    @Override
    public String stringValue() {
        return XBytes.toHex(this.value, this.offset, this.count);
    }

    @Override
    public Date dateValue() throws XDataException {
        return new Date(this.longValue());
    }

    @Override
    public Object objectValue() {
        byte[] res = new byte[this.count];
        System.arraycopy(this.value, this.offset, res, 0, this.count);
        return res;
    }

    @Override
    public void setValue(int n) throws XDataException {
        XBytes val = new XBytes(n);
        this.value = val.value;
        this.count = val.count;
    }

    @Override
    public void setValue(long n) throws XDataException {
        XBytes val = new XBytes(n);
        this.value = val.value;
        this.count = val.count;
    }

    @Override
    public void setValue(float value) throws XDataException {
        this.setValue((long)value);
    }

    @Override
    public void setValue(double value) throws XDataException {
        this.setValue((long)value);
    }

    @Override
    public void setValue(String value) throws XDataException {
    }

    @Override
    public void setValue(Date value) throws XDataException {
        this.setValue(value.getTime());
    }

    @Override
    public void setValue(Object value) throws XDataException {
        if (value instanceof byte[]) {
            this.value = (byte[])value;
            this.count = this.value.length;
        } else {
            XBytes.error("CANT_FROM_OBJECT", new Object[]{this.getTypeName()});
        }
    }

    @Override
    public XDataSet extendDataSet(int length) throws XDataException {
        XBytes.error("CANT_FROM_OBJECT", new Object[]{this.getTypeName()});
        return null;
    }

    public XBytes() {
        this.value = new byte[0];
    }

    public XBytes(XBytes val) {
        this.value = val.value;
        this.offset = val.offset;
        this.count = val.count;
    }

    public XBytes(byte[] value) {
        this.count = value.length;
        this.value = new byte[this.count];
        System.arraycopy(value, 0, this.value, 0, this.count);
    }

    public XBytes(byte[] value, int offset, int count2) {
        if (offset < 0) {
            this.failIndex(offset);
        }
        if (count2 < 0) {
            this.failIndex(count2);
        }
        if (offset > value.length - count2) {
            this.failIndex(offset + count2);
        }
        this.value = new byte[count2];
        this.count = count2;
        System.arraycopy(value, offset, this.value, 0, count2);
    }

    public XBytes(int offset, int count2, byte[] value) {
        this.value = value;
        this.offset = offset;
        this.count = count2;
    }

    public XBytes(String str) {
        this(str.getBytes());
    }

    public XBytes(String str, String enc) throws UnsupportedEncodingException {
        this(enc == null ? str.getBytes() : str.getBytes(enc));
    }

    public XBytes(int n) {
        this.value = new byte[4];
        this.count = 4;
        this.value[3] = (byte)n;
        this.value[2] = (byte)(n >>>= 8);
        this.value[1] = (byte)(n >>>= 8);
        this.value[0] = (byte)(n >>>= 8);
    }

    public XBytes(long n) {
        this.value = new byte[8];
        this.count = 8;
        this.value[7] = (byte)n;
        this.value[6] = (byte)(n >>>= 8);
        this.value[5] = (byte)(n >>>= 8);
        this.value[4] = (byte)(n >>>= 8);
        this.value[3] = (byte)(n >>>= 8);
        this.value[2] = (byte)(n >>>= 8);
        this.value[1] = (byte)(n >>>= 8);
        this.value[0] = (byte)(n >>>= 8);
    }

    public int length() {
        return this.count;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.count) {
            this.failIndex(index);
        }
        return this.value[index + this.offset];
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            this.failIndex(srcBegin);
        }
        if (srcEnd > this.count) {
            this.failIndex(srcEnd);
        }
        if (srcBegin > srcEnd) {
            this.failIndex(srcEnd - srcBegin);
        }
        System.arraycopy(this.value, this.offset + srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public XBytes replace(byte src, byte dst) {
        for (int i = 0; i < this.count; ++i) {
            if (this.value[i + this.offset] != src) continue;
            this.value[i + this.offset] = dst;
        }
        return this;
    }

    public XBytes subBytes(int index) {
        if (index < 0 || index >= this.count) {
            this.failIndex(index);
        }
        int len = this.count - index;
        return new XBytes(this.value, index + this.offset, len);
    }

    public XBytes subBytes(int index, int last2) {
        if (index < 0 || index >= this.count) {
            this.failIndex(index);
        }
        if (last2 < index) {
            this.failIndex(index);
        }
        int len = last2 - index;
        return new XBytes(this.value, index + this.offset, len);
    }

    public String getString(String enc) throws UnsupportedEncodingException {
        return new String(this.value, this.offset, this.count, enc);
    }

    public String getString() {
        return new String(this.value, this.offset, this.count);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof XBytes) {
            XBytes another = (XBytes)anObject;
            int n = this.count;
            if (n == another.count) {
                byte[] v2 = another.value;
                int i = this.offset;
                int j = another.offset;
                while (n-- != 0) {
                    if (this.value[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equalsIgnoreCase(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof XBytes) {
            XBytes another = (XBytes)anObject;
            int n = this.count;
            if (n == another.count) {
                byte[] v2 = another.value;
                int i = this.offset;
                int j = another.offset;
                while (n-- != 0) {
                    char c2;
                    char c1;
                    if ((c1 = (char)this.value[i++]) == (c2 = (char)v2[j++]) || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int compareTo(XBytes another) {
        int len1 = this.count;
        int len2 = another.count;
        int n = Math.min(len1, len2);
        byte[] v1 = this.value;
        byte[] v2 = another.value;
        int i = this.offset;
        int j = another.offset;
        while (n-- != 0) {
            byte c2;
            byte c1;
            if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
            return (c1 & 0xFF) - (c2 & 0xFF);
        }
        return len1 - len2;
    }

    public int compareTo(Object o) {
        return this.compareTo((XBytes)o);
    }

    public int hashCode() {
        int h = 0;
        int off = this.offset;
        byte[] val = this.value;
        int len = this.count;
        for (int i = 0; i < len; ++i) {
            h = 31 * h + val[off++];
        }
        return h;
    }

    public int indexOf(byte b) {
        return this.indexOf(b, 0);
    }

    public int indexOf(byte b, int fromIndex) {
        int max = this.offset + this.count;
        byte[] v = this.value;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.count) {
            return -1;
        }
        for (int i = this.offset + fromIndex; i < max; ++i) {
            if (v[i] != b) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(int b) {
        return this.lastIndexOf(b, this.count - 1);
    }

    public int lastIndexOf(int b, int fromIndex) {
        int min = this.offset;
        byte[] v = this.value;
        for (int i = this.offset + (fromIndex >= this.count ? this.count - 1 : fromIndex); i >= min; --i) {
            if (v[i] != b) continue;
            return i - this.offset;
        }
        return -1;
    }

    public XBytes concat(XBytes bts) {
        int otherLen = bts.length();
        if (otherLen == 0) {
            return this;
        }
        byte[] buf = new byte[this.count + otherLen];
        this.getBytes(0, this.count, buf, 0);
        bts.getBytes(0, otherLen, buf, this.count);
        return new XBytes(0, this.count + otherLen, buf);
    }

    public XBytes trim() {
        int st;
        int len = this.count;
        int off = this.offset;
        byte[] val = this.value;
        for (st = 0; st < len && (val[off + st] & 0xFF) <= 32; ++st) {
        }
        while (st < len && (val[off + len - 1] & 0xFF) <= 32) {
            --len;
        }
        if (st > 0 || len < this.count) {
            return new XBytes(this.value, off + st, len - st);
        }
        return this;
    }

    @Override
    public String toString() {
        return new String(this.value, this.offset, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.value, this.offset, this.count, enc);
    }

    public String toHex() {
        return XBytes.toHex(this.value, this.offset, this.count);
    }

    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean newInst) {
        if (!newInst && this.offset == 0 && this.count == this.value.length) {
            return this.value;
        }
        byte[] result = new byte[this.count];
        this.getBytes(0, this.count, result, 0);
        return result;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.value, this.offset, this.count);
    }

    private void failIndex(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Bytes index out of range: " + index);
    }

    public static int toInt(byte[] b) {
        return (b[3] & 0xFF) + ((b[2] & 0xFF) << 8) + ((b[1] & 0xFF) << 16) + ((b[0] & 0xFF) << 24);
    }

    public static long toLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(int n) {
        return XBytes.toBytes(n, new byte[4]);
    }

    public static byte[] toBytes(int n, byte[] b) {
        b[3] = (byte)n;
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static byte[] toBytes(long n) {
        return XBytes.toBytes(n, new byte[8]);
    }

    public static byte[] toBytes(long n, byte[] b) {
        b[7] = (byte)n;
        b[6] = (byte)(n >>>= 8);
        b[5] = (byte)(n >>>= 8);
        b[4] = (byte)(n >>>= 8);
        b[3] = (byte)(n >>>= 8);
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] append(byte[] a, byte[] b) {
        byte[] z = new byte[a.length + b.length];
        System.arraycopy(a, 0, z, 0, a.length);
        System.arraycopy(b, 0, z, a.length, b.length);
        return z;
    }

    public static byte[] append(byte[] a, byte[] b, byte[] c) {
        byte[] z = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, z, 0, a.length);
        System.arraycopy(b, 0, z, a.length, b.length);
        System.arraycopy(c, 0, z, a.length + b.length, c.length);
        return z;
    }

    public static byte[] copy(byte[] b, int pos) {
        return XBytes.copy(b, pos, b.length - pos);
    }

    public static byte[] copy(byte[] b, int pos, int length) {
        byte[] z = new byte[length];
        System.arraycopy(b, pos, z, 0, length);
        return z;
    }

    public static void merge(byte[] src, byte[] dest, int srcpos, int destpos, int length) {
        System.arraycopy(src, srcpos, dest, destpos, length);
    }

    public static void merge(byte[] src, byte[] dest, int pos) {
        System.arraycopy(src, 0, dest, pos, src.length);
    }

    public static void merge(byte[] src, byte[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    public static void merge(byte[] src, byte[] dest, int pos, int length) {
        System.arraycopy(src, 0, dest, pos, length);
    }

    public static String toHex(byte[] b, int offset, int length) {
        char[] buf = new char[length * 2];
        int j = 0;
        for (int i = offset; i < offset + length; ++i) {
            byte k = b[i];
            buf[j++] = hexDigits[k >>> 4 & 0xF];
            buf[j++] = hexDigits[k & 0xF];
        }
        return new String(buf);
    }

    public static String toHex(byte[] b) {
        return XBytes.toHex(b, 0, b.length);
    }
}

