/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.MessageCatalog;
import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XBooleanSet;
import com.argo21.common.lang.XBytes;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XDataViewer;
import com.argo21.common.lang.XDate;
import com.argo21.common.lang.XDateSet;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XFloat;
import com.argo21.common.lang.XFloatSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XNull;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XObjectSet;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringSet;
import com.argo21.common.lang.XVoid;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XData
implements Serializable,
XDataViewer {
    public static final int XDATA_UNKNOWN = 255;
    public static final int XDATA_NULL = 0;
    public static final int XDATA_INT = 1;
    public static final int XDATA_LONG = 2;
    public static final int XDATA_FLOAT = 3;
    public static final int XDATA_DOUBLE = 4;
    public static final int XDATA_BOOLEAN = 5;
    public static final int XDATA_STRING = 6;
    public static final int XDATA_DATE = 7;
    public static final int XDATA_VOID = 16;
    public static final int XDATA_OBJECT = 17;
    public static final int XDATA_NODE = 18;
    public static final int XDATA_BYTES = 19;
    public static final int XDATA_INT_SET = 257;
    public static final int XDATA_LONG_SET = 258;
    public static final int XDATA_FLOAT_SET = 259;
    public static final int XDATA_DOUBLE_SET = 260;
    public static final int XDATA_BOOLEAN_SET = 261;
    public static final int XDATA_STRING_SET = 262;
    public static final int XDATA_DATE_SET = 263;
    public static final int XDATA_OBJECT_SET = 273;
    public static final int XDATA_NODE_SET = 274;
    private static final String[] TYPENAME;
    private static final String[] ARRAYTYPENAME;
    private static final Class[] TYPECLASS;
    private static final Class[] ARRAYTYPECLASS;
    public static final int METHOD_TYPENAME = 1;
    public static final int METHOD_DATATYPENAME = 2;
    public static final int METHOD_ISARRAY = 3;
    public static final int PROPERTY_LENGTH = 4;
    public static final int METHOD_TYPETO = 5;
    public static final int METHOD_EQUALS = 6;
    public static final int METHOD_TOSTRING = 7;
    public static final int METHOD_CLONE = 8;
    public static final int METHOD_SUM = 9;
    public static final int METHOD_AVERAGE = 10;
    public static final int METHOD_SORT = 11;
    public static final int METHOD_SORT1 = 12;
    public static final int METHOD_ISEMPTY = 13;
    public static final int METHOD_JOIN = 14;
    public static final int METHOD_JOIN1 = 15;
    public static final int METHOD_REVERSE = 16;
    public static final XNull XNULL;
    public static final XVoid XVOID;
    public static MessageCatalog msgCatalog;

    public static boolean isNumber(int type) {
        return type == 1 || type == 2 || type == 3 || type == 4;
    }

    public static boolean isBoolean(int type) {
        return type == 5;
    }

    public static void registObject() {
        Class<XData> cls = XData.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Data");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("typeName", md, String.valueOf(1), XString.class);
        od.addMethodDeclaration("dataTypeName", md, String.valueOf(2), XString.class);
        od.addMethodDeclaration("isArray", md, String.valueOf(3), XBoolean.class);
        od.addPropertyDeclaration("length", md, String.valueOf(4), XInteger.class, false);
        od.addMethodDeclaration("typeTo", md, String.valueOf(5), XData.class, 1);
        od.addMethodDeclaration("equals", md, String.valueOf(6), XBoolean.class, 1);
        od.addMethodDeclaration("toString", md, String.valueOf(7), XString.class);
        od.addMethodDeclaration("clone", md, String.valueOf(8), XData.class);
        od.addMethodDeclaration("sum", md, String.valueOf(9), XDouble.class);
        od.addMethodDeclaration("average", md, String.valueOf(10), XDouble.class);
        od.addMethodDeclaration("sort", md, String.valueOf(11), XData.class);
        od.addMethodDeclaration("sort", md, String.valueOf(12), XData.class, 1);
        od.addMethodDeclaration("isEmpty", md, String.valueOf(13), XBoolean.class);
        od.addMethodDeclaration("join", md, String.valueOf(14), XString.class);
        od.addMethodDeclaration("join", md, String.valueOf(15), XString.class, 1);
        od.addMethodDeclaration("reverse", md, String.valueOf(16), XVoid.class);
    }

    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (idd) {
            case 1: {
                return new XString(this.getTypeName());
            }
            case 2: {
                return new XString(this.getPrimitiveTypeName());
            }
            case 3: {
                return new XBoolean(this.isArray());
            }
            case 5: {
                String s = parameters[0].stringValue();
                int typeid = 0;
                for (int i = 1; i < TYPENAME.length; ++i) {
                    if (!TYPENAME[i].equals(s)) continue;
                    typeid = i;
                    break;
                }
                return this.castToType(typeid);
            }
            case 6: {
                return new XBoolean(this.equals(parameters[0]));
            }
            case 7: {
                return new XString(this.stringValue());
            }
            case 8: {
                return this.cloneData();
            }
            case 9: {
                return this;
            }
            case 10: {
                return this;
            }
            case 11: 
            case 12: {
                return this;
            }
            case 4: {
                return new XInteger(this.size());
            }
            case 13: {
                return new XBoolean(this.isEmpty());
            }
            case 14: 
            case 15: {
                return new XString(this.stringValue());
            }
            case 16: {
                return XVOID;
            }
        }
        throw new NoSuchMethodException();
    }

    public boolean isEmpty() {
        return false;
    }

    public static String getTypeName(int type) {
        return type >= 256 ? ARRAYTYPENAME[type - 256] : TYPENAME[type];
    }

    public static int getType(String typeName) {
        String[] types = typeName.endsWith("[]") ? ARRAYTYPENAME : TYPENAME;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(typeName)) continue;
            return types == ARRAYTYPENAME ? i + 256 : i;
        }
        return 0;
    }

    public static Class getTypeClass(int type) {
        return type >= 256 ? ARRAYTYPECLASS[type - 256] : TYPECLASS[type];
    }

    public static Class getTypeClass(XData data) {
        if (data.isObject()) {
            Object obj = data.objectValue();
            return obj.getClass();
        }
        return data.getClass();
    }

    public abstract int getType();

    public abstract String getTypeName();

    public int getPrimitiveType() {
        return this.getType() & 0xFF;
    }

    public String getPrimitiveTypeName() {
        int type = this.getPrimitiveType();
        return TYPENAME[type];
    }

    public boolean isBoolean() {
        int type = this.getType() & 0xFF;
        return type == 5;
    }

    public boolean isInteger() {
        int type = this.getPrimitiveType() & 0xFF;
        return type == 1 || type == 2;
    }

    public boolean isFloat() {
        int type = this.getPrimitiveType() & 0xFF;
        return type == 3 || type == 4;
    }

    public boolean isNumber() {
        int type = this.getPrimitiveType() & 0xFF;
        return type >= 1 && type <= 4;
    }

    public boolean isNull() {
        return this.getType() == 0;
    }

    public boolean isVoid() {
        return this.getType() == 16;
    }

    public boolean isString() {
        int type = this.getPrimitiveType() & 0xFF;
        return type == 6;
    }

    public boolean isNode() {
        int type = this.getType() & 0xFF;
        return type == 18;
    }

    public boolean isDate() {
        int type = this.getType() & 0xFF;
        return type == 7;
    }

    public boolean isObject() {
        int type = this.getType() & 0xFF;
        return type == 17;
    }

    public boolean isArray() {
        int type = this.getType() & 0x100;
        return type > 0;
    }

    public int size() {
        return 1;
    }

    public boolean booleanValue() throws XDataException {
        XData.error("CANT_TO_BOOLEAN", new Object[]{this.getTypeName()});
        return false;
    }

    public boolean booleanValue(int index) throws XDataException {
        return this.booleanValue();
    }

    public int intValue() throws XDataException {
        XData.error("CANT_TO_INT", new Object[]{this.getTypeName()});
        return 0;
    }

    public int intValue(int index) throws XDataException {
        return this.intValue();
    }

    public long longValue() throws XDataException {
        XData.error("CANT_TO_LONG", new Object[]{this.getTypeName()});
        return 0L;
    }

    public long longValue(int index) throws XDataException {
        return this.longValue();
    }

    public float floatValue() throws XDataException {
        XData.error("CANT_TO_FLOAT", new Object[]{this.getTypeName()});
        return 0.0f;
    }

    public float floatValue(int index) throws XDataException {
        return this.floatValue();
    }

    public double doubleValue() throws XDataException {
        XData.error("CANT_TO_DOUBLE", new Object[]{this.getTypeName()});
        return 0.0;
    }

    public double doubleValue(int index) throws XDataException {
        return this.doubleValue();
    }

    public String stringValue() {
        return super.toString();
    }

    public String stringValue(int index) {
        return this.stringValue();
    }

    public Date dateValue() throws XDataException {
        XData.error("CANT_TO_DATE", new Object[]{this.getTypeName()});
        return null;
    }

    public Date dateValue(int index) throws XDataException {
        return this.dateValue();
    }

    public Node nodeValue() throws XDataException {
        XData.error("CANT_TO_NODE", new Object[]{this.getTypeName()});
        return null;
    }

    public Node nodeValue(int index) throws XDataException {
        return this.nodeValue();
    }

    public Object objectValue() {
        return this;
    }

    public Object objectValue(int index) throws XDataException {
        return this.objectValue();
    }

    public void setValue(int value) throws XDataException {
        XData.error("CANT_FROM_INT", new Object[]{this.getTypeName()});
    }

    public void setValue(long value) throws XDataException {
        XData.error("CANT_FROM_LONG", new Object[]{this.getTypeName()});
    }

    public void setValue(float value) throws XDataException {
        XData.error("CANT_FROM_FLOAT", new Object[]{this.getTypeName()});
    }

    public void setValue(double value) throws XDataException {
        XData.error("CANT_FROM_DOUBLE", new Object[]{this.getTypeName()});
    }

    public void setValue(String value) throws XDataException {
    }

    public void setValue(boolean value) throws XDataException {
        XData.error("CANT_FROM_BOOLEAN", new Object[]{this.getTypeName()});
    }

    public void setValue(Date value) throws XDataException {
        XData.error("CANT_FROM_DATE", new Object[]{this.getTypeName()});
    }

    public void setValue(Node value) throws XDataException {
        XData.error("CANT_FROM_NODE", new Object[]{this.getTypeName()});
    }

    public void setValue(Object value) throws XDataException {
        XData.error("CANT_FROM_OBJECT", new Object[]{this.getTypeName()});
    }

    public void setValue(XData value) throws XDataException {
    }

    public void setValue(int index, int value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, long value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, float value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, double value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, String value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, boolean value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, Date value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, Node value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, Object value) throws XDataException {
        this.setValue(value);
    }

    public void setValue(int index, XData value) throws XDataException {
        this.setValue(value);
    }

    public String toString() {
        return this.stringValue();
    }

    public XDataSet extendDataSet(int length) throws XDataException {
        XData.error("CANT_TO_ARRAY", new Object[]{this.getTypeName()});
        return null;
    }

    public NodeList nodeset() throws XDataException {
        XData.error("CANT_TO_NODELIST", new Object[]{this.getTypeName()});
        return null;
    }

    public int getDimension() {
        int k = 0;
        XData obj = this;
        while (obj instanceof XDataSet) {
            ++k;
            Object obj2 = null;
            try {
                obj2 = obj.objectValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj2 == null || !(obj2 instanceof XData)) break;
            obj = (XData)obj2;
        }
        return k;
    }

    public XData cloneData() throws XDataException {
        return this.castToType(this.getPrimitiveType());
    }

    public XData castToType(int t) throws XDataException {
        XData result;
        switch (t) {
            case 5: {
                result = new XBoolean(this.booleanValue());
                break;
            }
            case 1: {
                result = new XInteger(this.intValue());
                break;
            }
            case 2: {
                result = new XLong(this.longValue());
                break;
            }
            case 3: {
                result = new XFloat(this.floatValue());
                break;
            }
            case 4: {
                result = new XDouble(this.doubleValue());
                break;
            }
            case 6: {
                result = new XString(this.stringValue());
                break;
            }
            case 7: {
                result = new XDate(this.dateValue());
                break;
            }
            case 18: {
                result = new XNode(this.nodeValue());
                break;
            }
            case 17: {
                result = new XObject(this.objectValue());
                break;
            }
            default: {
                XData.error("CANT_TO_TYPE", new Object[]{this.getTypeName(), XData.getTypeName(t)});
                result = null;
            }
        }
        return result;
    }

    public boolean lessThan(XData obj2) throws XDataException {
        if (obj2.getType() == 274) {
            return obj2.greaterThan(this);
        }
        return this.doubleValue() < obj2.doubleValue();
    }

    public boolean lessThanOrEqual(XData obj2) throws XDataException {
        if (obj2.getType() == 274) {
            return obj2.greaterThanOrEqual(this);
        }
        return this.doubleValue() <= obj2.doubleValue();
    }

    public boolean greaterThan(XData obj2) throws XDataException {
        if (obj2.getType() == 274) {
            return obj2.lessThan(this);
        }
        return this.doubleValue() > obj2.doubleValue();
    }

    public boolean greaterThanOrEqual(XData obj2) throws XDataException {
        if (obj2.getType() == 274) {
            return obj2.lessThanOrEqual(this);
        }
        return this.doubleValue() >= obj2.doubleValue();
    }

    public boolean equals(XData obj2) throws XDataException {
        if (obj2.getType() == 274) {
            return obj2.equals(this);
        }
        return this.objectValue().equals(obj2.objectValue());
    }

    public boolean notEquals(XData obj2) throws XDataException {
        if (obj2.getType() == 274) {
            return obj2.notEquals(this);
        }
        return !this.equals(obj2);
    }

    public static void error(String msg, String arg) throws XDataException {
        XData.error(msg, new Object[]{arg}, false);
    }

    public static void error(String msg, String arg, boolean exception) throws XDataException {
        XData.error(msg, new Object[]{arg}, exception);
    }

    public static void error(String msg, Object[] args) throws XDataException {
        XData.error(msg, args, false);
    }

    public static void error(Exception e, boolean exception) throws XDataException {
        String fmsg = e.getMessage();
        XDataException e1 = new XDataException(fmsg, e, exception);
        throw e1;
    }

    public static void error(String msg, Object[] args, boolean exception) throws XDataException {
        String fmsg = msgCatalog.getMessage(msg, args);
        XDataException e = new XDataException(fmsg, exception);
        e.msgID = msg;
        throw e;
    }

    public static XData convertToXData(Object obj) {
        if (obj == null) {
            return XNULL;
        }
        if (obj instanceof XData) {
            return (XData)obj;
        }
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            if (obj instanceof boolean[]) {
                return new XBooleanSet((boolean[])obj);
            }
            if (obj instanceof int[]) {
                return new XIntegerSet((int[])obj);
            }
            if (obj instanceof long[]) {
                return new XLongSet((long[])obj);
            }
            if (obj instanceof float[]) {
                return new XFloatSet((float[])obj);
            }
            if (obj instanceof double[]) {
                return new XDoubleSet((double[])obj);
            }
            if (obj instanceof String[]) {
                return new XStringSet((String[])obj);
            }
            if (obj instanceof Date[]) {
                return new XDateSet((Date[])obj);
            }
            if (obj instanceof Node[]) {
                return new XNodeSet((Node[])obj);
            }
            if (obj instanceof byte[]) {
                return new XBytes((byte[])obj);
            }
            if (obj instanceof short[]) {
                short[] bb = (short[])obj;
                int[] ss = new int[bb.length];
                for (int i = 0; i < bb.length; ++i) {
                    ss[i] = bb[i];
                }
                return new XIntegerSet(ss);
            }
            if (obj instanceof char[]) {
                char[] cc = (char[])obj;
                String[] ss = new String[cc.length];
                for (int i = 0; i < cc.length; ++i) {
                    ss[i] = String.valueOf(cc[i]);
                }
                return new XStringSet(ss);
            }
            return new XObjectSet((Object[])obj);
        }
        if (obj instanceof Boolean) {
            return new XBoolean((Boolean)obj);
        }
        if (obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return new XInteger(((Number)obj).intValue());
        }
        if (obj instanceof Long) {
            return new XLong((Long)obj);
        }
        if (obj instanceof Float) {
            return new XFloat((Float)obj);
        }
        if (obj instanceof Double) {
            return new XDouble((Double)obj);
        }
        if (obj instanceof String || obj instanceof Character) {
            return new XString(obj.toString());
        }
        if (obj instanceof Date) {
            return new XDate((Date)obj);
        }
        if (obj instanceof Node) {
            return new XNode((Node)obj);
        }
        return new XObject(obj);
    }

    public void dump(Writer out) throws IOException {
        if (this.getDimension() >= 2) {
            throw new IOException("2\u6b21\u5143\u4ee5\u4e0a\u306e\u914d\u5217\u306f\u30c0\u30f3\u30d7\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.isString()) {
            out.write(34);
            out.write(this.stringValue());
            out.write(34);
        } else {
            out.write(this.stringValue());
        }
    }

    @Override
    public boolean hasChildenDataViewer() {
        return false;
    }

    @Override
    public XDataViewer[] getChildren() {
        return null;
    }

    @Override
    public String getEvalType() {
        return this.getTypeName();
    }

    @Override
    public String getEvalName() {
        return null;
    }

    @Override
    public Object getEvalValue() {
        return this.stringValue();
    }

    static {
        String classbase;
        int k;
        TYPENAME = new String[]{"null", "int", "long", "float", "double", "boolean", "String", "Date", "null", "null", "null", "null", "null", "null", "null", "null", "void", "Object", "Node", "Bytes"};
        ARRAYTYPENAME = new String[]{"null", "int[]", "long[]", "float[]", "double[]", "boolean[]", "String[]", "Date[]", "null", "null", "null", "null", "null", "null", "null", "null", "null", "Object[]", "Node[]", "null"};
        TYPECLASS = new Class[]{XNull.class, XInteger.class, XLong.class, XFloat.class, XDouble.class, XBoolean.class, XString.class, XDate.class, null, null, null, null, null, null, null, null, XVoid.class, XObject.class, XNode.class, XBytes.class};
        ARRAYTYPECLASS = new Class[]{null, null, XIntegerSet.class, XLongSet.class, XFloatSet.class, XDoubleSet.class, XBooleanSet.class, XStringSet.class, XDateSet.class, null, null, null, null, null, null, null, null, null, XObjectSet.class, XNodeSet.class, null};
        XNULL = new XNull();
        XVOID = new XVoid();
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        if ((k = (classbase = XData.class.getName()).lastIndexOf(".")) > 0) {
            classbase = classbase.substring(0, k + 1);
        }
        classbase = classbase + "MessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.err.println(e1);
                System.exit(1);
            }
        }
    }
}

