/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XBooleanSet;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataViewer;
import com.argo21.common.lang.XDateSet;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XFloatSet;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XObjectSet;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringSet;
import com.argo21.common.lang.XVoid;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import org.w3c.dom.Node;

public abstract class XDataSet
extends XData {
    public static int BASESIZE = 16;
    protected int count = 0;

    public static void registObject() {
        Class<XDataSet> cls = XDataSet.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Data[]");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("sum", md, String.valueOf(9), XDouble.class);
        od.addMethodDeclaration("average", md, String.valueOf(10), XDouble.class);
        od.addMethodDeclaration("sort", md, String.valueOf(11), XVoid.class);
        od.addMethodDeclaration("sort", md, String.valueOf(12), XVoid.class, 1);
        od.addMethodDeclaration("join", md, String.valueOf(14), XString.class);
        od.addMethodDeclaration("join", md, String.valueOf(15), XString.class, 1);
        od.addMethodDeclaration("reverse", md, String.valueOf(16), XVoid.class);
    }

    public static int expectCapacity(int oldCapacity, int minCapacity) {
        int newCapacity = oldCapacity << 1;
        return newCapacity < minCapacity ? minCapacity : newCapacity;
    }

    @Override
    public int size() {
        return this.count;
    }

    public abstract void expendsCapacity(int var1);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (idd) {
            case 9: {
                return this.sum();
            }
            case 10: {
                XData value = this.average();
                int type = this.getPrimitiveType();
                if (type == 1 || type == 2) {
                    return value.castToType(2);
                }
                return value;
            }
            case 11: {
                this.sort(true);
                return XData.XVOID;
            }
            case 12: {
                this.sort(parameters[0].booleanValue());
                return XData.XVOID;
            }
            case 14: {
                return this.join(",");
            }
            case 15: {
                return this.join(parameters[0].stringValue());
            }
            case 16: {
                this.reverse();
                return XData.XVOID;
            }
        }
        return super.invoke(id2, parameters);
    }

    public XData average() throws XDataException {
        XData value = this.sum();
        int n = this.size();
        if (n == 0) {
            return value;
        }
        double d = value.doubleValue() / (double)n;
        value.setValue(d);
        int type = this.getPrimitiveType();
        if (type == 1 || type == 2) {
            return value.castToType(2);
        }
        return value;
    }

    public void sort(boolean rise) throws XDataException {
    }

    public abstract void reverse() throws XDataException;

    public XData sum() throws XDataException {
        int n = this.size();
        double value = 0.0;
        for (int i = 0; i < n; ++i) {
            value += this.doubleValue(i);
        }
        int type = this.getPrimitiveType();
        if (type == 1 || type == 2) {
            return new XLong((long)value);
        }
        return new XDouble(value);
    }

    public XData join(String separator) throws XDataException {
        int n = this.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(this.stringValue(i));
        }
        return new XString(sb.toString());
    }

    public Object[] objectValues() throws XDataException {
        Object[] result = new Object[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.objectValue(i);
        }
        return result;
    }

    public int[] intValues() throws XDataException {
        int[] result = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.intValue(i);
        }
        return result;
    }

    public long[] longValues() throws XDataException {
        long[] result = new long[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.longValue(i);
        }
        return result;
    }

    public float[] floatValues() throws XDataException {
        float[] result = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.floatValue(i);
        }
        return result;
    }

    public double[] doubleValues() throws XDataException {
        double[] result = new double[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.doubleValue(i);
        }
        return result;
    }

    public boolean[] booleanValues() throws XDataException {
        boolean[] result = new boolean[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.booleanValue(i);
        }
        return result;
    }

    public String[] stringValues() throws XDataException {
        String[] result = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.stringValue(i);
        }
        return result;
    }

    public Date[] dateValues() throws XDataException {
        Date[] result = new Date[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.dateValue(i);
        }
        return result;
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.booleanValue(0);
    }

    @Override
    public abstract boolean booleanValue(int var1) throws XDataException;

    @Override
    public int intValue() throws XDataException {
        return this.intValue(0);
    }

    @Override
    public abstract int intValue(int var1) throws XDataException;

    @Override
    public long longValue() throws XDataException {
        return this.longValue(0);
    }

    @Override
    public abstract long longValue(int var1) throws XDataException;

    @Override
    public float floatValue() throws XDataException {
        return this.floatValue(0);
    }

    @Override
    public abstract float floatValue(int var1) throws XDataException;

    @Override
    public double doubleValue() throws XDataException {
        return this.doubleValue(0);
    }

    @Override
    public abstract double doubleValue(int var1) throws XDataException;

    @Override
    public String stringValue() {
        return this.stringValue(0);
    }

    @Override
    public abstract String stringValue(int var1);

    @Override
    public Date dateValue() throws XDataException {
        return this.dateValue(0);
    }

    @Override
    public Date dateValue(int index) throws XDataException {
        XDataSet.error("CANT_TO_DATE", new Object[]{this.getTypeName()});
        return null;
    }

    @Override
    public Node nodeValue() throws XDataException {
        return this.nodeValue(0);
    }

    @Override
    public Node nodeValue(int index) throws XDataException {
        XDataSet.error("CANT_TO_NODE", new Object[]{this.getTypeName()});
        return null;
    }

    @Override
    public Object objectValue() {
        return this.objectValue(0);
    }

    @Override
    public abstract Object objectValue(int var1);

    @Override
    public void setValue(int value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(long value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(float value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(double value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(String value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(boolean value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(Date value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(Node value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(Object value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(XData value) throws XDataException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValue(i, value);
        }
    }

    @Override
    public void setValue(int index, int value) throws XDataException {
    }

    @Override
    public void setValue(int index, long value) throws XDataException {
    }

    @Override
    public void setValue(int index, float value) throws XDataException {
    }

    @Override
    public void setValue(int index, double value) throws XDataException {
    }

    @Override
    public void setValue(int index, String value) throws XDataException {
    }

    @Override
    public void setValue(int index, boolean value) throws XDataException {
    }

    @Override
    public void setValue(int index, Date value) throws XDataException {
    }

    @Override
    public void setValue(int index, Node value) throws XDataException {
    }

    @Override
    public void setValue(int index, Object value) throws XDataException {
    }

    @Override
    public void setValue(int index, XData value) throws XDataException {
    }

    @Override
    public XData castToType(int t) throws XDataException {
        XDataSet result;
        switch (t) {
            case 5: {
                result = new XBooleanSet(this.booleanValues());
                break;
            }
            case 1: {
                result = new XIntegerSet(this.intValues());
                break;
            }
            case 2: {
                result = new XLongSet(this.longValues());
                break;
            }
            case 3: {
                result = new XFloatSet(this.floatValues());
                break;
            }
            case 4: {
                result = new XDoubleSet(this.doubleValues());
                break;
            }
            case 6: {
                result = new XStringSet(this.stringValues());
                break;
            }
            case 7: {
                result = new XDateSet(this.dateValues());
                break;
            }
            case 18: {
                result = new XNodeSet(this.nodeset());
                break;
            }
            case 17: {
                result = new XObjectSet(this.objectValues());
                break;
            }
            default: {
                XDataSet.error("CANT_TO_TYPE", new Object[]{this.getTypeName(), Integer.toString(t)});
                result = null;
            }
        }
        return result;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (this.count <= 0) {
            return false;
        }
        if (obj2.isNode()) {
            return obj2.equals(this);
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.doubleValue(i) == obj2.doubleValue(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dump(Writer out) throws IOException {
        if (this.getDimension() >= 2) {
            throw new IOException("2\u6b21\u5143\u4ee5\u4e0a\u306e\u914d\u5217\u306f\u30c0\u30f3\u30d7\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        int last2 = this.size() - 1;
        out.write(123);
        if (this.isString()) {
            for (int i = 0; i <= last2; ++i) {
                out.write(34);
                out.write(this.stringValue(i));
                out.write(34);
                if (i >= last2) continue;
                out.write(44);
            }
        } else {
            for (int i = 0; i <= last2; ++i) {
                out.write(this.stringValue(i));
                if (i >= last2) continue;
                out.write(44);
            }
            out.write(125);
        }
    }

    @Override
    public boolean hasChildenDataViewer() {
        return true;
    }

    @Override
    public XDataViewer[] getChildren() {
        int n = this.size();
        XDataViewer[] res = new XDataViewer[n];
        for (int i = 0; i < n; ++i) {
            res[i] = new DataSetViewer(i);
        }
        return res;
    }

    @Override
    public Object getEvalValue() {
        return "";
    }

    private class DataSetViewer
    implements XDataViewer {
        int index;

        DataSetViewer(int index) {
            this.index = index;
        }

        @Override
        public boolean hasChildenDataViewer() {
            return false;
        }

        @Override
        public XDataViewer[] getChildren() {
            return null;
        }

        @Override
        public String getEvalType() {
            return XDataSet.this.getPrimitiveTypeName();
        }

        @Override
        public String getEvalName() {
            return null;
        }

        @Override
        public Object getEvalValue() {
            return XDataSet.this.stringValue(this.index);
        }
    }
}

