/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XVoid;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.w3c.dom.Node;

public final class XDate
extends XData {
    Date m_val;
    public static final int METHOD_NEWDATA0 = 257;
    public static final int METHOD_NEWDATA1 = 258;
    public static final int METHOD_NEWDATA2 = 259;
    public static final int METHOD_NEWDATA3 = 260;
    public static final int METHOD_NEWDATA6 = 261;
    public static final int METHOD_EQUALS = 262;
    public static final int METHOD_COMPARETO = 263;
    public static final int METHOD_TOSTRING0 = 264;
    public static final int METHOD_TOSTRING1 = 265;
    public static final int METHOD_PARSE1 = 266;
    public static final int METHOD_PARSE2 = 267;
    public static final int METHOD_GETDATE = 268;
    public static final int METHOD_GETDAY = 269;
    public static final int METHOD_GETHOURS = 270;
    public static final int METHOD_GETMINUTES = 271;
    public static final int METHOD_GETMONTH = 272;
    public static final int METHOD_GETSECONDS = 273;
    public static final int METHOD_GETTIME = 274;
    public static final int METHOD_GETTIMEZONEOFFSET = 275;
    public static final int METHOD_GETYEAR = 276;
    public static final int METHOD_SETDATE = 277;
    public static final int METHOD_SETHOURS = 278;
    public static final int METHOD_SETMINUTES = 279;
    public static final int METHOD_SETMONTH = 280;
    public static final int METHOD_SETSECONDS = 281;
    public static final int METHOD_SETTIME = 282;
    public static final int METHOD_SETYEAR = 283;
    public static final int METHOD_TOGMTSTRING = 284;
    public static final int METHOD_TOLOCALSTRING = 285;
    public static final int METHOD_ADDYEAR = 286;
    public static final int METHOD_ADDMONTH = 287;
    public static final int METHOD_ADDDAY = 288;
    public static final int METHOD_ADDHOURS = 289;
    public static final int METHOD_ADDMINUTS = 290;
    public static final int METHOD_ADDSECOND = 291;

    public static void registObject() {
        Class<XDate> cls = XDate.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Date");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("Date", md, String.valueOf(257), cls, 0, true);
        od.addMethodDeclaration("Date", md, String.valueOf(258), cls, 1, true);
        od.addMethodDeclaration("Date", md, String.valueOf(259), cls, 2, true);
        od.addMethodDeclaration("Date", md, String.valueOf(260), cls, 3, true);
        od.addMethodDeclaration("Date", md, String.valueOf(261), cls, 6, true);
        od.addMethodDeclaration("equals", md, String.valueOf(262), XBoolean.class, 1);
        od.addMethodDeclaration("compareTo", md, String.valueOf(263), XInteger.class, 1);
        od.addMethodDeclaration("toString", md, String.valueOf(264), XString.class, 0);
        od.addMethodDeclaration("toString", md, String.valueOf(265), XString.class, 1);
        od.addMethodDeclaration("parse", md, String.valueOf(266), cls, 1, true);
        od.addMethodDeclaration("parse", md, String.valueOf(267), cls, 2, true);
        od.addMethodDeclaration("getDate", md, String.valueOf(268), XInteger.class);
        od.addMethodDeclaration("getDay", md, String.valueOf(269), XInteger.class);
        od.addMethodDeclaration("getHours", md, String.valueOf(270), XInteger.class);
        od.addMethodDeclaration("getMinutes", md, String.valueOf(271), XInteger.class);
        od.addMethodDeclaration("getMonth", md, String.valueOf(272), XInteger.class);
        od.addMethodDeclaration("getSeconds", md, String.valueOf(273), XInteger.class);
        od.addMethodDeclaration("getTime", md, String.valueOf(274), XLong.class);
        od.addMethodDeclaration("getTimezoneOffset", md, String.valueOf(275), XInteger.class);
        od.addMethodDeclaration("getYear", md, String.valueOf(276), XInteger.class);
        od.addMethodDeclaration("setDate", md, String.valueOf(277), XVoid.class, 1);
        od.addMethodDeclaration("setHours", md, String.valueOf(278), XVoid.class, 1);
        od.addMethodDeclaration("setMinutes", md, String.valueOf(279), XVoid.class, 1);
        od.addMethodDeclaration("setMonth", md, String.valueOf(280), XVoid.class, 1);
        od.addMethodDeclaration("setSeconds", md, String.valueOf(281), XVoid.class, 1);
        od.addMethodDeclaration("setTime", md, String.valueOf(282), XVoid.class, 1);
        od.addMethodDeclaration("setYear", md, String.valueOf(283), XVoid.class, 1);
        od.addMethodDeclaration("toGMTString", md, String.valueOf(284), XString.class);
        od.addMethodDeclaration("toLocalString", md, String.valueOf(285), XString.class);
        od.addMethodDeclaration("addYear", md, String.valueOf(286), cls, 1);
        od.addMethodDeclaration("addMonth", md, String.valueOf(287), cls, 1);
        od.addMethodDeclaration("addDay", md, String.valueOf(288), cls, 1);
        od.addMethodDeclaration("addHours", md, String.valueOf(289), cls, 1);
        od.addMethodDeclaration("addMinutes", md, String.valueOf(290), cls, 1);
        od.addMethodDeclaration("addSeconds", md, String.valueOf(291), cls, 1);
    }

    @Override
    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (idd) {
            case 257: {
                return new XDate(new Date());
            }
            case 258: {
                try {
                    Date date = new Date(parameters[0].stringValue());
                    return new XDate(date);
                }
                catch (Exception e) {
                    XData.error("VALUE_CANT_TO_TYPE", new Object[]{parameters[0].stringValue(), "Date"}, true);
                }
            }
            case 259: {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(parameters[1].stringValue());
                    Date date = format.parse(parameters[0].stringValue(), new ParsePosition(0));
                    return new XDate(date);
                }
                catch (Exception e) {
                    XData.error("CANT_PARSE_FMT", new Object[]{parameters[0].stringValue(), parameters[1].stringValue()}, true);
                }
            }
            case 260: {
                int day;
                int month;
                int year = parameters[0].intValue();
                if (year < 1900) {
                    XData.error("INVAILD_YEAR", new Object[0]);
                }
                if ((month = parameters[1].intValue()) < 1 || month > 12) {
                    XData.error("INVAILD_MONTH", new Object[0]);
                }
                if ((day = parameters[2].intValue()) < 1 || day > 31) {
                    XData.error("INVAILD_DAY", new Object[0]);
                }
                return new XDate(new Date(year - 1900, month - 1, day));
            }
            case 261: {
                int day;
                int month;
                int year = parameters[0].intValue();
                if (year < 1900) {
                    XData.error("INVAILD_YEAR", new Object[0]);
                }
                if ((month = parameters[1].intValue()) < 1 || month > 12) {
                    XData.error("INVAILD_MONTH", new Object[0]);
                }
                if ((day = parameters[2].intValue()) < 1 || day > 31) {
                    XData.error("INVAILD_DAY", new Object[0]);
                }
                return new XDate(new Date(year - 1900, month - 1, day, parameters[3].intValue(), parameters[4].intValue(), parameters[5].intValue()));
            }
            case 262: {
                return new XBoolean(this.m_val.equals(parameters[0].dateValue()));
            }
            case 263: {
                return new XInteger(this.m_val.compareTo(parameters[0].dateValue()));
            }
            case 264: {
                return new XString(this.m_val.toString());
            }
            case 265: {
                SimpleDateFormat format1 = new SimpleDateFormat(parameters[0].stringValue());
                StringBuffer toAppendTo = new StringBuffer();
                format1.format(this.m_val, toAppendTo, new FieldPosition(0));
                return new XString(toAppendTo.toString());
            }
            case 266: {
                try {
                    Date date = new Date(Date.parse(parameters[0].stringValue()));
                    return new XDate(date);
                }
                catch (Exception e) {
                    XData.error("VALUE_CANT_TO_TYPE", new Object[]{parameters[0].stringValue(), "Date"}, true);
                }
            }
            case 267: {
                try {
                    SimpleDateFormat format1 = new SimpleDateFormat(parameters[1].stringValue());
                    Date date = format1.parse(parameters[0].stringValue());
                    return new XDate(date);
                }
                catch (Exception e) {
                    XData.error("CANT_PARSE_FMT", new Object[]{parameters[0].stringValue(), parameters[1].stringValue()}, true);
                }
            }
            case 268: {
                return new XInteger(this.m_val.getDate());
            }
            case 269: {
                return new XInteger(this.m_val.getDay());
            }
            case 270: {
                return new XInteger(this.m_val.getHours());
            }
            case 271: {
                return new XInteger(this.m_val.getMinutes());
            }
            case 272: {
                return new XInteger(this.m_val.getMonth() + 1);
            }
            case 273: {
                return new XInteger(this.m_val.getSeconds());
            }
            case 274: {
                return new XLong(this.m_val.getTime());
            }
            case 275: {
                return new XInteger(this.m_val.getTimezoneOffset());
            }
            case 276: {
                return new XInteger(this.m_val.getYear() + 1900);
            }
            case 277: {
                this.m_val.setDate(parameters[0].intValue());
                return XData.XVOID;
            }
            case 278: {
                this.m_val.setHours(parameters[0].intValue());
                return XData.XVOID;
            }
            case 279: {
                this.m_val.setMinutes(parameters[0].intValue());
                return XData.XVOID;
            }
            case 280: {
                int month = parameters[0].intValue();
                if (month < 1 || month > 12) {
                    XData.error("INVAILD_MONTH", new Object[0]);
                }
                this.m_val.setMonth(month - 1);
                return XData.XVOID;
            }
            case 281: {
                this.m_val.setSeconds(parameters[0].intValue());
                return XData.XVOID;
            }
            case 282: {
                this.m_val.setTime(parameters[0].longValue());
                return XData.XVOID;
            }
            case 283: {
                int year = parameters[0].intValue();
                if (year < 1900) {
                    XData.error("INVAILD_YEAR", new Object[0]);
                }
                this.m_val.setYear(year - 1900);
                return XData.XVOID;
            }
            case 284: {
                return new XString(this.m_val.toGMTString());
            }
            case 285: {
                return new XString(this.m_val.toLocaleString());
            }
            case 286: {
                Date date = XDate.dataAdd(this.m_val, 1, parameters[0].intValue());
                return new XDate(date);
            }
            case 287: {
                Date date = XDate.dataAdd(this.m_val, 2, parameters[0].intValue());
                return new XDate(date);
            }
            case 288: {
                Date date = XDate.dataAdd(this.m_val, 5, parameters[0].intValue());
                return new XDate(date);
            }
            case 289: {
                Date date = XDate.dataAdd(this.m_val, 11, parameters[0].intValue());
                return new XDate(date);
            }
            case 290: {
                Date date = XDate.dataAdd(this.m_val, 12, parameters[0].intValue());
                return new XDate(date);
            }
            case 291: {
                Date date = XDate.dataAdd(this.m_val, 13, parameters[0].intValue());
                return new XDate(date);
            }
        }
        return super.invoke(id2, parameters);
    }

    @Override
    public boolean isEmpty() {
        return this.m_val == null;
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public String getTypeName() {
        return "Date";
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return false;
    }

    @Override
    public int intValue() throws XDataException {
        return 0;
    }

    @Override
    public long longValue() throws XDataException {
        return 0L;
    }

    @Override
    public float floatValue() throws XDataException {
        return 0.0f;
    }

    @Override
    public double doubleValue() throws XDataException {
        return Double.NaN;
    }

    @Override
    public String stringValue() {
        return this.m_val != null ? DateFormat.getDateTimeInstance().format(this.m_val) : "";
    }

    @Override
    public String stringValue(int index) {
        return this.m_val != null ? DateFormat.getDateTimeInstance().format(this.m_val) : "";
    }

    @Override
    public Date dateValue() throws XDataException {
        return this.m_val;
    }

    @Override
    public Node nodeValue() throws XDataException {
        XDate.error("CANT_TO_NODE", new Object[]{this.getTypeName()});
        return null;
    }

    @Override
    public Object objectValue() {
        return this.m_val;
    }

    public XDate(Date val) {
        this.m_val = val;
    }

    @Override
    public void setValue(String value) throws XDataException {
        if (value == null || value.length() == 0) {
            this.m_val = null;
            return;
        }
        try {
            this.m_val = new Date(value);
        }
        catch (Exception e) {
            XData.error("VALUE_CANT_TO_TYPE", new Object[]{value, "Date"});
        }
    }

    @Override
    public void setValue(Date value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(Node value) throws XDataException {
        this.setValue(XNode.getStringFromNode(value));
    }

    @Override
    public void setValue(Object value) throws XDataException {
        this.setValue(value.toString());
    }

    @Override
    public void setValue(XData value) throws XDataException {
        this.m_val = value.dateValue();
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (obj2.getType() == 7) {
            return obj2.equals(this);
        }
        return this.stringValue().equals(obj2.stringValue());
    }

    @Override
    public XDataSet extendDataSet(int length) {
        return null;
    }

    public static Date dataAdd(Date date, int fieldI, int val) throws XDataException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(fieldI, val);
        return cal.getTime();
    }

    public static void main(String[] args) {
        Date date = new Date("1955/8/12");
        DateFormat format = DateFormat.getDateTimeInstance();
        format.setTimeZone(TimeZone.getDefault());
        System.out.println(format.format(date));
        System.out.println(date.toGMTString());
        System.out.println(date.toLocaleString());
        System.out.println(date.toString());
        System.out.println(new Date(date.toGMTString()));
        System.out.println(new Date(date.toLocaleString()));
        System.out.println(new Date(date.toString()));
    }
}

