/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLongSet;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XStringSet;
import com.argo21.common.lang.XVoid;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import org.w3c.dom.Node;

public final class XDateSet
extends XDataSet {
    Date[] m_val = null;

    public static void registObject() {
        Class<XDataSet> cls = XDataSet.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Date[]");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("equals", md, String.valueOf(262), XBoolean.class, 1);
        od.addMethodDeclaration("compareTo", md, String.valueOf(263), XIntegerSet.class, 1);
        od.addMethodDeclaration("toString", md, String.valueOf(264), XStringSet.class);
        od.addMethodDeclaration("toString", md, String.valueOf(265), XStringSet.class, 1);
        od.addMethodDeclaration("getDate", md, String.valueOf(268), XIntegerSet.class);
        od.addMethodDeclaration("getDay", md, String.valueOf(269), XIntegerSet.class, 0);
        od.addMethodDeclaration("getHours", md, String.valueOf(270), XIntegerSet.class);
        od.addMethodDeclaration("getMinutes", md, String.valueOf(271), XIntegerSet.class, 0);
        od.addMethodDeclaration("getMonth", md, String.valueOf(272), XIntegerSet.class);
        od.addMethodDeclaration("getSeconds", md, String.valueOf(273), XIntegerSet.class, 0);
        od.addMethodDeclaration("getTime", md, String.valueOf(274), XLongSet.class, 0);
        od.addMethodDeclaration("getTimezoneOffset", md, String.valueOf(275), XIntegerSet.class, 0);
        od.addMethodDeclaration("getYear", md, String.valueOf(276), XIntegerSet.class, 0);
        od.addMethodDeclaration("setDate", md, String.valueOf(277), XVoid.class, 1);
        od.addMethodDeclaration("setHours", md, String.valueOf(278), XVoid.class, 1);
        od.addMethodDeclaration("setMinutes", md, String.valueOf(279), XVoid.class, 1);
        od.addMethodDeclaration("setMonth", md, String.valueOf(280), XVoid.class, 1);
        od.addMethodDeclaration("setSeconds", md, String.valueOf(281), XVoid.class, 1);
        od.addMethodDeclaration("setTime", md, String.valueOf(282), XVoid.class, 1);
        od.addMethodDeclaration("setYear", md, String.valueOf(283), XVoid.class, 1);
        od.addMethodDeclaration("toGMTString", md, String.valueOf(284), XStringSet.class, 0);
        od.addMethodDeclaration("toLocalString", md, String.valueOf(285), XStringSet.class, 0);
        od.addMethodDeclaration("addYear", md, String.valueOf(286), cls, 1);
        od.addMethodDeclaration("addMonth", md, String.valueOf(287), cls, 1);
        od.addMethodDeclaration("addDay", md, String.valueOf(288), cls, 1);
        od.addMethodDeclaration("addHours", md, String.valueOf(289), cls, 1);
        od.addMethodDeclaration("addMinutes", md, String.valueOf(290), cls, 1);
        od.addMethodDeclaration("addSeconds", md, String.valueOf(291), cls, 1);
    }

    @Override
    public XData invoke(String id2, XData[] parameters) throws XDataException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            switch (idd) {
                case 262: {
                    for (int i = 0; i < this.count; ++i) {
                        if (this.m_val[i].equals(parameters[0].dateValue(i))) continue;
                        return new XBoolean(false);
                    }
                    return new XBoolean(true);
                }
                case 263: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].compareTo(parameters[0].dateValue(i));
                    }
                    return new XIntegerSet(result_I);
                }
                case 264: {
                    String[] result_S = new String[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_S[i] = this.m_val[i].toString();
                    }
                    return new XStringSet(result_S);
                }
                case 265: {
                    String[] result_S = new String[this.count];
                    SimpleDateFormat format1 = new SimpleDateFormat(parameters[0].stringValue());
                    for (int i = 0; i < this.count; ++i) {
                        StringBuffer toAppendTo = new StringBuffer();
                        format1.format(this.m_val, toAppendTo, new FieldPosition(0));
                        result_S[i] = toAppendTo.toString();
                    }
                    return new XStringSet(result_S);
                }
                case 268: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getDate();
                    }
                    return new XIntegerSet(result_I);
                }
                case 269: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getDay();
                    }
                    return new XIntegerSet(result_I);
                }
                case 270: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getHours();
                    }
                    return new XIntegerSet(result_I);
                }
                case 271: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getMinutes();
                    }
                    return new XIntegerSet(result_I);
                }
                case 272: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getMonth() + 1;
                    }
                    return new XIntegerSet(result_I);
                }
                case 273: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getSeconds();
                    }
                    return new XIntegerSet(result_I);
                }
                case 274: {
                    long[] result_L = new long[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_L[i] = this.m_val[i].getTime();
                    }
                    return new XLongSet(result_L);
                }
                case 275: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getTimezoneOffset();
                    }
                    return new XIntegerSet(result_I);
                }
                case 276: {
                    int[] result_I = new int[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_I[i] = this.m_val[i].getYear() + 1900;
                    }
                    return new XIntegerSet(result_I);
                }
                case 277: {
                    for (int i = 0; i < this.count; ++i) {
                        this.m_val[i].setDate(parameters[0].intValue(i));
                    }
                    return XData.XVOID;
                }
                case 278: {
                    for (int i = 0; i < this.count; ++i) {
                        this.m_val[i].setHours(parameters[0].intValue(i));
                    }
                    return XData.XVOID;
                }
                case 279: {
                    for (int i = 0; i < this.count; ++i) {
                        this.m_val[i].setMinutes(parameters[0].intValue(i));
                    }
                    return XData.XVOID;
                }
                case 280: {
                    for (int i = 0; i < this.count; ++i) {
                        int month = parameters[0].intValue(i);
                        this.m_val[i].setMonth(month + 1);
                    }
                    return XData.XVOID;
                }
                case 281: {
                    for (int i = 0; i < this.count; ++i) {
                        this.m_val[i].setSeconds(parameters[0].intValue(i));
                    }
                    return XData.XVOID;
                }
                case 282: {
                    for (int i = 0; i < this.count; ++i) {
                        this.m_val[i].setTime(parameters[0].longValue(i));
                    }
                    return XData.XVOID;
                }
                case 283: {
                    for (int i = 0; i < this.count; ++i) {
                        int year = parameters[0].intValue(i);
                        if (year < 1900) {
                            XData.error("INVAILD_YEAR", new Object[0]);
                        }
                        this.m_val[i].setYear(year - 1900);
                    }
                    return XData.XVOID;
                }
                case 284: {
                    String[] result_S = new String[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_S[i] = this.m_val[i].toGMTString();
                    }
                    return new XStringSet(result_S);
                }
                case 285: {
                    String[] result_S = new String[this.count];
                    for (int i = 0; i < this.count; ++i) {
                        result_S[i] = this.m_val[i].toLocaleString();
                    }
                    return new XStringSet(result_S);
                }
                case 286: {
                    Date[] date = XDateSet.dataAdd(this.m_val, 1, parameters[0].intValue());
                    return new XDateSet(date);
                }
                case 287: {
                    Date[] date = XDateSet.dataAdd(this.m_val, 2, parameters[0].intValue());
                    return new XDateSet(date);
                }
                case 288: {
                    Date[] date = XDateSet.dataAdd(this.m_val, 5, parameters[0].intValue());
                    return new XDateSet(date);
                }
                case 289: {
                    Date[] date = XDateSet.dataAdd(this.m_val, 11, parameters[0].intValue());
                    return new XDateSet(date);
                }
                case 290: {
                    Date[] date = XDateSet.dataAdd(this.m_val, 12, parameters[0].intValue());
                    return new XDateSet(date);
                }
                case 291: {
                    Date[] date = XDateSet.dataAdd(this.m_val, 13, parameters[0].intValue());
                    return new XDateSet(date);
                }
            }
            return super.invoke(id2, parameters);
        }
        catch (XDataException e) {
            throw e;
        }
        catch (Exception e) {
            XData.error(e, true);
            return XData.XNULL;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_val == null || this.count == 0 || this.m_val[0] == null;
    }

    @Override
    public void sort(boolean rise) throws XDataException {
        if (rise) {
            Arrays.sort(this.m_val);
        } else {
            Arrays.sort(this.m_val, Collections.reverseOrder());
        }
    }

    @Override
    public void reverse() throws XDataException {
        int start = 0;
        for (int end = this.count - 1; start < end; ++start, --end) {
            Date tmp = this.m_val[start];
            this.m_val[start] = this.m_val[end];
            this.m_val[end] = tmp;
        }
    }

    public XDateSet(int capacity) {
        this.m_val = new Date[capacity];
    }

    public XDateSet(Date[] val) {
        this.m_val = val;
        this.count = val.length;
    }

    @Override
    public int getType() {
        return 263;
    }

    @Override
    public String getTypeName() {
        return "Date[]";
    }

    @Override
    public boolean booleanValue(int index) throws XDataException {
        return false;
    }

    @Override
    public double doubleValue(int index) throws XDataException {
        return 0.0;
    }

    @Override
    public float floatValue(int index) throws XDataException {
        return 0.0f;
    }

    @Override
    public Date dateValue(int index) throws XDataException {
        return this.count <= index ? null : this.m_val[index];
    }

    @Override
    public String stringValue(int index) {
        if (this.count > index) {
            return this.m_val[index] != null ? DateFormat.getDateTimeInstance().format(this.m_val[index]) : "";
        }
        return "";
    }

    @Override
    public int intValue(int index) throws XDataException {
        return 0;
    }

    @Override
    public long longValue(int index) throws XDataException {
        return 0L;
    }

    @Override
    public Object objectValue() {
        return this.m_val;
    }

    @Override
    public Object objectValue(int index) {
        return this.count <= index ? null : this.m_val[index];
    }

    @Override
    public void setValue(int index, String value) throws XDataException {
        if (value == null || value.length() == 0) {
            this.setValue(index, (Date)null);
            return;
        }
        try {
            this.setValue(index, new Date(value));
        }
        catch (Exception e) {
            XData.error("VALUE_CANT_TO_TYPE", new Object[]{value, "Date"});
        }
    }

    @Override
    public void setValue(int index, Node value) throws XDataException {
        this.setValue(index, XNode.getStringFromNode(value));
    }

    @Override
    public void setValue(int index, Object value) throws XDataException {
        this.setValue(index, value.toString());
    }

    @Override
    public void setValue(int index, XData value) throws XDataException {
        this.setValue(index, value.dateValue(index));
    }

    @Override
    public void setValue(int index, Date val) {
        if (index >= this.count) {
            this.expendsCapacity(index + 1);
            this.count = index + 1;
        }
        this.m_val[index] = val;
    }

    @Override
    public Date[] dateValues() throws XDataException {
        if (this.m_val.length == this.count) {
            return this.m_val;
        }
        Date[] result = new Date[this.count];
        System.arraycopy(this.m_val, 0, result, 0, this.count);
        return result;
    }

    public void append(Date val) {
        if (this.count >= this.m_val.length) {
            this.expendsCapacity(this.count + 1);
        }
        this.m_val[this.count++] = val;
    }

    public void set(int index, Date val) {
        if (index >= this.count) {
            this.count = index + 1;
            this.expendsCapacity(this.count);
        }
        this.m_val[index] = val;
    }

    @Override
    public synchronized void expendsCapacity(int minCapacity) {
        int oldCapacity = this.m_val.length;
        if (minCapacity > oldCapacity) {
            Date[] oldData = this.m_val;
            int newCapacity = oldCapacity + BASESIZE;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.m_val = new Date[newCapacity];
            System.arraycopy(oldData, 0, this.m_val, 0, this.count);
        }
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (this.count <= 0) {
            return false;
        }
        if (obj2.isNode()) {
            return obj2.equals(this);
        }
        for (int i = 0; i < this.count; ++i) {
            if (obj2.stringValue(i).equals(this.m_val[i].toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public XDataSet extendDataSet(int length) {
        Date[] result = new Date[length];
        if (this.count > 0) {
            int size;
            for (int k = 0; k < length; k += size) {
                size = length - k < this.count ? length - k : this.count;
                System.arraycopy(this.m_val, 0, result, k, size);
            }
        }
        return new XDateSet(result);
    }

    public static Date[] dataAdd(Date[] date, int fieldI, int val) throws XDataException {
        Date[] res = new Date[date.length];
        GregorianCalendar cal = new GregorianCalendar();
        for (int i = 0; i < date.length; ++i) {
            cal.setTime(date[i]);
            cal.add(fieldI, val);
            res[i] = cal.getTime();
        }
        return res;
    }
}

