/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XNode;
import java.util.Date;
import org.w3c.dom.Node;

public final class XDouble
extends XData {
    double m_val;

    public XDouble(double val) {
        this.m_val = val;
    }

    public XDouble(Double val) {
        this((double)val);
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.m_val != 0.0;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String getTypeName() {
        return "double";
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.m_val;
    }

    @Override
    public float floatValue() throws XDataException {
        return (float)this.m_val;
    }

    @Override
    public int intValue() throws XDataException {
        return (int)this.m_val;
    }

    @Override
    public long longValue() throws XDataException {
        return (long)this.m_val;
    }

    @Override
    public Object objectValue() {
        return new Double(this.m_val);
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.m_val);
    }

    @Override
    public void setValue(int value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(long value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(float value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(double value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(String value) throws XDataException {
        try {
            this.m_val = Double.parseDouble(value);
        }
        catch (Exception e) {
            XDouble.error("VALUE_CANT_TO_TYPE", new Object[]{value, this.getTypeName()});
        }
    }

    @Override
    public void setValue(boolean value) throws XDataException {
        this.m_val = value ? 1.0 : 0.0;
    }

    @Override
    public void setValue(Date value) throws XDataException {
        this.m_val = 0.0;
    }

    @Override
    public void setValue(Node value) throws XDataException {
        this.setValue(XNode.getStringFromNode(value));
    }

    @Override
    public void setValue(Object value) throws XDataException {
        this.setValue(value.toString());
    }

    @Override
    public void setValue(XData value) throws XDataException {
        this.m_val = value.doubleValue();
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (obj2.isNode()) {
            return obj2.equals(this);
        }
        return this.m_val == obj2.doubleValue();
    }

    @Override
    public XDataSet extendDataSet(int length) {
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.m_val;
        }
        return new XDoubleSet(result);
    }
}

