/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XNode;
import java.util.Date;
import org.w3c.dom.Node;

public final class XInteger
extends XData {
    int m_val;

    public XInteger(int val) {
        this.m_val = val;
    }

    public XInteger(Integer value) {
        this((int)value);
    }

    @Override
    public float floatValue() throws XDataException {
        return this.m_val;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getTypeName() {
        return "int";
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.m_val != 0;
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.m_val;
    }

    @Override
    public int intValue() throws XDataException {
        return this.m_val;
    }

    @Override
    public long longValue() throws XDataException {
        return this.m_val;
    }

    @Override
    public Object objectValue() {
        return new Integer(this.m_val);
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.m_val);
    }

    @Override
    public void setValue(int value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(long value) throws XDataException {
        this.m_val = (int)value;
    }

    @Override
    public void setValue(float value) throws XDataException {
        this.m_val = (int)value;
    }

    @Override
    public void setValue(double value) throws XDataException {
        this.m_val = (int)value;
    }

    @Override
    public void setValue(String value) throws XDataException {
        try {
            this.m_val = Integer.parseInt(value);
        }
        catch (Exception e) {
            try {
                this.m_val = (int)Double.parseDouble(value);
            }
            catch (Exception e1) {
                XInteger.error("VALUE_CANT_TO_TYPE", new Object[]{value, this.getTypeName()});
            }
        }
    }

    @Override
    public void setValue(boolean value) throws XDataException {
        this.m_val = value ? 1 : 0;
    }

    @Override
    public void setValue(Date value) throws XDataException {
        this.m_val = 0;
    }

    @Override
    public void setValue(Node value) throws XDataException {
        this.setValue(XNode.getStringFromNode(value));
    }

    @Override
    public void setValue(Object value) throws XDataException {
        this.setValue(value.toString());
    }

    @Override
    public void setValue(XData value) throws XDataException {
        this.m_val = value.intValue();
    }

    @Override
    public String toString() {
        return String.valueOf(this.m_val);
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (obj2.isNode()) {
            return obj2.equals(this);
        }
        return this.m_val == obj2.intValue();
    }

    @Override
    public XDataSet extendDataSet(int length) {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.m_val;
        }
        return new XIntegerSet(result);
    }
}

