/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XNode;
import java.util.Arrays;
import org.w3c.dom.Node;

public final class XIntegerSet
extends XDataSet {
    static int BASESIZE = 32;
    int[] m_val = null;

    public XIntegerSet(int capacity) {
        this.m_val = new int[capacity];
        this.count = 0;
    }

    public XIntegerSet(int[] val) {
        this.m_val = val;
        this.count = val.length;
    }

    @Override
    public int getType() {
        return 257;
    }

    @Override
    public String getTypeName() {
        return "int[]";
    }

    @Override
    public boolean booleanValue() throws XDataException {
        return this.count == 0 ? false : this.m_val[0] != 0;
    }

    @Override
    public boolean booleanValue(int index) throws XDataException {
        return this.count <= index ? false : this.m_val[index] != 0;
    }

    @Override
    public double doubleValue() throws XDataException {
        return this.count == 0 ? 0.0 : (double)this.m_val[0];
    }

    @Override
    public double doubleValue(int index) throws XDataException {
        return this.count <= index ? 0.0 : (double)this.m_val[index];
    }

    @Override
    public float floatValue() throws XDataException {
        return this.count == 0 ? 0.0f : (float)this.m_val[0];
    }

    @Override
    public float floatValue(int index) throws XDataException {
        return this.count <= index ? 0.0f : (float)this.m_val[index];
    }

    @Override
    public int intValue() throws XDataException {
        return this.count == 0 ? 0 : this.m_val[0];
    }

    @Override
    public int intValue(int index) throws XDataException {
        return this.count <= index ? 0 : this.m_val[index];
    }

    @Override
    public long longValue() throws XDataException {
        return this.count == 0 ? 0L : (long)this.m_val[0];
    }

    @Override
    public long longValue(int index) throws XDataException {
        return this.count <= index ? 0L : (long)this.m_val[index];
    }

    @Override
    public Object objectValue() {
        return this.m_val;
    }

    @Override
    public Object objectValue(int index) {
        return this.count <= index ? new Integer(0) : new Integer(this.m_val[0]);
    }

    @Override
    public String stringValue() {
        return this.count <= 0 ? "0" : String.valueOf(this.m_val[0]);
    }

    @Override
    public String stringValue(int index) {
        return this.count <= index ? "0" : String.valueOf(this.m_val[index]);
    }

    @Override
    public Object[] objectValues() throws XDataException {
        Object[] result = new Object[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = new Integer(this.m_val[i]);
        }
        return result;
    }

    @Override
    public int[] intValues() throws XDataException {
        if (this.m_val.length != this.count) {
            int[] result = new int[this.count];
            System.arraycopy(this.m_val, 0, result, 0, this.count);
            this.m_val = result;
        }
        return this.m_val;
    }

    @Override
    public long[] longValues() throws XDataException {
        long[] result = new long[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i];
        }
        return result;
    }

    @Override
    public float[] floatValues() throws XDataException {
        float[] result = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i];
        }
        return result;
    }

    @Override
    public double[] doubleValues() throws XDataException {
        double[] result = new double[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i];
        }
        return result;
    }

    @Override
    public String[] stringValues() throws XDataException {
        String[] result = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = String.valueOf(this.m_val[i]);
        }
        return result;
    }

    @Override
    public boolean[] booleanValues() throws XDataException {
        boolean[] result = new boolean[this.count];
        for (int i = 0; i < this.count; ++i) {
            result[i] = this.m_val[i] != 0;
        }
        return result;
    }

    public boolean containArray() {
        return false;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        if (this.count <= 0) {
            return false;
        }
        if (obj2.isNode()) {
            return obj2.equals(this);
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.m_val[i] == obj2.intValue(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sort(boolean rise) throws XDataException {
        Arrays.sort(this.m_val);
        if (!rise) {
            this.reverse();
        }
    }

    @Override
    public void reverse() throws XDataException {
        int start = 0;
        for (int end = this.count - 1; start < end; ++start, --end) {
            int tmp = this.m_val[start];
            this.m_val[start] = this.m_val[end];
            this.m_val[end] = tmp;
        }
    }

    public void append(int value) {
        if (this.count >= this.m_val.length) {
            this.expendsCapacity(this.count + 1);
        }
        this.m_val[this.count++] = value;
    }

    @Override
    public void setValue(int index, int val) throws XDataException {
        if (index >= this.count) {
            this.expendsCapacity(index + 1);
            this.count = index + 1;
        }
        this.m_val[index] = val;
    }

    @Override
    public void setValue(int index, long value) throws XDataException {
        this.setValue(index, (int)value);
    }

    @Override
    public void setValue(int index, float value) throws XDataException {
        this.setValue(index, (int)value);
    }

    @Override
    public void setValue(int index, double value) throws XDataException {
        this.setValue(index, (int)value);
    }

    @Override
    public void setValue(int index, String value) throws XDataException {
        try {
            this.setValue(index, Integer.parseInt(value));
        }
        catch (Exception e) {
            try {
                this.setValue(index, Double.parseDouble(value));
            }
            catch (Exception e1) {
                XIntegerSet.error("VALUE_CANT_TO_TYPE", new Object[]{value, this.getTypeName()});
            }
        }
    }

    @Override
    public void setValue(int index, boolean value) throws XDataException {
        this.setValue(index, value ? 1 : 0);
    }

    @Override
    public void setValue(int index, Node value) throws XDataException {
        XNode xn = new XNode(value);
        this.setValue(index, xn.intValue());
    }

    @Override
    public void setValue(int index, XData value) throws XDataException {
        this.setValue(index, value.intValue());
    }

    @Override
    public synchronized void expendsCapacity(int minCapacity) {
        int oldCapacity = this.m_val.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.m_val;
            int newCapacity = XIntegerSet.expectCapacity(oldCapacity, minCapacity);
            this.m_val = new int[newCapacity];
            System.arraycopy(oldData, 0, this.m_val, 0, this.count);
        }
    }

    @Override
    public XDataSet extendDataSet(int length) {
        int[] result = new int[length];
        if (this.count > 0) {
            int size;
            for (int k = 0; k < length; k += size) {
                size = length - k < this.count ? length - k : this.count;
                System.arraycopy(this.m_val, 0, result, k, size);
            }
        }
        return new XIntegerSet(result);
    }
}

