/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.TypeRefrance;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XDoubleSet;
import com.argo21.common.lang.XFloat;
import com.argo21.common.lang.XFloatSet;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XLong;
import com.argo21.common.lang.XLongSet;
import java.lang.reflect.Method;

public final class XMath {
    public static final int METHOD_ABS = 257;
    public static final int METHOD_ACOS = 258;
    public static final int METHOD_ASIN = 259;
    public static final int METHOD_ATAN = 260;
    public static final int METHOD_ATAN2 = 261;
    public static final int METHOD_CEIL = 262;
    public static final int METHOD_COS = 263;
    public static final int PROPERTY_E = 264;
    public static final int METHOD_EXP = 265;
    public static final int METHOD_FLOOR = 272;
    public static final int PROPERTY_LN10 = 273;
    public static final int PROPERTY_LN2 = 274;
    public static final int METHOD_LOG = 275;
    public static final int PROPERTY_LOG10E = 276;
    public static final int PROPERTY_LOG2E = 277;
    public static final int METHOD_MAX = 278;
    public static final int METHOD_MIN = 279;
    public static final int PROPERTY_PI = 280;
    public static final int METHOD_POW = 281;
    public static final int METHOD_RANDOM = 288;
    public static final int METHOD_ROUND = 289;
    public static final int METHOD_SIN = 290;
    public static final int METHOD_SQRT = 291;
    public static final int PROPERTY_SQRT1_2 = 292;
    public static final int PROPERTY_SQRT2 = 293;
    public static final int METHOD_TAN = 294;

    public static void registObject() {
        Class<XMath> cls = XMath.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Math");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        TypeRefrance typed = new TypeRefrance(XDouble.class);
        od.addMethodDeclaration("abs", md, String.valueOf(257), typed, 1, true);
        od.addMethodDeclaration("acos", md, String.valueOf(258), typed, 1, true);
        od.addMethodDeclaration("asin", md, String.valueOf(259), typed, 1, true);
        od.addMethodDeclaration("atan", md, String.valueOf(260), typed, 1, true);
        od.addMethodDeclaration("atan2", md, String.valueOf(261), typed, 2, true);
        od.addMethodDeclaration("ceil", md, String.valueOf(262), typed, 1, true);
        od.addMethodDeclaration("cos", md, String.valueOf(263), typed, 1, true);
        od.addPropertyDeclaration("E", md, String.valueOf(264), XDouble.class, false, false, true);
        od.addMethodDeclaration("exp", md, String.valueOf(265), typed, 1, true);
        od.addMethodDeclaration("floor", md, String.valueOf(272), typed, 1, true);
        od.addPropertyDeclaration("LN10", md, String.valueOf(273), XDouble.class, false, false, true);
        od.addPropertyDeclaration("LN2", md, String.valueOf(274), XDouble.class, false, false, true);
        od.addMethodDeclaration("log", md, String.valueOf(275), typed, 1, true);
        od.addPropertyDeclaration("LOG10E", md, String.valueOf(276), XDouble.class, false, false, true);
        od.addPropertyDeclaration("LOG2E", md, String.valueOf(277), XDouble.class, false, false, true);
        od.addMethodDeclaration("max", md, String.valueOf(278), typed, 2, true);
        od.addMethodDeclaration("min", md, String.valueOf(279), typed, 2, true);
        od.addPropertyDeclaration("PI", md, String.valueOf(280), XDouble.class, false, false, true);
        od.addMethodDeclaration("pow", md, String.valueOf(281), typed, 2, true);
        od.addMethodDeclaration("random", md, String.valueOf(288), typed, 0, true);
        od.addMethodDeclaration("round", md, String.valueOf(289), typed, 1, true);
        od.addMethodDeclaration("sin", md, String.valueOf(290), typed, 1, true);
        od.addMethodDeclaration("sqrt", md, String.valueOf(291), typed, 1, true);
        od.addPropertyDeclaration("SQRT1_2", md, String.valueOf(292), XDouble.class, false, false, true);
        od.addPropertyDeclaration("SQRT2", md, String.valueOf(293), XDouble.class, false, false, true);
        od.addMethodDeclaration("tan", md, String.valueOf(294), typed, 1, true);
    }

    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (idd) {
            case 257: {
                return this.abs(parameters[0]);
            }
            case 258: {
                return this.acos(parameters[0]);
            }
            case 259: {
                return this.asin(parameters[0]);
            }
            case 260: {
                return this.atan(parameters[0]);
            }
            case 261: {
                return this.atan2(parameters[0], parameters[1]);
            }
            case 262: {
                return this.ceil(parameters[0]);
            }
            case 263: {
                return this.cos(parameters[0]);
            }
            case 265: {
                return this.exp(parameters[0]);
            }
            case 272: {
                return this.floor(parameters[0]);
            }
            case 275: {
                return this.log(parameters[0]);
            }
            case 278: {
                return this.max(parameters[0], parameters[1]);
            }
            case 279: {
                return this.min(parameters[0], parameters[1]);
            }
            case 281: {
                return this.pow(parameters[0], parameters[1]);
            }
            case 288: {
                return new XDouble(Math.random());
            }
            case 289: {
                return this.round(parameters[0]);
            }
            case 290: {
                return this.sin(parameters[0]);
            }
            case 291: {
                return this.sqrt(parameters[0]);
            }
            case 294: {
                return this.tan(parameters[0]);
            }
            case 264: {
                return new XDouble(Math.E);
            }
            case 273: {
                return new XDouble(Math.log(10.0));
            }
            case 274: {
                return new XDouble(Math.log(2.0));
            }
            case 276: {
                return new XDouble(1.0 / Math.log(10.0));
            }
            case 277: {
                return new XDouble(1.0 / Math.log(2.0));
            }
            case 280: {
                return new XDouble(Math.PI);
            }
            case 292: {
                return new XDouble(Math.sqrt(2.0) / 2.0);
            }
            case 293: {
                return new XDouble(Math.sqrt(2.0));
            }
        }
        throw new NoSuchMethodException();
    }

    private XData abs(XData data) throws XDataException {
        int dim = data.getDimension();
        int type = data.getPrimitiveType();
        if (dim == 0) {
            switch (type) {
                case 1: {
                    return new XInteger(Math.abs(data.intValue()));
                }
                case 2: {
                    return new XLong(Math.abs(data.longValue()));
                }
                case 3: {
                    return new XFloat(Math.abs(data.floatValue()));
                }
            }
            return new XDouble(Math.abs(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            if (type == 1) {
                int[] res = new int[n];
                for (int i = 0; i < n; ++i) {
                    res[i] = Math.abs(data.intValue(i));
                }
                return new XIntegerSet(res);
            }
            if (type == 2) {
                long[] res = new long[n];
                for (int i = 0; i < n; ++i) {
                    res[i] = Math.abs(data.longValue(i));
                }
                return new XLongSet(res);
            }
            if (type == 3) {
                float[] res = new float[n];
                for (int i = 0; i < n; ++i) {
                    res[i] = Math.abs(data.floatValue(i));
                }
                return new XFloatSet(res);
            }
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.abs(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.abs");
        return null;
    }

    private XData acos(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.acos(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.acos(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.acos");
        return null;
    }

    private XData asin(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.asin(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.asin(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.asin");
        return null;
    }

    private XData atan(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.atan(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.atan(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.atan");
        return null;
    }

    private XData atan2(XData data1, XData data2) throws XDataException {
        int dim2;
        int dim;
        int dim1 = data1.getDimension();
        int n = dim = dim1 > (dim2 = data2.getDimension()) ? dim1 : dim2;
        if (dim == 0) {
            return new XDouble(Math.atan2(data1.doubleValue(), data2.doubleValue()));
        }
        if (dim == 1) {
            int n2;
            int n1 = data1.size();
            int n3 = n1 > (n2 = data2.size()) ? n1 : n2;
            double[] res = new double[n3];
            for (int i = 0; i < n3; ++i) {
                res[i] = Math.atan2(data1.doubleValue(i), data2.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.atan2");
        return null;
    }

    private XData ceil(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.ceil(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.ceil(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.ceil");
        return null;
    }

    private XData cos(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.cos(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.cos(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.cos");
        return null;
    }

    private XData exp(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.exp(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.exp(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.exp");
        return null;
    }

    private XData floor(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.floor(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.floor(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.floor");
        return null;
    }

    private XData log(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.log(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.log(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.log");
        return null;
    }

    private XData max(XData data1, XData data2) throws XDataException {
        int type;
        int dim2;
        int dim1 = data1.getDimension();
        int dim = dim1 > (dim2 = data2.getDimension()) ? dim1 : dim2;
        int type1 = data1.getPrimitiveType();
        int type2 = data2.getPrimitiveType();
        int n = type = type1 > type2 ? type1 : type2;
        if (dim == 0) {
            switch (type) {
                case 1: {
                    return new XInteger(Math.max(data1.intValue(), data2.intValue()));
                }
                case 2: {
                    return new XLong(Math.max(data1.longValue(), data2.longValue()));
                }
                case 3: {
                    return new XFloat(Math.max(data1.floatValue(), data2.floatValue()));
                }
            }
            return new XDouble(Math.max(data1.doubleValue(), data2.doubleValue()));
        }
        if (dim == 1) {
            int n2;
            int n3;
            int n1 = data1.size();
            int n4 = n3 = n1 > (n2 = data2.size()) ? n1 : n2;
            if (type == 1) {
                int[] res = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    res[i] = Math.max(data1.intValue(i), data2.intValue(i));
                }
                return new XIntegerSet(res);
            }
            if (type == 2) {
                long[] res = new long[n3];
                for (int i = 0; i < n3; ++i) {
                    res[i] = Math.max(data1.longValue(i), data2.longValue(i));
                }
                return new XLongSet(res);
            }
            if (type == 3) {
                float[] res = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    res[i] = Math.max(data1.floatValue(i), data2.floatValue(i));
                }
                return new XFloatSet(res);
            }
            double[] res = new double[n3];
            for (int i = 0; i < n3; ++i) {
                res[i] = Math.max(data1.doubleValue(i), data2.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.max");
        return null;
    }

    private XData min(XData data1, XData data2) throws XDataException {
        int type;
        int dim2;
        int dim1 = data1.getDimension();
        int dim = dim1 > (dim2 = data2.getDimension()) ? dim1 : dim2;
        int type1 = data1.getPrimitiveType();
        int type2 = data2.getPrimitiveType();
        int n = type = type1 > type2 ? type1 : type2;
        if (dim == 0) {
            switch (type) {
                case 1: {
                    return new XInteger(Math.min(data1.intValue(), data2.intValue()));
                }
                case 2: {
                    return new XLong(Math.min(data1.longValue(), data2.longValue()));
                }
                case 3: {
                    return new XFloat(Math.min(data1.floatValue(), data2.floatValue()));
                }
            }
            return new XDouble(Math.min(data1.doubleValue(), data2.doubleValue()));
        }
        if (dim == 1) {
            int n2;
            int n3;
            int n1 = data1.size();
            int n4 = n3 = n1 > (n2 = data2.size()) ? n1 : n2;
            if (type == 1) {
                int[] res = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    res[i] = Math.min(data1.intValue(i), data2.intValue(i));
                }
                return new XIntegerSet(res);
            }
            if (type == 2) {
                long[] res = new long[n3];
                for (int i = 0; i < n3; ++i) {
                    res[i] = Math.min(data1.longValue(i), data2.longValue(i));
                }
                return new XLongSet(res);
            }
            if (type == 3) {
                float[] res = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    res[i] = Math.min(data1.floatValue(i), data2.floatValue(i));
                }
                return new XFloatSet(res);
            }
            double[] res = new double[n3];
            for (int i = 0; i < n3; ++i) {
                res[i] = Math.min(data1.doubleValue(i), data2.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.min");
        return null;
    }

    private XData pow(XData data1, XData data2) throws XDataException {
        int dim2;
        int dim;
        int dim1 = data1.getDimension();
        int n = dim = dim1 > (dim2 = data2.getDimension()) ? dim1 : dim2;
        if (dim == 0) {
            return new XDouble(Math.pow(data1.doubleValue(), data2.doubleValue()));
        }
        if (dim == 1) {
            int n2;
            int n1 = data1.size();
            int n3 = n1 > (n2 = data2.size()) ? n1 : n2;
            double[] res = new double[n3];
            for (int i = 0; i < n3; ++i) {
                res[i] = Math.pow(data1.doubleValue(i), data2.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.pow");
        return null;
    }

    private XData round(XData data) throws XDataException {
        int dim = data.getDimension();
        int type = data.getPrimitiveType();
        if (dim == 0) {
            if (type <= 3) {
                return new XInteger(Math.round(data.floatValue()));
            }
            return new XLong(Math.round(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            if (type <= 3) {
                int[] res = new int[n];
                for (int i = 0; i < n; ++i) {
                    res[i] = Math.round(data.floatValue());
                }
                return new XIntegerSet(res);
            }
            long[] res = new long[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.round(data.doubleValue());
            }
            return new XLongSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.round");
        return null;
    }

    private XData sin(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.sin(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.sin(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.sin");
        return null;
    }

    private XData sqrt(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.sqrt(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.sqrt(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.sqrt");
        return null;
    }

    private XData tan(XData data) throws XDataException {
        int dim = data.getDimension();
        if (dim == 0) {
            return new XDouble(Math.tan(data.doubleValue()));
        }
        if (dim == 1) {
            int n = data.size();
            double[] res = new double[n];
            for (int i = 0; i < n; ++i) {
                res[i] = Math.tan(data.doubleValue(i));
            }
            return new XDoubleSet(res);
        }
        XData.error("FIRST_OVER_DIM1", "Math.tan");
        return null;
    }

    public String getTypeName() {
        return "Math";
    }
}

