/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.BaseDataViewer;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XDataViewer;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringFormat;
import com.argo21.common.lang.XVoid;
import com.argo21.jxp.parser.XmlParser;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XNode
extends XData {
    static String[] NODE_TYPE_STRING = new String[]{"non", "element", "attribute", "text", "cdata", "entity", "entity_ref", "pi", "comment", "document", "document_type", "document_fragment", "notation"};
    public static final int METHOD_GETNODENAME = 257;
    public static final int METHOD_GETNODEVALUE = 258;
    public static final int METHOD_GETNODETYPE = 259;
    public static final int METHOD_GETNODETYPENAME = 260;
    public static final int METHOD_GETPARENTNODE = 261;
    public static final int METHOD_GETCHILDNODES = 262;
    public static final int METHOD_GETFIRSTNODE = 263;
    public static final int METHOD_GETLASTNODE = 264;
    public static final int METHOD_GETPREVIOUSSIBLING = 265;
    public static final int METHOD_GETNEXTSIBLING = 272;
    public static final int METHOD_GETATTRIBUTES = 273;
    public static final int METHOD_GETOWNERDOCUMENT = 274;
    public static final int METHOD_SETNODEVALUE = 275;
    public static final int METHOD_INSERTBEFORE = 276;
    public static final int METHOD_REPLEACECHILD = 277;
    public static final int METHOD_REMOVECHILD = 278;
    public static final int METHOD_APPENDCHILD = 279;
    public static final int METHOD_HASCHILDNODES = 280;
    public static final int METHOD_CLONENODE = 281;
    public static final int METHOD_CREATENODE = 288;
    public static final int METHOD_GETVALUE = 289;
    public static final int METHOD_TRIM = 290;
    public static final int METHOD_SUPPRESSZERO = 291;
    public static final int METHOD_PADDINGZERO = 292;
    public static final int METHOD_ADDDATEDELIMITER = 293;
    public static final int METHOD_DELETEDATEDELIMITER = 294;
    public static final int METHOD_ADDDECIMALPOINT = 295;
    public static final int METHOD_DELETEDECIMALPOINT = 296;
    protected Node m_val;
    protected DataTypeDecl typeDecl;

    public static void registNodeType(int type, String typeName) {
        if (type >= NODE_TYPE_STRING.length) {
            String[] tmp = NODE_TYPE_STRING;
            NODE_TYPE_STRING = new String[type + 1];
            System.arraycopy(tmp, 0, NODE_TYPE_STRING, 0, tmp.length);
        }
        XNode.NODE_TYPE_STRING[type] = typeName;
    }

    public static void registObject() {
        Class<XNode> cls = XNode.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Node");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("getNodeName", md, String.valueOf(257), XString.class);
        od.addMethodDeclaration("getNodeValue", md, String.valueOf(258), XString.class);
        od.addMethodDeclaration("getNodeType", md, String.valueOf(259), XInteger.class);
        od.addMethodDeclaration("getNodeTypeName", md, String.valueOf(260), XString.class);
        od.addMethodDeclaration("getParentNode", md, String.valueOf(261), cls);
        od.addMethodDeclaration("getChildNodes", md, String.valueOf(262), XNodeSet.class);
        od.addMethodDeclaration("getFirstChild", md, String.valueOf(263), cls);
        od.addMethodDeclaration("getLastChild", md, String.valueOf(264), cls);
        od.addMethodDeclaration("getPreviousSibling", md, String.valueOf(265), cls);
        od.addMethodDeclaration("getNextSibling", md, String.valueOf(272), cls);
        od.addMethodDeclaration("getAttributes", md, String.valueOf(273), XNodeSet.class);
        od.addMethodDeclaration("getOwnerDocument", md, String.valueOf(274), cls);
        od.addMethodDeclaration("setNodeValue", md, String.valueOf(275), XVoid.class, 1);
        od.addMethodDeclaration("insertBefore", md, String.valueOf(276), cls, 2);
        od.addMethodDeclaration("replaceChild", md, String.valueOf(277), cls, 2);
        od.addMethodDeclaration("removeChild", md, String.valueOf(278), cls, 1);
        od.addMethodDeclaration("appendChild", md, String.valueOf(279), cls, 1);
        od.addMethodDeclaration("hasChildNodes", md, String.valueOf(280), XBoolean.class);
        od.addMethodDeclaration("cloneNode", md, String.valueOf(281), cls, 1);
        od.addMethodDeclaration("createNode", md, String.valueOf(288), cls, 2);
        od.addMethodDeclaration("getValue", md, String.valueOf(289), XData.class);
        od.addMethodDeclaration("sum", md, String.valueOf(9), XDouble.class);
        od.addMethodDeclaration("average", md, String.valueOf(10), XDouble.class);
        od.addMethodDeclaration("trim", md, String.valueOf(290), XData.class);
        od.addMethodDeclaration("suppressZero", md, String.valueOf(291), XData.class);
        od.addMethodDeclaration("paddingZero", md, String.valueOf(292), XData.class, 1);
        od.addMethodDeclaration("addDateDelimiter", md, String.valueOf(293), XData.class, 1);
        od.addMethodDeclaration("deleteDateDelimiter", md, String.valueOf(294), XData.class, 1);
        od.addMethodDeclaration("addDecimalPoint", md, String.valueOf(295), XData.class, 1);
        od.addMethodDeclaration("deleteDecimalPoint", md, String.valueOf(296), XData.class, 1);
    }

    @Override
    public boolean isEmpty() {
        if (this.m_val == null) {
            return true;
        }
        int type = this.typeDecl == null ? 6 : this.typeDecl.getType();
        try {
            XData dd = this.castToType(type);
            return dd == null || dd.isEmpty();
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
        switch (idd) {
            case 257: {
                return new XString(this.m_val.getNodeName());
            }
            case 258: {
                return new XString(this.m_val.getNodeValue());
            }
            case 259: {
                return new XInteger(this.m_val.getNodeType());
            }
            case 260: {
                return new XString(NODE_TYPE_STRING[this.m_val.getNodeType()]);
            }
            case 261: {
                return new XNode(this.m_val.getParentNode());
            }
            case 262: {
                return new XNodeSet(this.m_val.getChildNodes());
            }
            case 263: {
                return new XNode(this.m_val.getFirstChild());
            }
            case 264: {
                return new XNode(this.m_val.getLastChild());
            }
            case 265: {
                return new XNode(this.m_val.getPreviousSibling());
            }
            case 272: {
                return new XNode(this.m_val.getNextSibling());
            }
            case 273: {
                NamedNodeMap nodes = this.m_val.getAttributes();
                int n = nodes.getLength();
                XNodeSet res = new XNodeSet();
                for (int i = 0; i < n; ++i) {
                    res.setValue(i, nodes.item(i));
                }
                return res;
            }
            case 274: {
                return new XNode(this.m_val.getOwnerDocument());
            }
            case 275: {
                this.m_val.setNodeValue(parameters[0].stringValue());
                return XData.XVOID;
            }
            case 276: {
                return new XNode(this.m_val.insertBefore(parameters[0].nodeValue(), parameters[1].nodeValue()));
            }
            case 277: {
                return new XNode(this.m_val.replaceChild(parameters[0].nodeValue(), parameters[1].nodeValue()));
            }
            case 278: {
                return new XNode(this.m_val.removeChild(parameters[0].nodeValue()));
            }
            case 279: {
                return new XNode(this.m_val.appendChild(parameters[0].nodeValue()));
            }
            case 280: {
                return new XBoolean(this.m_val.hasChildNodes());
            }
            case 281: {
                return new XNode(this.m_val.cloneNode(parameters[0].booleanValue()));
            }
            case 9: 
            case 10: {
                int type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                XData dd = this.castToType(type);
                return dd.invoke(id2, new XData[0]);
            }
            case 289: {
                int type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                return this.castToType(type);
            }
            case 288: {
                Document doc = this.m_val.getOwnerDocument();
                int type = 0;
                if (parameters[0].isNumber()) {
                    type = parameters[0].intValue();
                } else {
                    String s = parameters[0].stringValue();
                    for (int i = 1; i < NODE_TYPE_STRING.length; ++i) {
                        if (!NODE_TYPE_STRING[i].equals(s)) continue;
                        type = i;
                        break;
                    }
                }
                String value = parameters[1].stringValue();
                Node node = null;
                if (type == 1) {
                    node = doc.createElement(value);
                } else if (type == 2) {
                    node = doc.createAttribute(value);
                } else if (type == 3) {
                    node = doc.createTextNode(value);
                } else if (type == 8) {
                    node = doc.createComment(value);
                } else if (type == 5) {
                    node = doc.createEntityReference(value);
                } else if (type == 7) {
                    node = doc.createEntityReference(value);
                } else if (type == 4) {
                    node = doc.createProcessingInstruction(value, "");
                } else if (type == 11) {
                    node = doc.createDocumentFragment();
                } else {
                    XData.error("INVALID_PARAMETER", new Object[]{"createNode", "1"}, true);
                }
                return new XNode(node);
            }
            case 290: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    return new XString(XStringFormat.trim(this.stringValue()));
                }
                return this.castToType(type);
            }
            case 291: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    return new XString(XStringFormat.suppressZero(this.stringValue()));
                }
                return this.castToType(type);
            }
            case 292: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    return new XString(XStringFormat.paddingZero(this.stringValue(), parameters[0].intValue()));
                }
                return this.castToType(type);
            }
            case 293: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    return new XString(XStringFormat.addDateDelimiter(this.stringValue(), parameters[0].stringValue()));
                }
                return this.castToType(type);
            }
            case 294: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    return new XString(XStringFormat.deleteDateDelimiter(this.stringValue(), parameters[0].stringValue()));
                }
                return this.castToType(type);
            }
            case 295: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    return new XString(XStringFormat.addDecimalPoint(this.stringValue(), parameters[0].intValue()));
                }
                return this.castToType(type);
            }
            case 296: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    return new XString(XStringFormat.deleteDecimalPoint(this.stringValue(), parameters[0].intValue()));
                }
                return this.castToType(type);
            }
        }
        return super.invoke(id2, parameters);
    }

    public XNode(Node val) {
        this.m_val = val;
    }

    @Override
    public int getType() {
        return 18;
    }

    @Override
    public String getTypeName() {
        return "Node";
    }

    @Override
    public int getPrimitiveType() {
        if (this.typeDecl != null) {
            return this.typeDecl.getType();
        }
        return 6;
    }

    public void setTypeDecl(DataTypeDecl typeDecl) {
        this.typeDecl = typeDecl;
    }

    public DataTypeDecl getTypeDecl() {
        return this.typeDecl;
    }

    @Override
    public double doubleValue() throws XDataException {
        String s = this.stringValue0();
        try {
            return this.typeDecl != null ? this.typeDecl.doubleValue(s) : Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    @Override
    public long longValue() throws XDataException {
        String s = this.stringValue0();
        try {
            return this.typeDecl != null ? this.typeDecl.longValue(s) : Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    @Override
    public float floatValue() throws XDataException {
        String s = this.stringValue0();
        try {
            return this.typeDecl != null ? this.typeDecl.floatValue(s) : Float.parseFloat(s);
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    @Override
    public int intValue() throws XDataException {
        String s = this.stringValue0();
        try {
            return this.typeDecl != null ? this.typeDecl.intValue(s) : Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public Node nodeValue() {
        return this.m_val;
    }

    @Override
    public String stringValue() {
        String s = this.stringValue0();
        return this.typeDecl != null ? this.typeDecl.stringValue(s) : s;
    }

    private String stringValue0() {
        switch (this.m_val.getNodeType()) {
            case 1: 
            case 9: {
                return XmlParser.getElementText(this.m_val);
            }
            case 3: 
            case 4: {
                return ((Text)this.m_val).getData();
            }
            case 2: 
            case 7: 
            case 8: {
                return this.m_val.getNodeValue();
            }
        }
        return this.m_val.getNodeValue();
    }

    @Override
    public Object objectValue() {
        return this.m_val;
    }

    @Override
    public boolean booleanValue() throws XDataException {
        String s = this.stringValue();
        try {
            return this.typeDecl != null ? this.typeDecl.booleanValue(s) : Boolean.valueOf(s.trim()).booleanValue();
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Override
    public Date dateValue() throws XDataException {
        String s = this.stringValue0();
        try {
            return this.typeDecl != null ? this.typeDecl.dateValue(s) : new Date(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public void setValue(int value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        XNode.setNodeData(this.m_val, s);
    }

    @Override
    public void setValue(long value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        XNode.setNodeData(this.m_val, s);
    }

    @Override
    public void setValue(float value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        XNode.setNodeData(this.m_val, s);
    }

    @Override
    public void setValue(double value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        XNode.setNodeData(this.m_val, s);
    }

    @Override
    public void setValue(String value) throws XDataException {
        String s;
        if (this.typeDecl != null) {
            if (this.typeDecl.isReal()) {
                double doubleValue = Double.parseDouble(value);
                s = this.typeDecl.formatValue(doubleValue);
            } else if (this.typeDecl.isInteger()) {
                long longValue = 0L;
                try {
                    longValue = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    longValue = (long)Double.parseDouble(value);
                }
                s = this.typeDecl.formatValue(longValue);
            } else if (this.typeDecl.type == 5) {
                Boolean bool = Boolean.valueOf(value);
                s = this.typeDecl.formatValue(bool);
            } else {
                s = value;
            }
        } else {
            s = value;
        }
        XNode.setNodeData(this.m_val, s);
    }

    @Override
    public void setValue(boolean value) throws XDataException {
        this.setValue(String.valueOf(value));
    }

    @Override
    public void setValue(Date value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : (value != null ? DateFormat.getDateTimeInstance().format(value) : "");
        XNode.setNodeData(this.m_val, s);
    }

    @Override
    public void setValue(Node value) throws XDataException {
        this.m_val = value;
    }

    @Override
    public void setValue(Object value) throws XDataException {
        this.setValue(value.toString());
    }

    @Override
    public void setValue(XData value) throws XDataException {
        if (value.isNode()) {
            this.setValue(value.nodeValue());
        } else {
            this.setValue(value.stringValue());
        }
    }

    public static void getNodeData(Node node, StringBuffer buf) {
        Object data = null;
        switch (node.getNodeType()) {
            case 11: {
                NodeList mnl = node.getChildNodes();
                int n = mnl.getLength();
                for (int i = 0; i < n; ++i) {
                    XNode.getNodeData(mnl.item(i), buf);
                }
                break;
            }
            case 1: 
            case 9: {
                for (Node child = node.getFirstChild(); null != child; child = child.getNextSibling()) {
                    XNode.getNodeData(child, buf);
                }
                break;
            }
            case 3: 
            case 4: {
                buf.append(((Text)node).getData());
                break;
            }
            case 2: {
                buf.append(node.getNodeValue());
                break;
            }
            case 7: {
                break;
            }
        }
    }

    public static void setNodeData(Node node, String value) {
        Object data = null;
        switch (node.getNodeType()) {
            case 11: {
                NodeList mnl = node.getChildNodes();
                int n = mnl.getLength();
                for (int i = 0; i < n; ++i) {
                    XNode.setNodeData(mnl.item(i), value);
                }
                break;
            }
            case 1: {
                XmlParser.setElementText(node, value);
                break;
            }
            case 3: 
            case 4: {
                ((Text)node).setData(value);
                break;
            }
            case 2: {
                node.setNodeValue(value);
                break;
            }
        }
    }

    @Override
    public NodeList nodeset() {
        return new NodeListImpl(this.m_val);
    }

    public NodeList mutableNodeset() {
        return new NodeListImpl(this.m_val);
    }

    @Override
    public boolean lessThan(XData obj2) throws XDataException {
        boolean isLT = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) >= 0) continue;
                isLT = true;
                break;
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isLT = num1 < num2;
        } else if (obj2.isNumber()) {
            int len = obj2.size();
            double num1 = this.doubleValue();
            for (int i = 0; i < len; ++i) {
                double num2 = obj2.doubleValue(i);
                if (!(num1 < num2)) continue;
                isLT = true;
                break;
            }
        } else if (obj2.isString()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) >= 0) continue;
                isLT = true;
                break;
            }
        } else {
            isLT = this.doubleValue() < obj2.doubleValue();
        }
        return isLT;
    }

    @Override
    public boolean lessThanOrEqual(XData obj2) throws XDataException {
        boolean isLTE = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) > 0) continue;
                isLTE = true;
                break;
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isLTE = num1 <= num2;
        } else if (obj2.isNumber()) {
            int len = obj2.size();
            double num1 = this.doubleValue();
            for (int i = 0; i < len; ++i) {
                double num2 = obj2.doubleValue(i);
                if (!(num1 <= num2)) continue;
                isLTE = true;
                break;
            }
        } else if (obj2.isString()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) > 0) continue;
                isLTE = true;
                break;
            }
        } else {
            isLTE = this.doubleValue() <= obj2.doubleValue();
        }
        return isLTE;
    }

    @Override
    public boolean greaterThan(XData obj2) throws XDataException {
        boolean isGT = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) <= 0) continue;
                isGT = true;
                break;
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isGT = num1 > num2;
        } else if (obj2.isNumber()) {
            int len = obj2.size();
            double num1 = this.doubleValue();
            for (int i = 0; i < len; ++i) {
                double num2 = obj2.doubleValue(i);
                if (!(num1 > num2)) continue;
                isGT = true;
                break;
            }
        } else if (obj2.isString()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) <= 0) continue;
                isGT = true;
                break;
            }
        } else {
            isGT = this.doubleValue() > obj2.doubleValue();
        }
        return isGT;
    }

    @Override
    public boolean greaterThanOrEqual(XData obj2) throws XDataException {
        boolean isGTE = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) < 0) continue;
                isGTE = true;
                break;
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isGTE = num1 >= num2;
        } else if (obj2.isNumber()) {
            int len = obj2.size();
            double num1 = this.doubleValue();
            for (int i = 0; i < len; ++i) {
                double num2 = obj2.doubleValue(i);
                if (!(num1 >= num2)) continue;
                isGTE = true;
                break;
            }
        } else if (obj2.isString()) {
            int len = obj2.size();
            String s1 = this.stringValue();
            for (int i = 0; i < len; ++i) {
                String s2 = obj2.stringValue(i);
                if (s1.compareTo(s2) < 0) continue;
                isGTE = true;
                break;
            }
        } else {
            isGTE = this.doubleValue() >= obj2.doubleValue();
        }
        return isGTE;
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        boolean isEqual = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list2 = obj2.nodeset();
            int len2 = list2.getLength();
            String s1 = this.stringValue();
            for (int k = 0; k < len2; ++k) {
                String s2 = XNode.getStringFromNode(list2.item(k));
                if (!s2.equals(s1)) continue;
                isEqual = true;
                break;
            }
        } else if (obj2.isBoolean()) {
            isEqual = this.booleanValue() == obj2.booleanValue();
        } else if (obj2.isNumber()) {
            int len2 = obj2.size();
            double num1 = this.doubleValue();
            for (int k = 0; k < len2; ++k) {
                double num2 = obj2.doubleValue(k);
                if (num1 != num2) continue;
                isEqual = true;
                break;
            }
        } else if (obj2.isString()) {
            int len2 = obj2.size();
            String s1 = this.stringValue();
            for (int k = 0; k < len2; ++k) {
                String s2 = obj2.stringValue();
                if (!s1.equals(s2)) continue;
                isEqual = true;
                break;
            }
        } else {
            isEqual = super.equals(obj2);
        }
        return isEqual;
    }

    @Override
    public boolean notEquals(XData obj2) throws XDataException {
        boolean notEqual = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list2 = obj2.nodeset();
            int len2 = list2.getLength();
            String s1 = this.stringValue();
            for (int k = 0; k < len2; ++k) {
                String s2 = XNode.getStringFromNode(list2.item(k));
                if (s2.equals(s1)) continue;
                notEqual = true;
                break;
            }
        } else if (obj2.isBoolean()) {
            notEqual = this.booleanValue() != obj2.booleanValue();
        } else if (obj2.isNumber()) {
            int len2 = obj2.size();
            double num1 = this.doubleValue();
            for (int k = 0; k < len2; ++k) {
                double num2 = obj2.doubleValue(k);
                if (num1 == num2) continue;
                notEqual = true;
                break;
            }
        } else if (obj2.isString()) {
            int len2 = obj2.size();
            String s1 = this.stringValue();
            for (int k = 0; k < len2; ++k) {
                String s2 = obj2.stringValue();
                if (s1.equals(s2)) continue;
                notEqual = true;
                break;
            }
        } else {
            notEqual = super.notEquals(obj2);
        }
        return notEqual;
    }

    static String getStringFromNode(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 9: {
                StringBuffer buf = new StringBuffer();
                XNode.getNodeData(n, buf);
                return buf.length() > 0 ? buf.toString() : "";
            }
            case 3: 
            case 4: {
                return ((Text)n).getData();
            }
            case 2: 
            case 7: 
            case 8: {
                return n.getNodeValue();
            }
        }
        StringBuffer buf = new StringBuffer();
        XNode.getNodeData(n, buf);
        return buf.length() > 0 ? buf.toString() : "";
    }

    @Override
    public XDataSet extendDataSet(int length) {
        NodeListImpl nl = new NodeListImpl(length);
        for (int i = 0; i < length; ++i) {
            nl.addElement(this.m_val);
        }
        return new XNodeSet(nl);
    }

    public String getNodeTypeName() {
        return NODE_TYPE_STRING[this.m_val.getNodeType()];
    }

    public int getNodeType() {
        return this.m_val.getNodeType();
    }

    @Override
    public boolean hasChildenDataViewer() {
        return true;
    }

    @Override
    public XDataViewer[] getChildren() {
        if (this.m_val == null) {
            return new XDataViewer[0];
        }
        NamedNodeMap atts = this.m_val.getAttributes();
        NodeList list = this.m_val.getChildNodes();
        int n1 = atts == null ? 0 : atts.getLength();
        int n2 = list == null ? 0 : list.getLength();
        int n = 3;
        if (n1 > 0) {
            ++n;
        }
        if (n2 > 0) {
            ++n;
        }
        XDataViewer[] res = new XDataViewer[n];
        String stringType = XData.getTypeName(6);
        res[0] = new BaseDataViewer(stringType, "NodeType", this.getNodeTypeName());
        res[1] = new BaseDataViewer(stringType, "NodeName", this.m_val.getNodeName());
        res[2] = new BaseDataViewer(this.getPrimitiveTypeName(), "NodeValue", String.valueOf(this.m_val.getNodeValue()));
        int k = 3;
        if (n1 > 0) {
            XNodeSet attset = new XNodeSet();
            for (int i = 0; i < n1; ++i) {
                try {
                    attset.setValue(i, atts.item(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            res[k++] = new ChildernDataViewer("attribute", attset);
        }
        if (n2 > 0) {
            res[k++] = new ChildernDataViewer("children", new XNodeSet(list));
        }
        return res;
    }

    @Override
    public Object getEvalValue() {
        return "";
    }

    class ChildernDataViewer
    implements XDataViewer {
        String name;
        XNodeSet value;

        public ChildernDataViewer(String name2, XNodeSet value) {
            this.name = name2;
            this.value = value;
        }

        @Override
        public boolean hasChildenDataViewer() {
            return true;
        }

        @Override
        public XDataViewer[] getChildren() {
            return this.value.getChildren();
        }

        @Override
        public String getEvalType() {
            return "Node[]";
        }

        @Override
        public String getEvalName() {
            return this.name;
        }

        @Override
        public Object getEvalValue() {
            return "";
        }
    }
}

