/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.common.lang;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.IndexValue;
import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataSet;
import com.argo21.common.lang.XDataViewer;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XIntegerSet;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XStringFormat;
import com.argo21.common.lang.XStringSet;
import com.argo21.common.lang.XVoid;
import com.argo21.jxp.parser.XmlParser;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XNodeSet
extends XDataSet {
    protected NodeList m_val;
    protected DataTypeDecl typeDecl;

    public static void registObject() {
        Class<XNodeSet> cls = XNodeSet.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "Node[]");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("getNodeName", md, String.valueOf(257), XStringSet.class);
        od.addMethodDeclaration("getNodeValue", md, String.valueOf(258), XStringSet.class);
        od.addMethodDeclaration("getNodeType", md, String.valueOf(259), XIntegerSet.class);
        od.addMethodDeclaration("getNodeTypeName", md, String.valueOf(260), XStringSet.class);
        od.addMethodDeclaration("setNodeValue", md, String.valueOf(275), XVoid.class, 1);
        od.addMethodDeclaration("getValue", md, String.valueOf(289), XDataSet.class);
        od.addMethodDeclaration("sum", md, String.valueOf(9), XDouble.class);
        od.addMethodDeclaration("average", md, String.valueOf(10), XDouble.class);
        od.addMethodDeclaration("trim", md, String.valueOf(290), XDataSet.class);
        od.addMethodDeclaration("suppressZero", md, String.valueOf(291), XDataSet.class);
        od.addMethodDeclaration("paddingZero", md, String.valueOf(292), XDataSet.class, 1);
        od.addMethodDeclaration("addDateDelimiter", md, String.valueOf(293), XDataSet.class, 1);
        od.addMethodDeclaration("deleteDateDelimiter", md, String.valueOf(294), XDataSet.class, 1);
        od.addMethodDeclaration("addDecimalPoint", md, String.valueOf(295), XDataSet.class, 1);
        od.addMethodDeclaration("deleteDecimalPoint", md, String.valueOf(296), XDataSet.class, 1);
    }

    @Override
    public boolean isEmpty() {
        if (this.m_val == null) {
            return true;
        }
        int type = this.typeDecl == null ? 6 : this.typeDecl.getType();
        try {
            XData dd = this.castToType(type);
            return dd == null || dd.isEmpty();
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
        switch (idd) {
            case 257: {
                int n = this.size();
                String[] ss = new String[n];
                for (int i = 0; i < n; ++i) {
                    ss[i] = this.nodeValue(i).getNodeName();
                }
                return new XStringSet(ss);
            }
            case 258: {
                int n = this.size();
                String[] ss = new String[n];
                for (int i = 0; i < n; ++i) {
                    ss[i] = this.nodeValue(i).getNodeValue();
                }
                return new XStringSet(ss);
            }
            case 259: {
                int n = this.size();
                int[] types = new int[n];
                for (int i = 0; i < n; ++i) {
                    types[i] = this.nodeValue(i).getNodeType();
                }
                return new XIntegerSet(types);
            }
            case 260: {
                int n = this.size();
                String[] ss = new String[n];
                for (int i = 0; i < n; ++i) {
                    ss[i] = XNode.NODE_TYPE_STRING[this.nodeValue(i).getNodeType()];
                }
                return new XStringSet(ss);
            }
            case 275: {
                int n = this.size();
                String[] ss = new String[n];
                for (int i = 0; i < n; ++i) {
                    String s = parameters[0].stringValue(i);
                    this.nodeValue(i).setNodeValue(s);
                }
                return XData.XVOID;
            }
            case 9: {
                int type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                XData data = this.castToType(type);
                if (data instanceof XDataSet) {
                    return ((XDataSet)data).sum();
                }
                return data;
            }
            case 10: {
                int type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                XData data = this.castToType(type);
                if (data instanceof XDataSet) {
                    return ((XDataSet)data).average();
                }
                return data;
            }
            case 289: {
                int type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                return this.castToType(type);
            }
            case 290: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    String[] results = new String[this.size()];
                    for (int i = 0; i < this.size(); ++i) {
                        results[i] = XStringFormat.trim(this.stringValue(i));
                    }
                    return new XStringSet(results);
                }
                return this.castToType(type);
            }
            case 291: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    String[] results = new String[this.size()];
                    for (int i = 0; i < this.size(); ++i) {
                        results[i] = XStringFormat.suppressZero(this.stringValue(i));
                    }
                    return new XStringSet(results);
                }
                return this.castToType(type);
            }
            case 292: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    String[] results = new String[this.size()];
                    for (int i = 0; i < this.size(); ++i) {
                        results[i] = XStringFormat.paddingZero(this.stringValue(i), parameters[0].intValue());
                    }
                    return new XStringSet(results);
                }
                return this.castToType(type);
            }
            case 293: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    String[] results = new String[this.size()];
                    for (int i = 0; i < this.size(); ++i) {
                        results[i] = XStringFormat.addDateDelimiter(this.stringValue(i), parameters[0].stringValue());
                    }
                    return new XStringSet(results);
                }
                return this.castToType(type);
            }
            case 294: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    String[] results = new String[this.size()];
                    for (int i = 0; i < this.size(); ++i) {
                        results[i] = XStringFormat.deleteDateDelimiter(this.stringValue(i), parameters[0].stringValue());
                    }
                    return new XStringSet(results);
                }
                return this.castToType(type);
            }
            case 295: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    String[] results = new String[this.size()];
                    for (int i = 0; i < this.size(); ++i) {
                        results[i] = XStringFormat.addDecimalPoint(this.stringValue(i), parameters[0].intValue());
                    }
                    return new XStringSet(results);
                }
                return this.castToType(type);
            }
            case 296: {
                int type;
                int n = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
                if (type == 6) {
                    String[] results = new String[this.size()];
                    for (int i = 0; i < this.size(); ++i) {
                        results[i] = XStringFormat.deleteDecimalPoint(this.stringValue(i), parameters[0].intValue());
                    }
                    return new XStringSet(results);
                }
                return this.castToType(type);
            }
        }
        return super.invoke(id2, parameters);
    }

    @Override
    public void sort(boolean rise) throws XDataException {
        int i;
        int type;
        int n = this.size();
        int n2 = type = this.typeDecl == null ? 6 : this.typeDecl.getType();
        if (type == 1 || type == 2 || type == 5) {
            type = 2;
        } else if (type == 3 || type == 4) {
            type = 4;
        }
        Object[] indexValue = new IndexValue[n];
        if (type == 2) {
            for (i = 0; i < n; ++i) {
                indexValue[i] = new IndexValue(i, new Long(this.longValue(i)), rise);
            }
        } else if (type == 4) {
            for (i = 0; i < n; ++i) {
                indexValue[i] = new IndexValue(i, new Double(this.doubleValue(i)), rise);
            }
        } else if (type == 7) {
            for (i = 0; i < n; ++i) {
                indexValue[i] = new IndexValue(i, this.dateValue(i), rise);
            }
        } else {
            for (i = 0; i < n; ++i) {
                indexValue[i] = new IndexValue(i, (Comparable)((Object)this.stringValue(i)), rise);
            }
        }
        Arrays.sort(indexValue);
        NodeListImpl mnl = new NodeListImpl();
        for (int i2 = 0; i2 < n; ++i2) {
            mnl.addNode(this.nodeValue(((IndexValue)indexValue[i2]).getIndex()));
        }
        this.m_val = mnl;
    }

    @Override
    public void reverse() throws XDataException {
        int n = this.size();
        NodeListImpl mnl = new NodeListImpl();
        for (int i = 0; i < n; ++i) {
            mnl.addNode(this.m_val.item(n - i - 1));
        }
        this.m_val = mnl;
    }

    public XNodeSet() {
        this.m_val = new NodeListImpl();
        this.count = this.m_val.getLength();
    }

    public XNodeSet(Node[] nodes) {
        NodeListImpl nl = new NodeListImpl(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            nl.addElement(nodes[i]);
        }
        this.m_val = nl;
        this.count = this.m_val.getLength();
    }

    public XNodeSet(NodeList val) {
        this.m_val = val;
        this.count = val.getLength();
    }

    public XNodeSet(Node node) {
        NodeListImpl nl = new NodeListImpl();
        if (null != node) {
            nl.addNode(node);
            this.count = 1;
        }
        this.m_val = nl;
    }

    @Override
    public int getType() {
        return 274;
    }

    @Override
    public int getPrimitiveType() {
        if (this.typeDecl != null) {
            return this.typeDecl.getType();
        }
        return 6;
    }

    public void setTypeDecl(DataTypeDecl typeDecl) {
        this.typeDecl = typeDecl;
    }

    public DataTypeDecl getTypeDecl() {
        return this.typeDecl;
    }

    @Override
    public String getTypeName() {
        return "Node[]";
    }

    @Override
    public double doubleValue(int index) throws XDataException {
        if (index >= this.size()) {
            return this.typeDecl != null ? this.typeDecl.doubleValue() : 0.0;
        }
        String s = this.stringValue0(index);
        try {
            return this.typeDecl != null ? this.typeDecl.doubleValue(s) : Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    @Override
    public long longValue(int index) throws XDataException {
        if (index >= this.size()) {
            return this.typeDecl != null ? this.typeDecl.longValue() : 0L;
        }
        String s = this.stringValue0(index);
        try {
            return this.typeDecl != null ? this.typeDecl.longValue(s) : Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    @Override
    public float floatValue(int index) throws XDataException {
        if (index >= this.size()) {
            return this.typeDecl != null ? this.typeDecl.floatValue() : 0.0f;
        }
        String s = this.stringValue0(index);
        try {
            return this.typeDecl != null ? this.typeDecl.floatValue(s) : Float.parseFloat(s);
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    @Override
    public int intValue(int index) throws XDataException {
        if (index >= this.size()) {
            return this.typeDecl != null ? this.typeDecl.intValue() : 0;
        }
        String s = this.stringValue0(index);
        try {
            return this.typeDecl != null ? this.typeDecl.intValue(s) : Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public String stringValue(int index) {
        if (index >= this.size()) {
            return this.typeDecl != null ? this.typeDecl.stringValue() : "";
        }
        String s = this.stringValue0(index);
        return this.typeDecl != null ? this.typeDecl.stringValue(s) : s;
    }

    @Override
    public Date dateValue(int index) throws XDataException {
        if (index >= this.size()) {
            return this.typeDecl != null ? this.typeDecl.dateValue() : null;
        }
        String s = this.stringValue0(index);
        try {
            return this.typeDecl != null ? this.typeDecl.dateValue(s) : new Date(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private String stringValue0(int index) {
        NodeList nl = this.nodeset();
        Node node = nl.item(index);
        switch (node.getNodeType()) {
            case 1: 
            case 9: {
                return XmlParser.getElementText(node);
            }
            case 3: 
            case 4: {
                return ((Text)node).getData();
            }
            case 2: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return node.getNodeValue();
    }

    @Override
    public Object objectValue() {
        return this.m_val;
    }

    @Override
    public Object objectValue(int index) {
        return this.m_val.getLength() > 0 ? this.m_val.item(index) : null;
    }

    @Override
    public boolean booleanValue(int index) throws XDataException {
        if (index >= this.size()) {
            return this.typeDecl != null ? this.typeDecl.booleanValue() : false;
        }
        String s = this.stringValue0(index);
        return this.typeDecl != null ? this.typeDecl.booleanValue(s) : Boolean.valueOf(s.trim()).booleanValue();
    }

    @Override
    public Node nodeValue(int index) {
        return index >= 0 && index < this.m_val.getLength() ? this.m_val.item(index) : null;
    }

    public String getNodeName() {
        int n = this.m_val.getLength();
        if (n == 0) {
            return null;
        }
        String name2 = this.m_val.item(0).getNodeName();
        for (int i = 1; i < n; ++i) {
            if (this.m_val.item(i).getNodeName().equals(name2)) continue;
            return null;
        }
        return name2;
    }

    @Override
    public int size() {
        this.count = this.m_val.getLength();
        return this.count;
    }

    @Override
    public NodeList nodeset() {
        return this.m_val;
    }

    public NodeListImpl mutableNodeset() {
        NodeListImpl mnl;
        if (this.m_val instanceof NodeListImpl) {
            mnl = (NodeListImpl)this.m_val;
        } else {
            mnl = new NodeListImpl(this.nodeset());
            this.m_val = mnl;
        }
        return mnl;
    }

    @Override
    public boolean lessThan(XData obj2) throws XDataException {
        boolean isLT = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list1 = this.nodeset();
            NodeList list2 = obj2.nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            block0: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = XNode.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) >= 0) continue;
                    isLT = true;
                    continue block0;
                }
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isLT = num1 < num2;
        } else if (obj2.isNumber()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block2: for (int i = 0; i < len1; ++i) {
                double num1 = this.doubleValue(i);
                for (int k = 0; k < len2; ++k) {
                    double num2 = obj2.doubleValue(k);
                    if (!(num1 < num2)) continue;
                    isLT = true;
                    continue block2;
                }
            }
        } else if (obj2.isString()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block4: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = obj2.stringValue();
                    if (s1.compareTo(s2) >= 0) continue;
                    isLT = true;
                    continue block4;
                }
            }
        } else {
            isLT = this.doubleValue() < obj2.doubleValue();
        }
        return isLT;
    }

    @Override
    public boolean lessThanOrEqual(XData obj2) throws XDataException {
        boolean isLTE = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list1 = this.nodeset();
            NodeList list2 = obj2.nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            block0: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = XNode.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) > 0) continue;
                    isLTE = true;
                    continue block0;
                }
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isLTE = num1 <= num2;
        } else if (obj2.isNumber()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block2: for (int i = 0; i < len1; ++i) {
                double num1 = this.doubleValue(i);
                for (int k = 0; k < len2; ++k) {
                    double num2 = obj2.doubleValue(k);
                    if (!(num1 <= num2)) continue;
                    isLTE = true;
                    continue block2;
                }
            }
        } else if (obj2.isString()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block4: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = obj2.stringValue();
                    if (s1.compareTo(s2) > 0) continue;
                    isLTE = true;
                    continue block4;
                }
            }
        } else {
            isLTE = this.doubleValue() <= obj2.doubleValue();
        }
        return isLTE;
    }

    @Override
    public boolean greaterThan(XData obj2) throws XDataException {
        boolean isGT = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list1 = this.nodeset();
            NodeList list2 = obj2.nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            block0: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = XNode.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) <= 0) continue;
                    isGT = true;
                    continue block0;
                }
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isGT = num1 > num2;
        } else if (obj2.isNumber()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block2: for (int i = 0; i < len1; ++i) {
                double num1 = this.doubleValue(i);
                for (int k = 0; k < len2; ++k) {
                    double num2 = obj2.doubleValue(k);
                    if (!(num1 > num2)) continue;
                    isGT = true;
                    continue block2;
                }
            }
        } else if (obj2.isString()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block4: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = obj2.stringValue();
                    if (s1.compareTo(s2) <= 0) continue;
                    isGT = true;
                    continue block4;
                }
            }
        } else {
            isGT = this.doubleValue() > obj2.doubleValue();
        }
        return isGT;
    }

    @Override
    public boolean greaterThanOrEqual(XData obj2) throws XDataException {
        boolean isGTE = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list1 = this.nodeset();
            NodeList list2 = obj2.nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            block0: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = XNode.getStringFromNode(list2.item(k));
                    if (s1.compareTo(s2) < 0) continue;
                    isGTE = true;
                    continue block0;
                }
            }
        } else if (obj2.isBoolean()) {
            double num1 = this.booleanValue() ? 1.0 : 0.0;
            double num2 = obj2.doubleValue();
            isGTE = num1 >= num2;
        } else if (obj2.isNumber()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block2: for (int i = 0; i < len1; ++i) {
                double num1 = this.doubleValue(i);
                for (int k = 0; k < len2; ++k) {
                    double num2 = obj2.doubleValue(k);
                    if (!(num1 >= num2)) continue;
                    isGTE = true;
                    continue block2;
                }
            }
        } else if (obj2.isString()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block4: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = obj2.stringValue();
                    if (s1.compareTo(s2) < 0) continue;
                    isGTE = true;
                    continue block4;
                }
            }
        } else {
            isGTE = this.doubleValue() >= obj2.doubleValue();
        }
        return isGTE;
    }

    @Override
    public boolean equals(XData obj2) throws XDataException {
        boolean isEqual = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list1 = this.nodeset();
            NodeList list2 = obj2.nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            block0: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = XNode.getStringFromNode(list2.item(k));
                    if (!s2.equals(s1)) continue;
                    isEqual = true;
                    continue block0;
                }
            }
        } else if (obj2.isBoolean()) {
            isEqual = this.booleanValue() == obj2.booleanValue();
        } else if (obj2.isNumber()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block2: for (int i = 0; i < len1; ++i) {
                double num1 = this.doubleValue(i);
                for (int k = 0; k < len2; ++k) {
                    double num2 = obj2.doubleValue(k);
                    if (num1 != num2) continue;
                    isEqual = true;
                    continue block2;
                }
            }
        } else if (obj2.isString()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block4: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = obj2.stringValue();
                    if (!s1.equals(s2)) continue;
                    isEqual = true;
                    continue block4;
                }
            }
        } else {
            isEqual = super.equals(obj2);
        }
        return isEqual;
    }

    @Override
    public boolean notEquals(XData obj2) throws XDataException {
        boolean notEqual = false;
        int type = obj2.getType();
        if (obj2.isNode()) {
            NodeList list1 = this.nodeset();
            NodeList list2 = obj2.nodeset();
            int len1 = list1.getLength();
            int len2 = list2.getLength();
            block0: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = XNode.getStringFromNode(list2.item(k));
                    if (s2.equals(s1)) continue;
                    notEqual = true;
                    continue block0;
                }
            }
        } else if (obj2.isBoolean()) {
            notEqual = this.booleanValue() != obj2.booleanValue();
        } else if (obj2.isNumber()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block2: for (int i = 0; i < len1; ++i) {
                double num1 = this.doubleValue(i);
                for (int k = 0; k < len2; ++k) {
                    double num2 = obj2.doubleValue(k);
                    if (num1 == num2) continue;
                    notEqual = true;
                    continue block2;
                }
            }
        } else if (obj2.isString()) {
            NodeList list1 = this.nodeset();
            int len1 = list1.getLength();
            int len2 = obj2.size();
            block4: for (int i = 0; i < len1; ++i) {
                String s1 = XNode.getStringFromNode(list1.item(i));
                for (int k = 0; k < len2; ++k) {
                    String s2 = obj2.stringValue();
                    if (s1.equals(s2)) continue;
                    notEqual = true;
                    continue block4;
                }
            }
        } else {
            notEqual = super.notEquals(obj2);
        }
        return notEqual;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public XDataSet extendDataSet(int length) {
        NodeListImpl nl = new NodeListImpl(length);
        this.count = this.m_val.getLength();
        if (this.count == 0) {
            return new XNodeSet(nl);
        }
        for (int i = 0; i < length; ++i) {
            nl.addElement(this.m_val.item(i % this.count));
        }
        return new XNodeSet(nl);
    }

    @Override
    public void setValue(int index, boolean value) throws XDataException {
        this.setValue(index, String.valueOf(value));
    }

    @Override
    public void setValue(int index, int value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        this.setValue0(index, s);
    }

    @Override
    public void setValue(int index, long value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        this.setValue0(index, s);
    }

    @Override
    public void setValue(int index, float value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        this.setValue0(index, s);
    }

    @Override
    public void setValue(int index, double value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : String.valueOf(value);
        this.setValue0(index, s);
    }

    @Override
    public void setValue(int index, String value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : value;
        this.setValue0(index, s);
    }

    private void setValue0(int index, String value) throws XDataException {
        if (index < this.m_val.getLength()) {
            Node node = this.m_val.item(index);
            XNode.setNodeData(node, value);
        }
    }

    @Override
    public void setValue(int index, Date value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value) : (value != null ? DateFormat.getDateTimeInstance().format(value) : "");
        this.setValue0(index, s);
    }

    @Override
    public synchronized void expendsCapacity(int minCapacity) {
        NodeListImpl mnl;
        int oldCapacity = this.m_val.getLength();
        if (minCapacity <= oldCapacity) {
            return;
        }
        if (this.m_val instanceof NodeListImpl) {
            mnl = (NodeListImpl)this.m_val;
        } else {
            mnl = new NodeListImpl(this.m_val);
            this.m_val = mnl;
        }
        mnl.ensureCapacity(minCapacity);
        XNodeSet.expectCapacity(mnl.size(), minCapacity);
    }

    @Override
    public void setValue(int index, Node value) throws XDataException {
        NodeListImpl mnl;
        if (this.m_val instanceof NodeListImpl) {
            mnl = (NodeListImpl)this.m_val;
        } else {
            mnl = new NodeListImpl(this.m_val);
            this.m_val = mnl;
        }
        int n = mnl.size();
        if (index < n) {
            mnl.setElementAt(value, index);
        } else {
            for (int i = n; i <= index; ++i) {
                mnl.addElement(null);
            }
            mnl.setElementAt(value, index);
        }
    }

    @Override
    public void setValue(int index, XData value) throws XDataException {
        String s = this.typeDecl != null ? this.typeDecl.formatValue(value, index) : value.stringValue();
        this.setValue(index, s);
    }

    @Override
    public XDataViewer[] getChildren() {
        int n = this.size();
        XDataViewer[] res = new XDataViewer[n];
        for (int i = 0; i < n; ++i) {
            XNode node = new XNode(this.nodeValue(i));
            node.setTypeDecl(this.getTypeDecl());
            res[i] = node;
        }
        return res;
    }
}

